/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef MODEL_PROGRAMCONTROL_IMPL_HPP
#define MODEL_PROGRAMCONTROL_IMPL_HPP

#include "ModelAPI.hpp"
#include "ModelObject_Impl.hpp"

namespace openstudio {
namespace model {

  namespace detail {

    /** ProgramControl_Impl is a ModelObject_Impl that is the implementation class for ProgramControl.*/
    class MODEL_API ProgramControl_Impl : public ModelObject_Impl
    {

      // TODO: Add relationships for objects related to this one, but not pointed to by the underlying data.
      //       Such relationships can be generated by the GenerateRelationships.rb script.
     public:
      /** @name Constructors and Destructors */
      //@{

      ProgramControl_Impl(const IdfObject& idfObject, Model_Impl* model, bool keepHandle);

      ProgramControl_Impl(const openstudio::detail::WorkspaceObject_Impl& other, Model_Impl* model, bool keepHandle);

      ProgramControl_Impl(const ProgramControl_Impl& other, Model_Impl* model, bool keepHandle);

      virtual ~ProgramControl_Impl() override = default;

      //@}

      /** @name Virtual Methods */
      //@{

      virtual const std::vector<std::string>& outputVariableNames() const override;

      virtual IddObjectType iddObjectType() const override;

      //@}
      /** @name Getters */
      //@{

      boost::optional<int> numberofThreadsAllowed() const;

      //@}
      /** @name Setters */
      //@{

      bool setNumberofThreadsAllowed(boost::optional<int> numberofThreadsAllowed);

      void resetNumberofThreadsAllowed();

      //@}
      /** @name Other */
      //@{

      //@}
     protected:
     private:
      REGISTER_LOGGER("openstudio.model.ProgramControl");
    };

  }  // namespace detail

}  // namespace model
}  // namespace openstudio

#endif  // MODEL_PROGRAMCONTROL_IMPL_HPP
