/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_ZONE_FIELDENUMS_HXX
#define UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_ZONE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AirflowNetwork_MultiZone_ZoneFields
 *  \brief Enumeration of AirflowNetwork:MultiZone:Zone's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AirflowNetwork_MultiZone_ZoneFields, )
#else
class AirflowNetwork_MultiZone_ZoneFields: public ::EnumBase<AirflowNetwork_MultiZone_ZoneFields> {
 public: 
  enum domain 
  {
ZoneName, VentilationControlMode, VentilationControlZoneTemperatureSetpointScheduleName, MinimumVentingOpenFactor, IndoorandOutdoorTemperatureDifferenceLowerLimitForMaximumVentingOpenFactor, IndoorandOutdoorTemperatureDifferenceUpperLimitforMinimumVentingOpenFactor, IndoorandOutdoorEnthalpyDifferenceLowerLimitForMaximumVentingOpenFactor, IndoorandOutdoorEnthalpyDifferenceUpperLimitforMinimumVentingOpenFactor, VentingAvailabilityScheduleName, SingleSidedWindPressureCoefficientAlgorithm, FacadeWidth, OccupantVentilationControlName,   };
  AirflowNetwork_MultiZone_ZoneFields()
   : EnumBase<AirflowNetwork_MultiZone_ZoneFields>(ZoneName) {} 
  AirflowNetwork_MultiZone_ZoneFields(const std::string &t_name) 
   : EnumBase<AirflowNetwork_MultiZone_ZoneFields>(t_name) {} 
  AirflowNetwork_MultiZone_ZoneFields(int t_value) 
   : EnumBase<AirflowNetwork_MultiZone_ZoneFields>(t_value) {} 
  static std::string enumName() 
  { return "AirflowNetwork_MultiZone_ZoneFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AirflowNetwork_MultiZone_ZoneFields>::integer_value()); }
   private:
    friend class EnumBase<AirflowNetwork_MultiZone_ZoneFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AirflowNetwork_MultiZone_ZoneFields::ZoneName, "ZoneName", "Zone Name"},
{ AirflowNetwork_MultiZone_ZoneFields::VentilationControlMode, "VentilationControlMode", "Ventilation Control Mode"},
{ AirflowNetwork_MultiZone_ZoneFields::VentilationControlZoneTemperatureSetpointScheduleName, "VentilationControlZoneTemperatureSetpointScheduleName", "Ventilation Control Zone Temperature Setpoint Schedule Name"},
{ AirflowNetwork_MultiZone_ZoneFields::MinimumVentingOpenFactor, "MinimumVentingOpenFactor", "Minimum Venting Open Factor"},
{ AirflowNetwork_MultiZone_ZoneFields::IndoorandOutdoorTemperatureDifferenceLowerLimitForMaximumVentingOpenFactor, "IndoorandOutdoorTemperatureDifferenceLowerLimitForMaximumVentingOpenFactor", "Indoor and Outdoor Temperature Difference Lower Limit For Maximum Venting Open Factor"},
{ AirflowNetwork_MultiZone_ZoneFields::IndoorandOutdoorTemperatureDifferenceUpperLimitforMinimumVentingOpenFactor, "IndoorandOutdoorTemperatureDifferenceUpperLimitforMinimumVentingOpenFactor", "Indoor and Outdoor Temperature Difference Upper Limit for Minimum Venting Open Factor"},
{ AirflowNetwork_MultiZone_ZoneFields::IndoorandOutdoorEnthalpyDifferenceLowerLimitForMaximumVentingOpenFactor, "IndoorandOutdoorEnthalpyDifferenceLowerLimitForMaximumVentingOpenFactor", "Indoor and Outdoor Enthalpy Difference Lower Limit For Maximum Venting Open Factor"},
{ AirflowNetwork_MultiZone_ZoneFields::IndoorandOutdoorEnthalpyDifferenceUpperLimitforMinimumVentingOpenFactor, "IndoorandOutdoorEnthalpyDifferenceUpperLimitforMinimumVentingOpenFactor", "Indoor and Outdoor Enthalpy Difference Upper Limit for Minimum Venting Open Factor"},
{ AirflowNetwork_MultiZone_ZoneFields::VentingAvailabilityScheduleName, "VentingAvailabilityScheduleName", "Venting Availability Schedule Name"},
{ AirflowNetwork_MultiZone_ZoneFields::SingleSidedWindPressureCoefficientAlgorithm, "SingleSidedWindPressureCoefficientAlgorithm", "Single Sided Wind Pressure Coefficient Algorithm"},
{ AirflowNetwork_MultiZone_ZoneFields::FacadeWidth, "FacadeWidth", "Facade Width"},
{ AirflowNetwork_MultiZone_ZoneFields::OccupantVentilationControlName, "OccupantVentilationControlName", "Occupant Ventilation Control Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AirflowNetwork_MultiZone_ZoneFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AirflowNetwork_MultiZone_ZoneFields> OptionalAirflowNetwork_MultiZone_ZoneFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_ZONE_FIELDENUMS_HXX
