/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) 2008-2023, Alliance for Sustainable Energy, LLC, and other contributors. All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
*  following conditions are met:
*
*  (1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following
*  disclaimer.
*
*  (2) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
*  disclaimer in the documentation and/or other materials provided with the distribution.
*
*  (3) Neither the name of the copyright holder nor the names of any contributors may be used to endorse or promote products
*  derived from this software without specific prior written permission from the respective party.
*
*  (4) Other than as required in clauses (1) and (2), distributions in any form of modifications or other derivative works
*  may not use the "OpenStudio" trademark, "OS", "os", or any other confusingly similar designation without specific prior
*  written permission from Alliance for Sustainable Energy, LLC.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND ANY CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
*  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
*  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER(S), ANY CONTRIBUTORS, THE UNITED STATES GOVERNMENT, OR THE UNITED
*  STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR EMPLOYEES, BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
*  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
*  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
*  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_CHILLER_CONSTANTCOP_FIELDENUMS_HXX
#define UTILITIES_IDD_CHILLER_CONSTANTCOP_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Chiller_ConstantCOPFields
 *  \brief Enumeration of Chiller:ConstantCOP's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Chiller_ConstantCOPFields, )
#else
class Chiller_ConstantCOPFields: public ::EnumBase<Chiller_ConstantCOPFields> {
 public: 
  enum domain 
  {
Name, NominalCapacity, NominalCOP, DesignChilledWaterFlowRate, DesignCondenserWaterFlowRate, ChilledWaterInletNodeName, ChilledWaterOutletNodeName, CondenserInletNodeName, CondenserOutletNodeName, CondenserType, ChillerFlowMode, SizingFactor, BasinHeaterCapacity, BasinHeaterSetpointTemperature, BasinHeaterOperatingScheduleName, ThermosiphonCapacityFractionCurveName, ThermosiphonMinimumTemperatureDifference,   };
  Chiller_ConstantCOPFields()
   : EnumBase<Chiller_ConstantCOPFields>(Name) {} 
  Chiller_ConstantCOPFields(const std::string &t_name) 
   : EnumBase<Chiller_ConstantCOPFields>(t_name) {} 
  Chiller_ConstantCOPFields(int t_value) 
   : EnumBase<Chiller_ConstantCOPFields>(t_value) {} 
  static std::string enumName() 
  { return "Chiller_ConstantCOPFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Chiller_ConstantCOPFields>::integer_value()); }
   private:
    friend class EnumBase<Chiller_ConstantCOPFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Chiller_ConstantCOPFields::Name, "Name", "Name"},
{ Chiller_ConstantCOPFields::NominalCapacity, "NominalCapacity", "Nominal Capacity"},
{ Chiller_ConstantCOPFields::NominalCOP, "NominalCOP", "Nominal COP"},
{ Chiller_ConstantCOPFields::DesignChilledWaterFlowRate, "DesignChilledWaterFlowRate", "Design Chilled Water Flow Rate"},
{ Chiller_ConstantCOPFields::DesignCondenserWaterFlowRate, "DesignCondenserWaterFlowRate", "Design Condenser Water Flow Rate"},
{ Chiller_ConstantCOPFields::ChilledWaterInletNodeName, "ChilledWaterInletNodeName", "Chilled Water Inlet Node Name"},
{ Chiller_ConstantCOPFields::ChilledWaterOutletNodeName, "ChilledWaterOutletNodeName", "Chilled Water Outlet Node Name"},
{ Chiller_ConstantCOPFields::CondenserInletNodeName, "CondenserInletNodeName", "Condenser Inlet Node Name"},
{ Chiller_ConstantCOPFields::CondenserOutletNodeName, "CondenserOutletNodeName", "Condenser Outlet Node Name"},
{ Chiller_ConstantCOPFields::CondenserType, "CondenserType", "Condenser Type"},
{ Chiller_ConstantCOPFields::ChillerFlowMode, "ChillerFlowMode", "Chiller Flow Mode"},
{ Chiller_ConstantCOPFields::SizingFactor, "SizingFactor", "Sizing Factor"},
{ Chiller_ConstantCOPFields::BasinHeaterCapacity, "BasinHeaterCapacity", "Basin Heater Capacity"},
{ Chiller_ConstantCOPFields::BasinHeaterSetpointTemperature, "BasinHeaterSetpointTemperature", "Basin Heater Setpoint Temperature"},
{ Chiller_ConstantCOPFields::BasinHeaterOperatingScheduleName, "BasinHeaterOperatingScheduleName", "Basin Heater Operating Schedule Name"},
{ Chiller_ConstantCOPFields::ThermosiphonCapacityFractionCurveName, "ThermosiphonCapacityFractionCurveName", "Thermosiphon Capacity Fraction Curve Name"},
{ Chiller_ConstantCOPFields::ThermosiphonMinimumTemperatureDifference, "ThermosiphonMinimumTemperatureDifference", "Thermosiphon Minimum Temperature Difference"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Chiller_ConstantCOPFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Chiller_ConstantCOPFields> OptionalChiller_ConstantCOPFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_CHILLER_CONSTANTCOP_FIELDENUMS_HXX
