/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) 2008-2023, Alliance for Sustainable Energy, LLC, and other contributors. All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
*  following conditions are met:
*
*  (1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following
*  disclaimer.
*
*  (2) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
*  disclaimer in the documentation and/or other materials provided with the distribution.
*
*  (3) Neither the name of the copyright holder nor the names of any contributors may be used to endorse or promote products
*  derived from this software without specific prior written permission from the respective party.
*
*  (4) Other than as required in clauses (1) and (2), distributions in any form of modifications or other derivative works
*  may not use the "OpenStudio" trademark, "OS", "os", or any other confusingly similar designation without specific prior
*  written permission from Alliance for Sustainable Energy, LLC.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND ANY CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
*  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
*  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER(S), ANY CONTRIBUTORS, THE UNITED STATES GOVERNMENT, OR THE UNITED
*  STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR EMPLOYEES, BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
*  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
*  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
*  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX
#define UTILITIES_IDD_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class HeatPump_AirToWater_FuelFired_HeatingFields
 *  \brief Enumeration of HeatPump:AirToWater:FuelFired:Heating's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(HeatPump_AirToWater_FuelFired_HeatingFields, )
#else
class HeatPump_AirToWater_FuelFired_HeatingFields: public ::EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields> {
 public: 
  enum domain 
  {
Name, WaterInletNodeName, WaterOutletNodeName, AirSourceNodeName, CompanionCoolingHeatPumpName, FuelType, EndUseSubcategory, NominalHeatingCapacity, NominalCOP, DesignFlowRate, DesignSupplyTemperature, DesignTemperatureLift, SizingFactor, FlowMode, OutdoorAirTemperatureCurveInputVariable, WaterTemperatureCurveInputVariable, NormalizedCapacityFunctionofTemperatureCurveName, FuelEnergyInputRatioFunctionofTemperatureCurveName, FuelEnergyInputRatioFunctionofPLRCurveName, MinimumPartLoadRatio, MaximumPartLoadRatio, DefrostControlType, DefrostOperationTimeFraction, FuelEnergyInputRatioDefrostAdjustmentCurveName, ResistiveDefrostHeaterCapacity, MaximumOutdoorDrybulbTemperatureforDefrostOperation, CyclingRatioFactorCurveName, NominalAuxiliaryElectricPower, AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName, AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName, StandbyElectricPower,   };
  HeatPump_AirToWater_FuelFired_HeatingFields()
   : EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields>(Name) {} 
  HeatPump_AirToWater_FuelFired_HeatingFields(const std::string &t_name) 
   : EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields>(t_name) {} 
  HeatPump_AirToWater_FuelFired_HeatingFields(int t_value) 
   : EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields>(t_value) {} 
  static std::string enumName() 
  { return "HeatPump_AirToWater_FuelFired_HeatingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields>::integer_value()); }
   private:
    friend class EnumBase<HeatPump_AirToWater_FuelFired_HeatingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ HeatPump_AirToWater_FuelFired_HeatingFields::Name, "Name", "Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::WaterInletNodeName, "WaterInletNodeName", "Water Inlet Node Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::WaterOutletNodeName, "WaterOutletNodeName", "Water Outlet Node Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::AirSourceNodeName, "AirSourceNodeName", "Air Source Node Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::CompanionCoolingHeatPumpName, "CompanionCoolingHeatPumpName", "Companion Cooling Heat Pump Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::FuelType, "FuelType", "Fuel Type"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::NominalHeatingCapacity, "NominalHeatingCapacity", "Nominal Heating Capacity"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::NominalCOP, "NominalCOP", "Nominal COP"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::DesignFlowRate, "DesignFlowRate", "Design Flow Rate"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::DesignSupplyTemperature, "DesignSupplyTemperature", "Design Supply Temperature"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::DesignTemperatureLift, "DesignTemperatureLift", "Design Temperature Lift"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::SizingFactor, "SizingFactor", "Sizing Factor"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::FlowMode, "FlowMode", "Flow Mode"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::OutdoorAirTemperatureCurveInputVariable, "OutdoorAirTemperatureCurveInputVariable", "Outdoor Air Temperature Curve Input Variable"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::WaterTemperatureCurveInputVariable, "WaterTemperatureCurveInputVariable", "Water Temperature Curve Input Variable"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::NormalizedCapacityFunctionofTemperatureCurveName, "NormalizedCapacityFunctionofTemperatureCurveName", "Normalized Capacity Function of Temperature Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioFunctionofTemperatureCurveName, "FuelEnergyInputRatioFunctionofTemperatureCurveName", "Fuel Energy Input Ratio Function of Temperature Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioFunctionofPLRCurveName, "FuelEnergyInputRatioFunctionofPLRCurveName", "Fuel Energy Input Ratio Function of PLR Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::MinimumPartLoadRatio, "MinimumPartLoadRatio", "Minimum Part Load Ratio"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::MaximumPartLoadRatio, "MaximumPartLoadRatio", "Maximum Part Load Ratio"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::DefrostControlType, "DefrostControlType", "Defrost Control Type"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::DefrostOperationTimeFraction, "DefrostOperationTimeFraction", "Defrost Operation Time Fraction"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioDefrostAdjustmentCurveName, "FuelEnergyInputRatioDefrostAdjustmentCurveName", "Fuel Energy Input Ratio Defrost Adjustment Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::ResistiveDefrostHeaterCapacity, "ResistiveDefrostHeaterCapacity", "Resistive Defrost Heater Capacity"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::MaximumOutdoorDrybulbTemperatureforDefrostOperation, "MaximumOutdoorDrybulbTemperatureforDefrostOperation", "Maximum Outdoor Dry-bulb Temperature for Defrost Operation"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::CyclingRatioFactorCurveName, "CyclingRatioFactorCurveName", "Cycling Ratio Factor Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::NominalAuxiliaryElectricPower, "NominalAuxiliaryElectricPower", "Nominal Auxiliary Electric Power"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName, "AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName", "Auxiliary Electric Energy Input Ratio Function of Temperature Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName, "AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName", "Auxiliary Electric Energy Input Ratio Function of PLR Curve Name"},
{ HeatPump_AirToWater_FuelFired_HeatingFields::StandbyElectricPower, "StandbyElectricPower", "Standby Electric Power"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const HeatPump_AirToWater_FuelFired_HeatingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<HeatPump_AirToWater_FuelFired_HeatingFields> OptionalHeatPump_AirToWater_FuelFired_HeatingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX
