/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) 2008-2023, Alliance for Sustainable Energy, LLC, and other contributors. All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
*  following conditions are met:
*
*  (1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following
*  disclaimer.
*
*  (2) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
*  disclaimer in the documentation and/or other materials provided with the distribution.
*
*  (3) Neither the name of the copyright holder nor the names of any contributors may be used to endorse or promote products
*  derived from this software without specific prior written permission from the respective party.
*
*  (4) Other than as required in clauses (1) and (2), distributions in any form of modifications or other derivative works
*  may not use the "OpenStudio" trademark, "OS", "os", or any other confusingly similar designation without specific prior
*  written permission from Alliance for Sustainable Energy, LLC.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND ANY CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
*  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
*  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER(S), ANY CONTRIBUTORS, THE UNITED STATES GOVERNMENT, OR THE UNITED
*  STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR EMPLOYEES, BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
*  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
*  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
*  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_REFRIGERATION_WALKIN_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_REFRIGERATION_WALKIN_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Refrigeration_WalkInFields
 *  \brief Enumeration of OS:Refrigeration:WalkIn's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Refrigeration_WalkInFields, )
#else
class OS_Refrigeration_WalkInFields: public ::EnumBase<OS_Refrigeration_WalkInFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, RatedCoilCoolingCapacity, OperatingTemperature, RatedCoolingSourceTemperature, RatedTotalHeatingPower, HeatingPowerScheduleName, RatedCoolingCoilFanPower, RatedCirculationFanPower, RatedTotalLightingPower, LightingScheduleName, DefrostType, DefrostControlType, DefrostScheduleName, DefrostDripDownScheduleName, DefrostPower, TemperatureTerminationDefrostFractiontoIce, RestockingScheduleName, AverageRefrigerantChargeInventory, InsulatedFloorSurfaceArea, InsulatedFloorUValue, WalkInDefrostCycleParametersName,   };
  OS_Refrigeration_WalkInFields()
   : EnumBase<OS_Refrigeration_WalkInFields>(Handle) {} 
  OS_Refrigeration_WalkInFields(const std::string &t_name) 
   : EnumBase<OS_Refrigeration_WalkInFields>(t_name) {} 
  OS_Refrigeration_WalkInFields(int t_value) 
   : EnumBase<OS_Refrigeration_WalkInFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Refrigeration_WalkInFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Refrigeration_WalkInFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Refrigeration_WalkInFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Refrigeration_WalkInFields::Handle, "Handle", "Handle"},
{ OS_Refrigeration_WalkInFields::Name, "Name", "Name"},
{ OS_Refrigeration_WalkInFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_Refrigeration_WalkInFields::RatedCoilCoolingCapacity, "RatedCoilCoolingCapacity", "Rated Coil Cooling Capacity"},
{ OS_Refrigeration_WalkInFields::OperatingTemperature, "OperatingTemperature", "Operating Temperature"},
{ OS_Refrigeration_WalkInFields::RatedCoolingSourceTemperature, "RatedCoolingSourceTemperature", "Rated Cooling Source Temperature"},
{ OS_Refrigeration_WalkInFields::RatedTotalHeatingPower, "RatedTotalHeatingPower", "Rated Total Heating Power"},
{ OS_Refrigeration_WalkInFields::HeatingPowerScheduleName, "HeatingPowerScheduleName", "Heating Power Schedule Name"},
{ OS_Refrigeration_WalkInFields::RatedCoolingCoilFanPower, "RatedCoolingCoilFanPower", "Rated Cooling Coil Fan Power"},
{ OS_Refrigeration_WalkInFields::RatedCirculationFanPower, "RatedCirculationFanPower", "Rated Circulation Fan Power"},
{ OS_Refrigeration_WalkInFields::RatedTotalLightingPower, "RatedTotalLightingPower", "Rated Total Lighting Power"},
{ OS_Refrigeration_WalkInFields::LightingScheduleName, "LightingScheduleName", "Lighting Schedule Name"},
{ OS_Refrigeration_WalkInFields::DefrostType, "DefrostType", "Defrost Type"},
{ OS_Refrigeration_WalkInFields::DefrostControlType, "DefrostControlType", "Defrost Control Type"},
{ OS_Refrigeration_WalkInFields::DefrostScheduleName, "DefrostScheduleName", "Defrost Schedule Name"},
{ OS_Refrigeration_WalkInFields::DefrostDripDownScheduleName, "DefrostDripDownScheduleName", "Defrost Drip-Down Schedule Name"},
{ OS_Refrigeration_WalkInFields::DefrostPower, "DefrostPower", "Defrost Power"},
{ OS_Refrigeration_WalkInFields::TemperatureTerminationDefrostFractiontoIce, "TemperatureTerminationDefrostFractiontoIce", "Temperature Termination Defrost Fraction to Ice"},
{ OS_Refrigeration_WalkInFields::RestockingScheduleName, "RestockingScheduleName", "Restocking Schedule Name"},
{ OS_Refrigeration_WalkInFields::AverageRefrigerantChargeInventory, "AverageRefrigerantChargeInventory", "Average Refrigerant Charge Inventory"},
{ OS_Refrigeration_WalkInFields::InsulatedFloorSurfaceArea, "InsulatedFloorSurfaceArea", "Insulated Floor Surface Area"},
{ OS_Refrigeration_WalkInFields::InsulatedFloorUValue, "InsulatedFloorUValue", "Insulated Floor U-Value"},
{ OS_Refrigeration_WalkInFields::WalkInDefrostCycleParametersName, "WalkInDefrostCycleParametersName", "WalkIn Defrost Cycle Parameters Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Refrigeration_WalkInFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Refrigeration_WalkInFields> OptionalOS_Refrigeration_WalkInFields ;
#endif

/** \class OS_Refrigeration_WalkInExtensibleFields
 *  \brief Enumeration of OS:Refrigeration:WalkIn's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Refrigeration_WalkInExtensibleFields, )
#else
class OS_Refrigeration_WalkInExtensibleFields: public ::EnumBase<OS_Refrigeration_WalkInExtensibleFields> {
 public: 
  enum domain 
  {
WalkInZoneBoundary,   };
  OS_Refrigeration_WalkInExtensibleFields()
   : EnumBase<OS_Refrigeration_WalkInExtensibleFields>(WalkInZoneBoundary) {} 
  OS_Refrigeration_WalkInExtensibleFields(const std::string &t_name) 
   : EnumBase<OS_Refrigeration_WalkInExtensibleFields>(t_name) {} 
  OS_Refrigeration_WalkInExtensibleFields(int t_value) 
   : EnumBase<OS_Refrigeration_WalkInExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Refrigeration_WalkInExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Refrigeration_WalkInExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Refrigeration_WalkInExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Refrigeration_WalkInExtensibleFields::WalkInZoneBoundary, "WalkInZoneBoundary", "WalkIn Zone Boundary"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Refrigeration_WalkInExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Refrigeration_WalkInExtensibleFields> OptionalOS_Refrigeration_WalkInExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_REFRIGERATION_WALKIN_FIELDENUMS_HXX
