#ifndef OPENSTUDIO_HXX
#define OPENSTUDIO_HXX

#include <string>
#include <string_view>

// Support for Ninja on Windows (Ninja isn't multi-configuration while MSVC is)
#define NINJA

// Return the version in MAJOR.MINOR.PATCH format (eg '3.0.0')
inline std::string openStudioVersion() {
  return "3.9.1";
}

// Includes prerelease tag if any, and build sha, eg: '3.0.0-rc1+baflkdhsia'
inline std::string openStudioLongVersion() {
  return "3.9.1-alpha+00379f90ca";
}

inline std::string openStudioVersionMajor() {
  return "3";
}

inline std::string openStudioVersionMinor() {
  return "9";
}

inline std::string openStudioVersionPatch() {
  return "1";
}

inline std::string openStudioVersionPrerelease() {
  return "alpha";
}

inline std::string openStudioVersionBuildSHA() {
  return "00379f90ca";
}

inline int energyPlusVersionMajor() {
  return 24;
}

inline int energyPlusVersionMinor() {
  return 2;
}

inline int energyPlusVersionPatch() {
  return 0;
}

inline std::string energyPlusVersion() {
  return "24.2.0";
}

inline std::string energyPlusBuildSHA() {
  return "94a887817b";
}

inline std::string rubyLibDir() {
  return "D:/git/OpenStudio/ruby/";
}

inline std::string rubyOpenStudioDir() {
#ifdef WIN32
#  ifdef NINJA
  return "D:/git/OS-build-release-v2/ruby/";
#  else
  return "D:/git/OS-build-release-v2/ruby/" + std::string(CMAKE_INTDIR) + "/";
#  endif
#else
  return "D:/git/OS-build-release-v2/ruby/";
#endif
}

namespace openstudio {
namespace detail {

inline constexpr int cx_openStudioVersionMajor() {
  return 3;
}
inline constexpr int cx_openStudioVersionMinor() {
  return 9;
}
inline constexpr int cx_openStudioVersionPatch() {
  return 1;
}
inline constexpr std::string_view cx_openStudioVersion() {
  return "3.9.1";
}

}  // namespace detail
}  // namespace openstudio

#endif  // OPENSTUDIO_HXX
