/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) 2008-2023, Alliance for Sustainable Energy, LLC, and other contributors. All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
*  following conditions are met:
*
*  (1) Redistributions of source code must retain the above copyright notice, this list of conditions and the following
*  disclaimer.
*
*  (2) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
*  disclaimer in the documentation and/or other materials provided with the distribution.
*
*  (3) Neither the name of the copyright holder nor the names of any contributors may be used to endorse or promote products
*  derived from this software without specific prior written permission from the respective party.
*
*  (4) Other than as required in clauses (1) and (2), distributions in any form of modifications or other derivative works
*  may not use the "OpenStudio" trademark, "OS", "os", or any other confusingly similar designation without specific prior
*  written permission from Alliance for Sustainable Energy, LLC.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND ANY CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
*  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
*  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER(S), ANY CONTRIBUTORS, THE UNITED STATES GOVERNMENT, OR THE UNITED
*  STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR EMPLOYEES, BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
*  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
*  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
*  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_HVACTEMPLATE_SYSTEM_CONSTANTVOLUME_FIELDENUMS_HXX
#define UTILITIES_IDD_HVACTEMPLATE_SYSTEM_CONSTANTVOLUME_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class HVACTemplate_System_ConstantVolumeFields
 *  \brief Enumeration of HVACTemplate:System:ConstantVolume's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(HVACTemplate_System_ConstantVolumeFields, )
#else
class HVACTemplate_System_ConstantVolumeFields: public ::EnumBase<HVACTemplate_System_ConstantVolumeFields> {
 public: 
  enum domain 
  {
Name, SystemAvailabilityScheduleName, SupplyFanMaximumFlowRate, SupplyFanTotalEfficiency, SupplyFanDeltaPressure, SupplyFanMotorEfficiency, SupplyFanMotorinAirStreamFraction, SupplyFanPlacement, CoolingCoilType, CoolingCoilAvailabilityScheduleName, CoolingCoilSetpointControlType, CoolingCoilControlZonename, CoolingCoilDesignSetpointTemperature, CoolingCoilSetpointScheduleName, CoolingCoilSetpointatOutdoorDryBulbLow, CoolingCoilResetOutdoorDryBulbLow, CoolingCoilSetpointatOutdoorDryBulbHigh, CoolingCoilResetOutdoorDryBulbHigh, HeatingCoilType, HeatingCoilAvailabilityScheduleName, HeatingCoilSetpointControlType, HeatingCoilControlZonename, HeatingCoilDesignSetpoint, HeatingCoilSetpointScheduleName, HeatingCoilSetpointatOutdoorDryBulbLow, HeatingCoilResetOutdoorDryBulbLow, HeatingCoilSetpointatOutdoorDryBulbHigh, HeatingCoilResetOutdoorDryBulbHigh, HeatingCoilCapacity, GasHeatingCoilEfficiency, GasHeatingCoilParasiticElectricLoad, PreheatCoilType, PreheatCoilAvailabilityScheduleName, PreheatCoilDesignSetpoint, PreheatCoilSetpointScheduleName, GasPreheatCoilEfficiency, GasPreheatCoilParasiticElectricLoad, MaximumOutdoorAirFlowRate, MinimumOutdoorAirFlowRate, MinimumOutdoorAirScheduleName, EconomizerType, EconomizerUpperTemperatureLimit, EconomizerLowerTemperatureLimit, EconomizerUpperEnthalpyLimit, EconomizerMaximumLimitDewpointTemperature, SupplyPlenumName, ReturnPlenumName, NightCycleControl, NightCycleControlZoneName, HeatRecoveryType, SensibleHeatRecoveryEffectiveness, LatentHeatRecoveryEffectiveness, HeatRecoveryHeatExchangerType, HeatRecoveryFrostControlType, DehumidificationControlType, DehumidificationControlZoneName, DehumidificationRelativeHumiditySetpoint, DehumidificationRelativeHumiditySetpointScheduleName, HumidifierType, HumidifierAvailabilityScheduleName, HumidifierRatedCapacity, HumidifierRatedElectricPower, HumidifierControlZoneName, HumidifierRelativeHumiditySetpoint, HumidifierRelativeHumiditySetpointScheduleName, ReturnFan, ReturnFanTotalEfficiency, ReturnFanDeltaPressure, ReturnFanMotorEfficiency, ReturnFanMotorinAirStreamFraction,   };
  HVACTemplate_System_ConstantVolumeFields()
   : EnumBase<HVACTemplate_System_ConstantVolumeFields>(Name) {} 
  HVACTemplate_System_ConstantVolumeFields(const std::string &t_name) 
   : EnumBase<HVACTemplate_System_ConstantVolumeFields>(t_name) {} 
  HVACTemplate_System_ConstantVolumeFields(int t_value) 
   : EnumBase<HVACTemplate_System_ConstantVolumeFields>(t_value) {} 
  static std::string enumName() 
  { return "HVACTemplate_System_ConstantVolumeFields"; }
  domain value() const { return static_cast<domain>(EnumBase<HVACTemplate_System_ConstantVolumeFields>::integer_value()); }
   private:
    friend class EnumBase<HVACTemplate_System_ConstantVolumeFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ HVACTemplate_System_ConstantVolumeFields::Name, "Name", "Name"},
{ HVACTemplate_System_ConstantVolumeFields::SystemAvailabilityScheduleName, "SystemAvailabilityScheduleName", "System Availability Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanMaximumFlowRate, "SupplyFanMaximumFlowRate", "Supply Fan Maximum Flow Rate"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanTotalEfficiency, "SupplyFanTotalEfficiency", "Supply Fan Total Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanDeltaPressure, "SupplyFanDeltaPressure", "Supply Fan Delta Pressure"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanMotorEfficiency, "SupplyFanMotorEfficiency", "Supply Fan Motor Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanMotorinAirStreamFraction, "SupplyFanMotorinAirStreamFraction", "Supply Fan Motor in Air Stream Fraction"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyFanPlacement, "SupplyFanPlacement", "Supply Fan Placement"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilType, "CoolingCoilType", "Cooling Coil Type"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilAvailabilityScheduleName, "CoolingCoilAvailabilityScheduleName", "Cooling Coil Availability Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilSetpointControlType, "CoolingCoilSetpointControlType", "Cooling Coil Setpoint Control Type"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilControlZonename, "CoolingCoilControlZonename", "Cooling Coil Control Zone name"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilDesignSetpointTemperature, "CoolingCoilDesignSetpointTemperature", "Cooling Coil Design Setpoint Temperature"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilSetpointScheduleName, "CoolingCoilSetpointScheduleName", "Cooling Coil Setpoint Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilSetpointatOutdoorDryBulbLow, "CoolingCoilSetpointatOutdoorDryBulbLow", "Cooling Coil Setpoint at Outdoor Dry-Bulb Low"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilResetOutdoorDryBulbLow, "CoolingCoilResetOutdoorDryBulbLow", "Cooling Coil Reset Outdoor Dry-Bulb Low"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilSetpointatOutdoorDryBulbHigh, "CoolingCoilSetpointatOutdoorDryBulbHigh", "Cooling Coil Setpoint at Outdoor Dry-Bulb High"},
{ HVACTemplate_System_ConstantVolumeFields::CoolingCoilResetOutdoorDryBulbHigh, "CoolingCoilResetOutdoorDryBulbHigh", "Cooling Coil Reset Outdoor Dry-Bulb High"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilType, "HeatingCoilType", "Heating Coil Type"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilAvailabilityScheduleName, "HeatingCoilAvailabilityScheduleName", "Heating Coil Availability Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilSetpointControlType, "HeatingCoilSetpointControlType", "Heating Coil Setpoint Control Type"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilControlZonename, "HeatingCoilControlZonename", "Heating Coil Control Zone name"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilDesignSetpoint, "HeatingCoilDesignSetpoint", "Heating Coil Design Setpoint"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilSetpointScheduleName, "HeatingCoilSetpointScheduleName", "Heating Coil Setpoint Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilSetpointatOutdoorDryBulbLow, "HeatingCoilSetpointatOutdoorDryBulbLow", "Heating Coil Setpoint at Outdoor Dry-Bulb Low"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilResetOutdoorDryBulbLow, "HeatingCoilResetOutdoorDryBulbLow", "Heating Coil Reset Outdoor Dry-Bulb Low"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilSetpointatOutdoorDryBulbHigh, "HeatingCoilSetpointatOutdoorDryBulbHigh", "Heating Coil Setpoint at Outdoor Dry-Bulb High"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilResetOutdoorDryBulbHigh, "HeatingCoilResetOutdoorDryBulbHigh", "Heating Coil Reset Outdoor Dry-Bulb High"},
{ HVACTemplate_System_ConstantVolumeFields::HeatingCoilCapacity, "HeatingCoilCapacity", "Heating Coil Capacity"},
{ HVACTemplate_System_ConstantVolumeFields::GasHeatingCoilEfficiency, "GasHeatingCoilEfficiency", "Gas Heating Coil Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::GasHeatingCoilParasiticElectricLoad, "GasHeatingCoilParasiticElectricLoad", "Gas Heating Coil Parasitic Electric Load"},
{ HVACTemplate_System_ConstantVolumeFields::PreheatCoilType, "PreheatCoilType", "Preheat Coil Type"},
{ HVACTemplate_System_ConstantVolumeFields::PreheatCoilAvailabilityScheduleName, "PreheatCoilAvailabilityScheduleName", "Preheat Coil Availability Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::PreheatCoilDesignSetpoint, "PreheatCoilDesignSetpoint", "Preheat Coil Design Setpoint"},
{ HVACTemplate_System_ConstantVolumeFields::PreheatCoilSetpointScheduleName, "PreheatCoilSetpointScheduleName", "Preheat Coil Setpoint Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::GasPreheatCoilEfficiency, "GasPreheatCoilEfficiency", "Gas Preheat Coil Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::GasPreheatCoilParasiticElectricLoad, "GasPreheatCoilParasiticElectricLoad", "Gas Preheat Coil Parasitic Electric Load"},
{ HVACTemplate_System_ConstantVolumeFields::MaximumOutdoorAirFlowRate, "MaximumOutdoorAirFlowRate", "Maximum Outdoor Air Flow Rate"},
{ HVACTemplate_System_ConstantVolumeFields::MinimumOutdoorAirFlowRate, "MinimumOutdoorAirFlowRate", "Minimum Outdoor Air Flow Rate"},
{ HVACTemplate_System_ConstantVolumeFields::MinimumOutdoorAirScheduleName, "MinimumOutdoorAirScheduleName", "Minimum Outdoor Air Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::EconomizerType, "EconomizerType", "Economizer Type"},
{ HVACTemplate_System_ConstantVolumeFields::EconomizerUpperTemperatureLimit, "EconomizerUpperTemperatureLimit", "Economizer Upper Temperature Limit"},
{ HVACTemplate_System_ConstantVolumeFields::EconomizerLowerTemperatureLimit, "EconomizerLowerTemperatureLimit", "Economizer Lower Temperature Limit"},
{ HVACTemplate_System_ConstantVolumeFields::EconomizerUpperEnthalpyLimit, "EconomizerUpperEnthalpyLimit", "Economizer Upper Enthalpy Limit"},
{ HVACTemplate_System_ConstantVolumeFields::EconomizerMaximumLimitDewpointTemperature, "EconomizerMaximumLimitDewpointTemperature", "Economizer Maximum Limit Dewpoint Temperature"},
{ HVACTemplate_System_ConstantVolumeFields::SupplyPlenumName, "SupplyPlenumName", "Supply Plenum Name"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnPlenumName, "ReturnPlenumName", "Return Plenum Name"},
{ HVACTemplate_System_ConstantVolumeFields::NightCycleControl, "NightCycleControl", "Night Cycle Control"},
{ HVACTemplate_System_ConstantVolumeFields::NightCycleControlZoneName, "NightCycleControlZoneName", "Night Cycle Control Zone Name"},
{ HVACTemplate_System_ConstantVolumeFields::HeatRecoveryType, "HeatRecoveryType", "Heat Recovery Type"},
{ HVACTemplate_System_ConstantVolumeFields::SensibleHeatRecoveryEffectiveness, "SensibleHeatRecoveryEffectiveness", "Sensible Heat Recovery Effectiveness"},
{ HVACTemplate_System_ConstantVolumeFields::LatentHeatRecoveryEffectiveness, "LatentHeatRecoveryEffectiveness", "Latent Heat Recovery Effectiveness"},
{ HVACTemplate_System_ConstantVolumeFields::HeatRecoveryHeatExchangerType, "HeatRecoveryHeatExchangerType", "Heat Recovery Heat Exchanger Type"},
{ HVACTemplate_System_ConstantVolumeFields::HeatRecoveryFrostControlType, "HeatRecoveryFrostControlType", "Heat Recovery Frost Control Type"},
{ HVACTemplate_System_ConstantVolumeFields::DehumidificationControlType, "DehumidificationControlType", "Dehumidification Control Type"},
{ HVACTemplate_System_ConstantVolumeFields::DehumidificationControlZoneName, "DehumidificationControlZoneName", "Dehumidification Control Zone Name"},
{ HVACTemplate_System_ConstantVolumeFields::DehumidificationRelativeHumiditySetpoint, "DehumidificationRelativeHumiditySetpoint", "Dehumidification Relative Humidity Setpoint"},
{ HVACTemplate_System_ConstantVolumeFields::DehumidificationRelativeHumiditySetpointScheduleName, "DehumidificationRelativeHumiditySetpointScheduleName", "Dehumidification Relative Humidity Setpoint Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierType, "HumidifierType", "Humidifier Type"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierAvailabilityScheduleName, "HumidifierAvailabilityScheduleName", "Humidifier Availability Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierRatedCapacity, "HumidifierRatedCapacity", "Humidifier Rated Capacity"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierRatedElectricPower, "HumidifierRatedElectricPower", "Humidifier Rated Electric Power"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierControlZoneName, "HumidifierControlZoneName", "Humidifier Control Zone Name"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierRelativeHumiditySetpoint, "HumidifierRelativeHumiditySetpoint", "Humidifier Relative Humidity Setpoint"},
{ HVACTemplate_System_ConstantVolumeFields::HumidifierRelativeHumiditySetpointScheduleName, "HumidifierRelativeHumiditySetpointScheduleName", "Humidifier Relative Humidity Setpoint Schedule Name"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnFan, "ReturnFan", "Return Fan"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnFanTotalEfficiency, "ReturnFanTotalEfficiency", "Return Fan Total Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnFanDeltaPressure, "ReturnFanDeltaPressure", "Return Fan Delta Pressure"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnFanMotorEfficiency, "ReturnFanMotorEfficiency", "Return Fan Motor Efficiency"},
{ HVACTemplate_System_ConstantVolumeFields::ReturnFanMotorinAirStreamFraction, "ReturnFanMotorinAirStreamFraction", "Return Fan Motor in Air Stream Fraction"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const HVACTemplate_System_ConstantVolumeFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<HVACTemplate_System_ConstantVolumeFields> OptionalHVACTemplate_System_ConstantVolumeFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_HVACTEMPLATE_SYSTEM_CONSTANTVOLUME_FIELDENUMS_HXX
