/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRRESET_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRRESET_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SetpointManager_OutdoorAirResetFields
 *  \brief Enumeration of OS:SetpointManager:OutdoorAirReset's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SetpointManager_OutdoorAirResetFields, )
#else
class OS_SetpointManager_OutdoorAirResetFields: public ::EnumBase<OS_SetpointManager_OutdoorAirResetFields> {
 public: 
  enum domain 
  {
Handle, Name, ControlVariable, SetpointatOutdoorLowTemperature, OutdoorLowTemperature, SetpointatOutdoorHighTemperature, OutdoorHighTemperature, SetpointNodeorNodeListName, ScheduleName, SetpointatOutdoorLowTemperature2, OutdoorLowTemperature2, SetpointatOutdoorHighTemperature2, OutdoorHighTemperature2,   };
  OS_SetpointManager_OutdoorAirResetFields()
   : EnumBase<OS_SetpointManager_OutdoorAirResetFields>(Handle) {} 
  OS_SetpointManager_OutdoorAirResetFields(const std::string &t_name) 
   : EnumBase<OS_SetpointManager_OutdoorAirResetFields>(t_name) {} 
  OS_SetpointManager_OutdoorAirResetFields(int t_value) 
   : EnumBase<OS_SetpointManager_OutdoorAirResetFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SetpointManager_OutdoorAirResetFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SetpointManager_OutdoorAirResetFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SetpointManager_OutdoorAirResetFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SetpointManager_OutdoorAirResetFields::Handle, "Handle", "Handle"},
{ OS_SetpointManager_OutdoorAirResetFields::Name, "Name", "Name"},
{ OS_SetpointManager_OutdoorAirResetFields::ControlVariable, "ControlVariable", "Control Variable"},
{ OS_SetpointManager_OutdoorAirResetFields::SetpointatOutdoorLowTemperature, "SetpointatOutdoorLowTemperature", "Setpoint at Outdoor Low Temperature"},
{ OS_SetpointManager_OutdoorAirResetFields::OutdoorLowTemperature, "OutdoorLowTemperature", "Outdoor Low Temperature"},
{ OS_SetpointManager_OutdoorAirResetFields::SetpointatOutdoorHighTemperature, "SetpointatOutdoorHighTemperature", "Setpoint at Outdoor High Temperature"},
{ OS_SetpointManager_OutdoorAirResetFields::OutdoorHighTemperature, "OutdoorHighTemperature", "Outdoor High Temperature"},
{ OS_SetpointManager_OutdoorAirResetFields::SetpointNodeorNodeListName, "SetpointNodeorNodeListName", "Setpoint Node or NodeList Name"},
{ OS_SetpointManager_OutdoorAirResetFields::ScheduleName, "ScheduleName", "Schedule Name"},
{ OS_SetpointManager_OutdoorAirResetFields::SetpointatOutdoorLowTemperature2, "SetpointatOutdoorLowTemperature2", "Setpoint at Outdoor Low Temperature 2"},
{ OS_SetpointManager_OutdoorAirResetFields::OutdoorLowTemperature2, "OutdoorLowTemperature2", "Outdoor Low Temperature 2"},
{ OS_SetpointManager_OutdoorAirResetFields::SetpointatOutdoorHighTemperature2, "SetpointatOutdoorHighTemperature2", "Setpoint at Outdoor High Temperature 2"},
{ OS_SetpointManager_OutdoorAirResetFields::OutdoorHighTemperature2, "OutdoorHighTemperature2", "Outdoor High Temperature 2"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SetpointManager_OutdoorAirResetFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SetpointManager_OutdoorAirResetFields> OptionalOS_SetpointManager_OutdoorAirResetFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRRESET_FIELDENUMS_HXX
