/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SHADINGSURFACEGROUP_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SHADINGSURFACEGROUP_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_ShadingSurfaceGroupFields
 *  \brief Enumeration of OS:ShadingSurfaceGroup's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ShadingSurfaceGroupFields, )
#else
class OS_ShadingSurfaceGroupFields: public ::EnumBase<OS_ShadingSurfaceGroupFields> {
 public: 
  enum domain 
  {
Handle, Name, ShadingSurfaceType, SpaceName, DirectionofRelativeNorth, XOrigin, YOrigin, ZOrigin, ShadedObjectName,   };
  OS_ShadingSurfaceGroupFields()
   : EnumBase<OS_ShadingSurfaceGroupFields>(Handle) {} 
  OS_ShadingSurfaceGroupFields(const std::string &t_name) 
   : EnumBase<OS_ShadingSurfaceGroupFields>(t_name) {} 
  OS_ShadingSurfaceGroupFields(int t_value) 
   : EnumBase<OS_ShadingSurfaceGroupFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ShadingSurfaceGroupFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ShadingSurfaceGroupFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ShadingSurfaceGroupFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ShadingSurfaceGroupFields::Handle, "Handle", "Handle"},
{ OS_ShadingSurfaceGroupFields::Name, "Name", "Name"},
{ OS_ShadingSurfaceGroupFields::ShadingSurfaceType, "ShadingSurfaceType", "Shading Surface Type"},
{ OS_ShadingSurfaceGroupFields::SpaceName, "SpaceName", "Space Name"},
{ OS_ShadingSurfaceGroupFields::DirectionofRelativeNorth, "DirectionofRelativeNorth", "Direction of Relative North"},
{ OS_ShadingSurfaceGroupFields::XOrigin, "XOrigin", "X Origin"},
{ OS_ShadingSurfaceGroupFields::YOrigin, "YOrigin", "Y Origin"},
{ OS_ShadingSurfaceGroupFields::ZOrigin, "ZOrigin", "Z Origin"},
{ OS_ShadingSurfaceGroupFields::ShadedObjectName, "ShadedObjectName", "Shaded Object Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ShadingSurfaceGroupFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ShadingSurfaceGroupFields> OptionalOS_ShadingSurfaceGroupFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SHADINGSURFACEGROUP_FIELDENUMS_HXX
