/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_INLETSIDEMIXER_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_INLETSIDEMIXER_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_AirTerminal_SingleDuct_InletSideMixerFields
 *  \brief Enumeration of OS:AirTerminal:SingleDuct:InletSideMixer's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_AirTerminal_SingleDuct_InletSideMixerFields, )
#else
class OS_AirTerminal_SingleDuct_InletSideMixerFields: public ::EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields> {
 public: 
  enum domain 
  {
Handle, Name, TerminalUnitOutlet, TerminalUnitPrimaryAirInlet, TerminalUnitSecondaryAirInlet, ControlForOutdoorAir, PerPersonVentilationRateMode,   };
  OS_AirTerminal_SingleDuct_InletSideMixerFields()
   : EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields>(Handle) {} 
  OS_AirTerminal_SingleDuct_InletSideMixerFields(const std::string &t_name) 
   : EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields>(t_name) {} 
  OS_AirTerminal_SingleDuct_InletSideMixerFields(int t_value) 
   : EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_AirTerminal_SingleDuct_InletSideMixerFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields>::integer_value()); }
   private:
    friend class EnumBase<OS_AirTerminal_SingleDuct_InletSideMixerFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::Handle, "Handle", "Handle"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::Name, "Name", "Name"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::TerminalUnitOutlet, "TerminalUnitOutlet", "Terminal Unit Outlet"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::TerminalUnitPrimaryAirInlet, "TerminalUnitPrimaryAirInlet", "Terminal Unit Primary Air Inlet"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::TerminalUnitSecondaryAirInlet, "TerminalUnitSecondaryAirInlet", "Terminal Unit Secondary Air Inlet"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::ControlForOutdoorAir, "ControlForOutdoorAir", "Control For Outdoor Air"},
{ OS_AirTerminal_SingleDuct_InletSideMixerFields::PerPersonVentilationRateMode, "PerPersonVentilationRateMode", "Per Person Ventilation Rate Mode"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_AirTerminal_SingleDuct_InletSideMixerFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_AirTerminal_SingleDuct_InletSideMixerFields> OptionalOS_AirTerminal_SingleDuct_InletSideMixerFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_INLETSIDEMIXER_FIELDENUMS_HXX
