/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_INTERIORPARTITIONSURFACEGROUP_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_INTERIORPARTITIONSURFACEGROUP_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_InteriorPartitionSurfaceGroupFields
 *  \brief Enumeration of OS:InteriorPartitionSurfaceGroup's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_InteriorPartitionSurfaceGroupFields, )
#else
class OS_InteriorPartitionSurfaceGroupFields: public ::EnumBase<OS_InteriorPartitionSurfaceGroupFields> {
 public: 
  enum domain 
  {
Handle, Name, SpaceName, DirectionofRelativeNorth, XOrigin, YOrigin, ZOrigin, Multiplier,   };
  OS_InteriorPartitionSurfaceGroupFields()
   : EnumBase<OS_InteriorPartitionSurfaceGroupFields>(Handle) {} 
  OS_InteriorPartitionSurfaceGroupFields(const std::string &t_name) 
   : EnumBase<OS_InteriorPartitionSurfaceGroupFields>(t_name) {} 
  OS_InteriorPartitionSurfaceGroupFields(int t_value) 
   : EnumBase<OS_InteriorPartitionSurfaceGroupFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_InteriorPartitionSurfaceGroupFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_InteriorPartitionSurfaceGroupFields>::integer_value()); }
   private:
    friend class EnumBase<OS_InteriorPartitionSurfaceGroupFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_InteriorPartitionSurfaceGroupFields::Handle, "Handle", "Handle"},
{ OS_InteriorPartitionSurfaceGroupFields::Name, "Name", "Name"},
{ OS_InteriorPartitionSurfaceGroupFields::SpaceName, "SpaceName", "Space Name"},
{ OS_InteriorPartitionSurfaceGroupFields::DirectionofRelativeNorth, "DirectionofRelativeNorth", "Direction of Relative North"},
{ OS_InteriorPartitionSurfaceGroupFields::XOrigin, "XOrigin", "X Origin"},
{ OS_InteriorPartitionSurfaceGroupFields::YOrigin, "YOrigin", "Y Origin"},
{ OS_InteriorPartitionSurfaceGroupFields::ZOrigin, "ZOrigin", "Z Origin"},
{ OS_InteriorPartitionSurfaceGroupFields::Multiplier, "Multiplier", "Multiplier"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_InteriorPartitionSurfaceGroupFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_InteriorPartitionSurfaceGroupFields> OptionalOS_InteriorPartitionSurfaceGroupFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_INTERIORPARTITIONSURFACEGROUP_FIELDENUMS_HXX
