/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SURFACECONVECTIONALGORITHM_OUTSIDE_FIELDENUMS_HXX
#define UTILITIES_IDD_SURFACECONVECTIONALGORITHM_OUTSIDE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SurfaceConvectionAlgorithm_OutsideFields
 *  \brief Enumeration of SurfaceConvectionAlgorithm:Outside's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SurfaceConvectionAlgorithm_OutsideFields, )
#else
class SurfaceConvectionAlgorithm_OutsideFields: public ::EnumBase<SurfaceConvectionAlgorithm_OutsideFields> {
 public: 
  enum domain 
  {
Algorithm,   };
  SurfaceConvectionAlgorithm_OutsideFields()
   : EnumBase<SurfaceConvectionAlgorithm_OutsideFields>(Algorithm) {} 
  SurfaceConvectionAlgorithm_OutsideFields(const std::string &t_name) 
   : EnumBase<SurfaceConvectionAlgorithm_OutsideFields>(t_name) {} 
  SurfaceConvectionAlgorithm_OutsideFields(int t_value) 
   : EnumBase<SurfaceConvectionAlgorithm_OutsideFields>(t_value) {} 
  static std::string enumName() 
  { return "SurfaceConvectionAlgorithm_OutsideFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SurfaceConvectionAlgorithm_OutsideFields>::integer_value()); }
   private:
    friend class EnumBase<SurfaceConvectionAlgorithm_OutsideFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SurfaceConvectionAlgorithm_OutsideFields::Algorithm, "Algorithm", "Algorithm"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SurfaceConvectionAlgorithm_OutsideFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SurfaceConvectionAlgorithm_OutsideFields> OptionalSurfaceConvectionAlgorithm_OutsideFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SURFACECONVECTIONALGORITHM_OUTSIDE_FIELDENUMS_HXX
