/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COILSYSTEM_COOLING_DX_HEATEXCHANGERASSISTED_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COILSYSTEM_COOLING_DX_HEATEXCHANGERASSISTED_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields
 *  \brief Enumeration of OS:CoilSystem:Cooling:DX:HeatExchangerAssisted's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields, )
#else
class OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields: public ::EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields> {
 public: 
  enum domain 
  {
Handle, Name, AirInletNodeName, AirOutletNodeName, HeatExchanger, CoolingCoil,   };
  OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields()
   : EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields>(Handle) {} 
  OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields(const std::string &t_name) 
   : EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields>(t_name) {} 
  OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields(int t_value) 
   : EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields>::integer_value()); }
   private:
    friend class EnumBase<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::Handle, "Handle", "Handle"},
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::Name, "Name", "Name"},
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::HeatExchanger, "HeatExchanger", "Heat Exchanger"},
{ OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields::CoolingCoil, "CoolingCoil", "Cooling Coil"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields> OptionalOS_CoilSystem_Cooling_DX_HeatExchangerAssistedFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COILSYSTEM_COOLING_DX_HEATEXCHANGERASSISTED_FIELDENUMS_HXX
