/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_STANDARDSINFORMATION_MATERIAL_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_STANDARDSINFORMATION_MATERIAL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_StandardsInformation_MaterialFields
 *  \brief Enumeration of OS:StandardsInformation:Material's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_StandardsInformation_MaterialFields, )
#else
class OS_StandardsInformation_MaterialFields: public ::EnumBase<OS_StandardsInformation_MaterialFields> {
 public: 
  enum domain 
  {
Handle, MaterialName, MaterialStandard, MaterialStandardSource, StandardsCategory, StandardsIdentifier, CompositeFramingMaterial, CompositeFramingConfiguration, CompositeFramingDepth, CompositeFramingSize, CompositeCavityInsulation,   };
  OS_StandardsInformation_MaterialFields()
   : EnumBase<OS_StandardsInformation_MaterialFields>(Handle) {} 
  OS_StandardsInformation_MaterialFields(const std::string &t_name) 
   : EnumBase<OS_StandardsInformation_MaterialFields>(t_name) {} 
  OS_StandardsInformation_MaterialFields(int t_value) 
   : EnumBase<OS_StandardsInformation_MaterialFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_StandardsInformation_MaterialFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_StandardsInformation_MaterialFields>::integer_value()); }
   private:
    friend class EnumBase<OS_StandardsInformation_MaterialFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_StandardsInformation_MaterialFields::Handle, "Handle", "Handle"},
{ OS_StandardsInformation_MaterialFields::MaterialName, "MaterialName", "Material Name"},
{ OS_StandardsInformation_MaterialFields::MaterialStandard, "MaterialStandard", "Material Standard"},
{ OS_StandardsInformation_MaterialFields::MaterialStandardSource, "MaterialStandardSource", "Material Standard Source"},
{ OS_StandardsInformation_MaterialFields::StandardsCategory, "StandardsCategory", "Standards Category"},
{ OS_StandardsInformation_MaterialFields::StandardsIdentifier, "StandardsIdentifier", "Standards Identifier"},
{ OS_StandardsInformation_MaterialFields::CompositeFramingMaterial, "CompositeFramingMaterial", "Composite Framing Material"},
{ OS_StandardsInformation_MaterialFields::CompositeFramingConfiguration, "CompositeFramingConfiguration", "Composite Framing Configuration"},
{ OS_StandardsInformation_MaterialFields::CompositeFramingDepth, "CompositeFramingDepth", "Composite Framing Depth"},
{ OS_StandardsInformation_MaterialFields::CompositeFramingSize, "CompositeFramingSize", "Composite Framing Size"},
{ OS_StandardsInformation_MaterialFields::CompositeCavityInsulation, "CompositeCavityInsulation", "Composite Cavity Insulation"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_StandardsInformation_MaterialFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_StandardsInformation_MaterialFields> OptionalOS_StandardsInformation_MaterialFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_STANDARDSINFORMATION_MATERIAL_FIELDENUMS_HXX
