/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_HEATING_WATER_BASEBOARD_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_HEATING_WATER_BASEBOARD_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Heating_Water_BaseboardFields
 *  \brief Enumeration of OS:Coil:Heating:Water:Baseboard's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Heating_Water_BaseboardFields, )
#else
class OS_Coil_Heating_Water_BaseboardFields: public ::EnumBase<OS_Coil_Heating_Water_BaseboardFields> {
 public: 
  enum domain 
  {
Handle, Name, HeatingDesignCapacityMethod, HeatingDesignCapacity, HeatingDesignCapacityPerFloorArea, FractionofAutosizedHeatingDesignCapacity, UFactorTimesAreaValue, MaximumWaterFlowRate, ConvergenceTolerance, WaterInletNodeName, WaterOutletNodeName,   };
  OS_Coil_Heating_Water_BaseboardFields()
   : EnumBase<OS_Coil_Heating_Water_BaseboardFields>(Handle) {} 
  OS_Coil_Heating_Water_BaseboardFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Heating_Water_BaseboardFields>(t_name) {} 
  OS_Coil_Heating_Water_BaseboardFields(int t_value) 
   : EnumBase<OS_Coil_Heating_Water_BaseboardFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Heating_Water_BaseboardFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Heating_Water_BaseboardFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Heating_Water_BaseboardFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Heating_Water_BaseboardFields::Handle, "Handle", "Handle"},
{ OS_Coil_Heating_Water_BaseboardFields::Name, "Name", "Name"},
{ OS_Coil_Heating_Water_BaseboardFields::HeatingDesignCapacityMethod, "HeatingDesignCapacityMethod", "Heating Design Capacity Method"},
{ OS_Coil_Heating_Water_BaseboardFields::HeatingDesignCapacity, "HeatingDesignCapacity", "Heating Design Capacity"},
{ OS_Coil_Heating_Water_BaseboardFields::HeatingDesignCapacityPerFloorArea, "HeatingDesignCapacityPerFloorArea", "Heating Design Capacity Per Floor Area"},
{ OS_Coil_Heating_Water_BaseboardFields::FractionofAutosizedHeatingDesignCapacity, "FractionofAutosizedHeatingDesignCapacity", "Fraction of Autosized Heating Design Capacity"},
{ OS_Coil_Heating_Water_BaseboardFields::UFactorTimesAreaValue, "UFactorTimesAreaValue", "U-Factor Times Area Value"},
{ OS_Coil_Heating_Water_BaseboardFields::MaximumWaterFlowRate, "MaximumWaterFlowRate", "Maximum Water Flow Rate"},
{ OS_Coil_Heating_Water_BaseboardFields::ConvergenceTolerance, "ConvergenceTolerance", "Convergence Tolerance"},
{ OS_Coil_Heating_Water_BaseboardFields::WaterInletNodeName, "WaterInletNodeName", "Water Inlet Node Name"},
{ OS_Coil_Heating_Water_BaseboardFields::WaterOutletNodeName, "WaterOutletNodeName", "Water Outlet Node Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Heating_Water_BaseboardFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Heating_Water_BaseboardFields> OptionalOS_Coil_Heating_Water_BaseboardFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_HEATING_WATER_BASEBOARD_FIELDENUMS_HXX
