/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_GENERATOR_FUELCELL_AIRSUPPLY_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_GENERATOR_FUELCELL_AIRSUPPLY_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Generator_FuelCell_AirSupplyFields
 *  \brief Enumeration of OS:Generator:FuelCell:AirSupply's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Generator_FuelCell_AirSupplyFields, )
#else
class OS_Generator_FuelCell_AirSupplyFields: public ::EnumBase<OS_Generator_FuelCell_AirSupplyFields> {
 public: 
  enum domain 
  {
Handle, Name, AirInletNodeName, BlowerPowerCurveName, BlowerHeatLossFactor, AirSupplyRateCalculationMode, StoichiometricRatio, AirRateFunctionofElectricPowerCurveName, AirRateAirTemperatureCoefficient, AirRateFunctionofFuelRateCurveName, AirIntakeHeatRecoveryMode, AirSupplyConstituentMode, NumberofUserDefinedConstituents,   };
  OS_Generator_FuelCell_AirSupplyFields()
   : EnumBase<OS_Generator_FuelCell_AirSupplyFields>(Handle) {} 
  OS_Generator_FuelCell_AirSupplyFields(const std::string &t_name) 
   : EnumBase<OS_Generator_FuelCell_AirSupplyFields>(t_name) {} 
  OS_Generator_FuelCell_AirSupplyFields(int t_value) 
   : EnumBase<OS_Generator_FuelCell_AirSupplyFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Generator_FuelCell_AirSupplyFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Generator_FuelCell_AirSupplyFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Generator_FuelCell_AirSupplyFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Generator_FuelCell_AirSupplyFields::Handle, "Handle", "Handle"},
{ OS_Generator_FuelCell_AirSupplyFields::Name, "Name", "Name"},
{ OS_Generator_FuelCell_AirSupplyFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ OS_Generator_FuelCell_AirSupplyFields::BlowerPowerCurveName, "BlowerPowerCurveName", "Blower Power Curve Name"},
{ OS_Generator_FuelCell_AirSupplyFields::BlowerHeatLossFactor, "BlowerHeatLossFactor", "Blower Heat Loss Factor"},
{ OS_Generator_FuelCell_AirSupplyFields::AirSupplyRateCalculationMode, "AirSupplyRateCalculationMode", "Air Supply Rate Calculation Mode"},
{ OS_Generator_FuelCell_AirSupplyFields::StoichiometricRatio, "StoichiometricRatio", "Stoichiometric Ratio"},
{ OS_Generator_FuelCell_AirSupplyFields::AirRateFunctionofElectricPowerCurveName, "AirRateFunctionofElectricPowerCurveName", "Air Rate Function of Electric Power Curve Name"},
{ OS_Generator_FuelCell_AirSupplyFields::AirRateAirTemperatureCoefficient, "AirRateAirTemperatureCoefficient", "Air Rate Air Temperature Coefficient"},
{ OS_Generator_FuelCell_AirSupplyFields::AirRateFunctionofFuelRateCurveName, "AirRateFunctionofFuelRateCurveName", "Air Rate Function of Fuel Rate Curve Name"},
{ OS_Generator_FuelCell_AirSupplyFields::AirIntakeHeatRecoveryMode, "AirIntakeHeatRecoveryMode", "Air Intake Heat Recovery Mode"},
{ OS_Generator_FuelCell_AirSupplyFields::AirSupplyConstituentMode, "AirSupplyConstituentMode", "Air Supply Constituent Mode"},
{ OS_Generator_FuelCell_AirSupplyFields::NumberofUserDefinedConstituents, "NumberofUserDefinedConstituents", "Number of UserDefined Constituents"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Generator_FuelCell_AirSupplyFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Generator_FuelCell_AirSupplyFields> OptionalOS_Generator_FuelCell_AirSupplyFields ;
#endif

/** \class OS_Generator_FuelCell_AirSupplyExtensibleFields
 *  \brief Enumeration of OS:Generator:FuelCell:AirSupply's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Generator_FuelCell_AirSupplyExtensibleFields, )
#else
class OS_Generator_FuelCell_AirSupplyExtensibleFields: public ::EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields> {
 public: 
  enum domain 
  {
ConstituentName, MolarFraction,   };
  OS_Generator_FuelCell_AirSupplyExtensibleFields()
   : EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields>(ConstituentName) {} 
  OS_Generator_FuelCell_AirSupplyExtensibleFields(const std::string &t_name) 
   : EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields>(t_name) {} 
  OS_Generator_FuelCell_AirSupplyExtensibleFields(int t_value) 
   : EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Generator_FuelCell_AirSupplyExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Generator_FuelCell_AirSupplyExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Generator_FuelCell_AirSupplyExtensibleFields::ConstituentName, "ConstituentName", "Constituent Name"},
{ OS_Generator_FuelCell_AirSupplyExtensibleFields::MolarFraction, "MolarFraction", "Molar Fraction"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Generator_FuelCell_AirSupplyExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Generator_FuelCell_AirSupplyExtensibleFields> OptionalOS_Generator_FuelCell_AirSupplyExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_GENERATOR_FUELCELL_AIRSUPPLY_FIELDENUMS_HXX
