/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SURFACEPROPERTY_OTHERSIDECOEFFICIENTS_FIELDENUMS_HXX
#define UTILITIES_IDD_SURFACEPROPERTY_OTHERSIDECOEFFICIENTS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SurfaceProperty_OtherSideCoefficientsFields
 *  \brief Enumeration of SurfaceProperty:OtherSideCoefficients's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SurfaceProperty_OtherSideCoefficientsFields, )
#else
class SurfaceProperty_OtherSideCoefficientsFields: public ::EnumBase<SurfaceProperty_OtherSideCoefficientsFields> {
 public: 
  enum domain 
  {
Name, CombinedConvective_RadiativeFilmCoefficient, ConstantTemperature, ConstantTemperatureCoefficient, ExternalDryBulbTemperatureCoefficient, GroundTemperatureCoefficient, WindSpeedCoefficient, ZoneAirTemperatureCoefficient, ConstantTemperatureScheduleName, SinusoidalVariationofConstantTemperatureCoefficient, PeriodofSinusoidalVariation, PreviousOtherSideTemperatureCoefficient, MinimumOtherSideTemperatureLimit, MaximumOtherSideTemperatureLimit,   };
  SurfaceProperty_OtherSideCoefficientsFields()
   : EnumBase<SurfaceProperty_OtherSideCoefficientsFields>(Name) {} 
  SurfaceProperty_OtherSideCoefficientsFields(const std::string &t_name) 
   : EnumBase<SurfaceProperty_OtherSideCoefficientsFields>(t_name) {} 
  SurfaceProperty_OtherSideCoefficientsFields(int t_value) 
   : EnumBase<SurfaceProperty_OtherSideCoefficientsFields>(t_value) {} 
  static std::string enumName() 
  { return "SurfaceProperty_OtherSideCoefficientsFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SurfaceProperty_OtherSideCoefficientsFields>::integer_value()); }
   private:
    friend class EnumBase<SurfaceProperty_OtherSideCoefficientsFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SurfaceProperty_OtherSideCoefficientsFields::Name, "Name", "Name"},
{ SurfaceProperty_OtherSideCoefficientsFields::CombinedConvective_RadiativeFilmCoefficient, "CombinedConvective_RadiativeFilmCoefficient", "Combined Convective/Radiative Film Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::ConstantTemperature, "ConstantTemperature", "Constant Temperature"},
{ SurfaceProperty_OtherSideCoefficientsFields::ConstantTemperatureCoefficient, "ConstantTemperatureCoefficient", "Constant Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::ExternalDryBulbTemperatureCoefficient, "ExternalDryBulbTemperatureCoefficient", "External Dry-Bulb Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::GroundTemperatureCoefficient, "GroundTemperatureCoefficient", "Ground Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::WindSpeedCoefficient, "WindSpeedCoefficient", "Wind Speed Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::ZoneAirTemperatureCoefficient, "ZoneAirTemperatureCoefficient", "Zone Air Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::ConstantTemperatureScheduleName, "ConstantTemperatureScheduleName", "Constant Temperature Schedule Name"},
{ SurfaceProperty_OtherSideCoefficientsFields::SinusoidalVariationofConstantTemperatureCoefficient, "SinusoidalVariationofConstantTemperatureCoefficient", "Sinusoidal Variation of Constant Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::PeriodofSinusoidalVariation, "PeriodofSinusoidalVariation", "Period of Sinusoidal Variation"},
{ SurfaceProperty_OtherSideCoefficientsFields::PreviousOtherSideTemperatureCoefficient, "PreviousOtherSideTemperatureCoefficient", "Previous Other Side Temperature Coefficient"},
{ SurfaceProperty_OtherSideCoefficientsFields::MinimumOtherSideTemperatureLimit, "MinimumOtherSideTemperatureLimit", "Minimum Other Side Temperature Limit"},
{ SurfaceProperty_OtherSideCoefficientsFields::MaximumOtherSideTemperatureLimit, "MaximumOtherSideTemperatureLimit", "Maximum Other Side Temperature Limit"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SurfaceProperty_OtherSideCoefficientsFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SurfaceProperty_OtherSideCoefficientsFields> OptionalSurfaceProperty_OtherSideCoefficientsFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SURFACEPROPERTY_OTHERSIDECOEFFICIENTS_FIELDENUMS_HXX
