/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ZONEINFILTRATION_DESIGNFLOWRATE_FIELDENUMS_HXX
#define UTILITIES_IDD_ZONEINFILTRATION_DESIGNFLOWRATE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ZoneInfiltration_DesignFlowRateFields
 *  \brief Enumeration of ZoneInfiltration:DesignFlowRate's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ZoneInfiltration_DesignFlowRateFields, )
#else
class ZoneInfiltration_DesignFlowRateFields: public ::EnumBase<ZoneInfiltration_DesignFlowRateFields> {
 public: 
  enum domain 
  {
Name, ZoneorZoneListorSpaceorSpaceListName, ScheduleName, DesignFlowRateCalculationMethod, DesignFlowRate, FlowRateperFloorArea, FlowRateperExteriorSurfaceArea, AirChangesperHour, ConstantTermCoefficient, TemperatureTermCoefficient, VelocityTermCoefficient, VelocitySquaredTermCoefficient, DensityBasis,   };
  ZoneInfiltration_DesignFlowRateFields()
   : EnumBase<ZoneInfiltration_DesignFlowRateFields>(Name) {} 
  ZoneInfiltration_DesignFlowRateFields(const std::string &t_name) 
   : EnumBase<ZoneInfiltration_DesignFlowRateFields>(t_name) {} 
  ZoneInfiltration_DesignFlowRateFields(int t_value) 
   : EnumBase<ZoneInfiltration_DesignFlowRateFields>(t_value) {} 
  static std::string enumName() 
  { return "ZoneInfiltration_DesignFlowRateFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ZoneInfiltration_DesignFlowRateFields>::integer_value()); }
   private:
    friend class EnumBase<ZoneInfiltration_DesignFlowRateFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ZoneInfiltration_DesignFlowRateFields::Name, "Name", "Name"},
{ ZoneInfiltration_DesignFlowRateFields::ZoneorZoneListorSpaceorSpaceListName, "ZoneorZoneListorSpaceorSpaceListName", "Zone or ZoneList or Space or SpaceList Name"},
{ ZoneInfiltration_DesignFlowRateFields::ScheduleName, "ScheduleName", "Schedule Name"},
{ ZoneInfiltration_DesignFlowRateFields::DesignFlowRateCalculationMethod, "DesignFlowRateCalculationMethod", "Design Flow Rate Calculation Method"},
{ ZoneInfiltration_DesignFlowRateFields::DesignFlowRate, "DesignFlowRate", "Design Flow Rate"},
{ ZoneInfiltration_DesignFlowRateFields::FlowRateperFloorArea, "FlowRateperFloorArea", "Flow Rate per Floor Area"},
{ ZoneInfiltration_DesignFlowRateFields::FlowRateperExteriorSurfaceArea, "FlowRateperExteriorSurfaceArea", "Flow Rate per Exterior Surface Area"},
{ ZoneInfiltration_DesignFlowRateFields::AirChangesperHour, "AirChangesperHour", "Air Changes per Hour"},
{ ZoneInfiltration_DesignFlowRateFields::ConstantTermCoefficient, "ConstantTermCoefficient", "Constant Term Coefficient"},
{ ZoneInfiltration_DesignFlowRateFields::TemperatureTermCoefficient, "TemperatureTermCoefficient", "Temperature Term Coefficient"},
{ ZoneInfiltration_DesignFlowRateFields::VelocityTermCoefficient, "VelocityTermCoefficient", "Velocity Term Coefficient"},
{ ZoneInfiltration_DesignFlowRateFields::VelocitySquaredTermCoefficient, "VelocitySquaredTermCoefficient", "Velocity Squared Term Coefficient"},
{ ZoneInfiltration_DesignFlowRateFields::DensityBasis, "DensityBasis", "Density Basis"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ZoneInfiltration_DesignFlowRateFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ZoneInfiltration_DesignFlowRateFields> OptionalZoneInfiltration_DesignFlowRateFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ZONEINFILTRATION_DESIGNFLOWRATE_FIELDENUMS_HXX
