/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_IDDFIELDENUMS_HXX
#define UTILITIES_IDD_IDDFIELDENUMS_HXX

/** \file IddFieldEnums.hxx
 *  IddFieldEnums.hxx includes one file per IddObjectType (excluding Catchall, UserCustom, 
 *  and CommentOnly). Each file so included contains one or two OPENSTUDIO_ENUM macros that 
 *  provide enum and string access to the non-extensible fields and extensible groups of 
 *  the corresponding IddObjects. This file should not be included directly, but rather, 
 *  used as a reference to help locate the individual field enum files that should be 
 *  included in a particular source file. */

#include <utilities/idd/Version_FieldEnums.hxx>
#include <utilities/idd/SimulationControl_FieldEnums.hxx>
#include <utilities/idd/PerformancePrecisionTradeoffs_FieldEnums.hxx>
#include <utilities/idd/Building_FieldEnums.hxx>
#include <utilities/idd/ShadowCalculation_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Inside_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Outside_FieldEnums.hxx>
#include <utilities/idd/HeatBalanceAlgorithm_FieldEnums.hxx>
#include <utilities/idd/HeatBalanceSettings_ConductionFiniteDifference_FieldEnums.hxx>
#include <utilities/idd/ZoneAirHeatBalanceAlgorithm_FieldEnums.hxx>
#include <utilities/idd/ZoneAirContaminantBalance_FieldEnums.hxx>
#include <utilities/idd/ZoneAirMassFlowConservation_FieldEnums.hxx>
#include <utilities/idd/ZoneCapacitanceMultiplier_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/Timestep_FieldEnums.hxx>
#include <utilities/idd/ConvergenceLimits_FieldEnums.hxx>
#include <utilities/idd/HVACSystemRootFindingAlgorithm_FieldEnums.hxx>
#include <utilities/idd/Compliance_Building_FieldEnums.hxx>
#include <utilities/idd/Site_Location_FieldEnums.hxx>
#include <utilities/idd/Site_VariableLocation_FieldEnums.hxx>
#include <utilities/idd/SizingPeriod_DesignDay_FieldEnums.hxx>
#include <utilities/idd/SizingPeriod_WeatherFileDays_FieldEnums.hxx>
#include <utilities/idd/SizingPeriod_WeatherFileConditionType_FieldEnums.hxx>
#include <utilities/idd/RunPeriod_FieldEnums.hxx>
#include <utilities/idd/RunPeriodControl_SpecialDays_FieldEnums.hxx>
#include <utilities/idd/RunPeriodControl_DaylightSavingTime_FieldEnums.hxx>
#include <utilities/idd/WeatherProperty_SkyTemperature_FieldEnums.hxx>
#include <utilities/idd/Site_WeatherStation_FieldEnums.hxx>
#include <utilities/idd/Site_HeightVariation_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_BuildingSurface_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_FCfactorMethod_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_Shallow_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_Deep_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_Undisturbed_FiniteDifference_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_Undisturbed_KusudaAchenbach_FieldEnums.hxx>
#include <utilities/idd/Site_GroundTemperature_Undisturbed_Xing_FieldEnums.hxx>
#include <utilities/idd/Site_GroundDomain_Slab_FieldEnums.hxx>
#include <utilities/idd/Site_GroundDomain_Basement_FieldEnums.hxx>
#include <utilities/idd/Site_GroundReflectance_FieldEnums.hxx>
#include <utilities/idd/Site_GroundReflectance_SnowModifier_FieldEnums.hxx>
#include <utilities/idd/Site_WaterMainsTemperature_FieldEnums.hxx>
#include <utilities/idd/Site_Precipitation_FieldEnums.hxx>
#include <utilities/idd/RoofIrrigation_FieldEnums.hxx>
#include <utilities/idd/Site_SolarAndVisibleSpectrum_FieldEnums.hxx>
#include <utilities/idd/Site_SpectrumData_FieldEnums.hxx>
#include <utilities/idd/ScheduleTypeLimits_FieldEnums.hxx>
#include <utilities/idd/Schedule_Day_Hourly_FieldEnums.hxx>
#include <utilities/idd/Schedule_Day_Interval_FieldEnums.hxx>
#include <utilities/idd/Schedule_Day_List_FieldEnums.hxx>
#include <utilities/idd/Schedule_Week_Daily_FieldEnums.hxx>
#include <utilities/idd/Schedule_Week_Compact_FieldEnums.hxx>
#include <utilities/idd/Schedule_Year_FieldEnums.hxx>
#include <utilities/idd/Schedule_Compact_FieldEnums.hxx>
#include <utilities/idd/Schedule_Constant_FieldEnums.hxx>
#include <utilities/idd/Schedule_File_Shading_FieldEnums.hxx>
#include <utilities/idd/Schedule_File_FieldEnums.hxx>
#include <utilities/idd/Material_FieldEnums.hxx>
#include <utilities/idd/Material_NoMass_FieldEnums.hxx>
#include <utilities/idd/Material_InfraredTransparent_FieldEnums.hxx>
#include <utilities/idd/Material_AirGap_FieldEnums.hxx>
#include <utilities/idd/Material_RoofVegetation_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_SimpleGlazingSystem_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Glazing_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_GlazingGroup_Thermochromic_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Glazing_RefractionExtinctionMethod_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Gas_FieldEnums.hxx>
#include <utilities/idd/WindowGap_SupportPillar_FieldEnums.hxx>
#include <utilities/idd/WindowGap_DeflectionState_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_GasMixture_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Gap_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Shade_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_ComplexShade_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Blind_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Screen_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Shade_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Drape_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Blind_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Screen_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Glazing_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/WindowMaterial_Gap_EquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_MoisturePenetrationDepth_Settings_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_PhaseChange_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_PhaseChangeHysteresis_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_VariableThermalConductivity_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_VariableAbsorptance_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_Settings_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_SorptionIsotherm_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_Suction_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_Redistribution_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_Diffusion_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_HeatAndMoistureTransfer_ThermalConductivity_FieldEnums.hxx>
#include <utilities/idd/MaterialProperty_GlazingSpectralData_FieldEnums.hxx>
#include <utilities/idd/Construction_FieldEnums.hxx>
#include <utilities/idd/Construction_CfactorUndergroundWall_FieldEnums.hxx>
#include <utilities/idd/Construction_FfactorGroundFloor_FieldEnums.hxx>
#include <utilities/idd/ConstructionProperty_InternalHeatSource_FieldEnums.hxx>
#include <utilities/idd/Construction_AirBoundary_FieldEnums.hxx>
#include <utilities/idd/WindowThermalModel_Params_FieldEnums.hxx>
#include <utilities/idd/WindowsCalculationEngine_FieldEnums.hxx>
#include <utilities/idd/Construction_ComplexFenestrationState_FieldEnums.hxx>
#include <utilities/idd/Construction_WindowEquivalentLayer_FieldEnums.hxx>
#include <utilities/idd/Construction_WindowDataFile_FieldEnums.hxx>
#include <utilities/idd/GlobalGeometryRules_FieldEnums.hxx>
#include <utilities/idd/GeometryTransform_FieldEnums.hxx>
#include <utilities/idd/Space_FieldEnums.hxx>
#include <utilities/idd/SpaceList_FieldEnums.hxx>
#include <utilities/idd/Zone_FieldEnums.hxx>
#include <utilities/idd/ZoneList_FieldEnums.hxx>
#include <utilities/idd/ZoneGroup_FieldEnums.hxx>
#include <utilities/idd/BuildingSurface_Detailed_FieldEnums.hxx>
#include <utilities/idd/Wall_Detailed_FieldEnums.hxx>
#include <utilities/idd/RoofCeiling_Detailed_FieldEnums.hxx>
#include <utilities/idd/Floor_Detailed_FieldEnums.hxx>
#include <utilities/idd/Wall_Exterior_FieldEnums.hxx>
#include <utilities/idd/Wall_Adiabatic_FieldEnums.hxx>
#include <utilities/idd/Wall_Underground_FieldEnums.hxx>
#include <utilities/idd/Wall_Interzone_FieldEnums.hxx>
#include <utilities/idd/Roof_FieldEnums.hxx>
#include <utilities/idd/Ceiling_Adiabatic_FieldEnums.hxx>
#include <utilities/idd/Ceiling_Interzone_FieldEnums.hxx>
#include <utilities/idd/Floor_GroundContact_FieldEnums.hxx>
#include <utilities/idd/Floor_Adiabatic_FieldEnums.hxx>
#include <utilities/idd/Floor_Interzone_FieldEnums.hxx>
#include <utilities/idd/FenestrationSurface_Detailed_FieldEnums.hxx>
#include <utilities/idd/Window_FieldEnums.hxx>
#include <utilities/idd/Door_FieldEnums.hxx>
#include <utilities/idd/GlazedDoor_FieldEnums.hxx>
#include <utilities/idd/Window_Interzone_FieldEnums.hxx>
#include <utilities/idd/Door_Interzone_FieldEnums.hxx>
#include <utilities/idd/GlazedDoor_Interzone_FieldEnums.hxx>
#include <utilities/idd/WindowShadingControl_FieldEnums.hxx>
#include <utilities/idd/WindowProperty_FrameAndDivider_FieldEnums.hxx>
#include <utilities/idd/WindowProperty_AirflowControl_FieldEnums.hxx>
#include <utilities/idd/WindowProperty_StormWindow_FieldEnums.hxx>
#include <utilities/idd/InternalMass_FieldEnums.hxx>
#include <utilities/idd/Shading_Site_FieldEnums.hxx>
#include <utilities/idd/Shading_Building_FieldEnums.hxx>
#include <utilities/idd/Shading_Site_Detailed_FieldEnums.hxx>
#include <utilities/idd/Shading_Building_Detailed_FieldEnums.hxx>
#include <utilities/idd/Shading_Overhang_FieldEnums.hxx>
#include <utilities/idd/Shading_Overhang_Projection_FieldEnums.hxx>
#include <utilities/idd/Shading_Fin_FieldEnums.hxx>
#include <utilities/idd/Shading_Fin_Projection_FieldEnums.hxx>
#include <utilities/idd/Shading_Zone_Detailed_FieldEnums.hxx>
#include <utilities/idd/ShadingProperty_Reflectance_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_HeatTransferAlgorithm_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_HeatTransferAlgorithm_MultipleSurface_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_HeatTransferAlgorithm_SurfaceList_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_HeatTransferAlgorithm_Construction_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_HeatBalanceSourceTerm_FieldEnums.hxx>
#include <utilities/idd/SurfaceControl_MovableInsulation_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_OtherSideCoefficients_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_OtherSideConditionsModel_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_Underwater_FieldEnums.hxx>
#include <utilities/idd/Foundation_Kiva_FieldEnums.hxx>
#include <utilities/idd/Foundation_Kiva_Settings_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_ExposedFoundationPerimeter_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Inside_AdaptiveModelSelections_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Outside_AdaptiveModelSelections_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Inside_UserCurve_FieldEnums.hxx>
#include <utilities/idd/SurfaceConvectionAlgorithm_Outside_UserCurve_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_ConvectionCoefficients_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_ConvectionCoefficients_MultipleSurface_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperties_VaporCoefficients_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_ExteriorNaturalVentedCavity_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_SolarIncidentInside_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_IncidentSolarMultiplier_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_LocalEnvironment_FieldEnums.hxx>
#include <utilities/idd/ZoneProperty_LocalEnvironment_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_SurroundingSurfaces_FieldEnums.hxx>
#include <utilities/idd/SurfaceProperty_GroundSurfaces_FieldEnums.hxx>
#include <utilities/idd/ComplexFenestrationProperty_SolarAbsorbedLayers_FieldEnums.hxx>
#include <utilities/idd/ZoneProperty_UserViewFactors_BySurfaceName_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Control_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_Materials_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_MatlProps_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_BoundConds_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_BldgProps_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_Insulation_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_EquivalentSlab_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_AutoGrid_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Slab_ManualGrid_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_SimParameters_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_MatlProps_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_Insulation_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_SurfaceProps_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_BldgData_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_Interior_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_ComBldg_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_EquivSlab_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_EquivAutoGrid_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_AutoGrid_FieldEnums.hxx>
#include <utilities/idd/GroundHeatTransfer_Basement_ManualGrid_FieldEnums.hxx>
#include <utilities/idd/RoomAirModelType_FieldEnums.hxx>
#include <utilities/idd/RoomAir_TemperaturePattern_UserDefined_FieldEnums.hxx>
#include <utilities/idd/RoomAir_TemperaturePattern_ConstantGradient_FieldEnums.hxx>
#include <utilities/idd/RoomAir_TemperaturePattern_TwoGradient_FieldEnums.hxx>
#include <utilities/idd/RoomAir_TemperaturePattern_NondimensionalHeight_FieldEnums.hxx>
#include <utilities/idd/RoomAir_TemperaturePattern_SurfaceMapping_FieldEnums.hxx>
#include <utilities/idd/RoomAir_Node_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_OneNodeDisplacementVentilation_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_ThreeNodeDisplacementVentilation_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_CrossVentilation_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_UnderFloorAirDistributionInterior_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_UnderFloorAirDistributionExterior_FieldEnums.hxx>
#include <utilities/idd/RoomAir_Node_AirflowNetwork_FieldEnums.hxx>
#include <utilities/idd/RoomAir_Node_AirflowNetwork_AdjacentSurfaceList_FieldEnums.hxx>
#include <utilities/idd/RoomAir_Node_AirflowNetwork_InternalGains_FieldEnums.hxx>
#include <utilities/idd/RoomAir_Node_AirflowNetwork_HVACEquipment_FieldEnums.hxx>
#include <utilities/idd/RoomAirSettings_AirflowNetwork_FieldEnums.hxx>
#include <utilities/idd/People_FieldEnums.hxx>
#include <utilities/idd/ComfortViewFactorAngles_FieldEnums.hxx>
#include <utilities/idd/Lights_FieldEnums.hxx>
#include <utilities/idd/ElectricEquipment_FieldEnums.hxx>
#include <utilities/idd/GasEquipment_FieldEnums.hxx>
#include <utilities/idd/HotWaterEquipment_FieldEnums.hxx>
#include <utilities/idd/SteamEquipment_FieldEnums.hxx>
#include <utilities/idd/OtherEquipment_FieldEnums.hxx>
#include <utilities/idd/IndoorLivingWall_FieldEnums.hxx>
#include <utilities/idd/ElectricEquipment_ITE_AirCooled_FieldEnums.hxx>
#include <utilities/idd/ZoneBaseboard_OutdoorTemperatureControlled_FieldEnums.hxx>
#include <utilities/idd/SwimmingPool_Indoor_FieldEnums.hxx>
#include <utilities/idd/ZoneContaminantSourceAndSink_CarbonDioxide_FieldEnums.hxx>
#include <utilities/idd/ZoneContaminantSourceAndSink_Generic_Constant_FieldEnums.hxx>
#include <utilities/idd/SurfaceContaminantSourceAndSink_Generic_PressureDriven_FieldEnums.hxx>
#include <utilities/idd/ZoneContaminantSourceAndSink_Generic_CutoffModel_FieldEnums.hxx>
#include <utilities/idd/ZoneContaminantSourceAndSink_Generic_DecaySource_FieldEnums.hxx>
#include <utilities/idd/SurfaceContaminantSourceAndSink_Generic_BoundaryLayerDiffusion_FieldEnums.hxx>
#include <utilities/idd/SurfaceContaminantSourceAndSink_Generic_DepositionVelocitySink_FieldEnums.hxx>
#include <utilities/idd/ZoneContaminantSourceAndSink_Generic_DepositionRateSink_FieldEnums.hxx>
#include <utilities/idd/Daylighting_Controls_FieldEnums.hxx>
#include <utilities/idd/Daylighting_ReferencePoint_FieldEnums.hxx>
#include <utilities/idd/Daylighting_DELight_ComplexFenestration_FieldEnums.hxx>
#include <utilities/idd/DaylightingDevice_Tubular_FieldEnums.hxx>
#include <utilities/idd/DaylightingDevice_Shelf_FieldEnums.hxx>
#include <utilities/idd/DaylightingDevice_LightWell_FieldEnums.hxx>
#include <utilities/idd/Output_DaylightFactors_FieldEnums.hxx>
#include <utilities/idd/Output_IlluminanceMap_FieldEnums.hxx>
#include <utilities/idd/OutputControl_IlluminanceMap_Style_FieldEnums.hxx>
#include <utilities/idd/ZoneInfiltration_DesignFlowRate_FieldEnums.hxx>
#include <utilities/idd/ZoneInfiltration_EffectiveLeakageArea_FieldEnums.hxx>
#include <utilities/idd/ZoneInfiltration_FlowCoefficient_FieldEnums.hxx>
#include <utilities/idd/ZoneVentilation_DesignFlowRate_FieldEnums.hxx>
#include <utilities/idd/ZoneVentilation_WindandStackOpenArea_FieldEnums.hxx>
#include <utilities/idd/ZoneAirBalance_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/ZoneMixing_FieldEnums.hxx>
#include <utilities/idd/ZoneCrossMixing_FieldEnums.hxx>
#include <utilities/idd/ZoneRefrigerationDoorMixing_FieldEnums.hxx>
#include <utilities/idd/ZoneEarthtube_FieldEnums.hxx>
#include <utilities/idd/ZoneEarthtube_Parameters_FieldEnums.hxx>
#include <utilities/idd/ZoneCoolTower_Shower_FieldEnums.hxx>
#include <utilities/idd/ZoneThermalChimney_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_SimulationControl_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Zone_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Surface_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_ReferenceCrackConditions_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Surface_Crack_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Surface_EffectiveLeakageArea_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_SpecifiedFlowRate_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Component_DetailedOpening_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Component_SimpleOpening_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Component_HorizontalOpening_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_Component_ZoneExhaustFan_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_ExternalNode_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_WindPressureCoefficientArray_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_MultiZone_WindPressureCoefficientValues_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_ZoneControl_PressureController_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Node_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_Leak_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_LeakageRatio_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_Duct_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_Fan_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_Coil_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_HeatExchanger_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_TerminalUnit_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_ConstantPressureDrop_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_OutdoorAirFlow_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Component_ReliefAirFlow_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_Linkage_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_Distribution_DuctViewFactors_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_OccupantVentilationControl_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_IntraZone_Node_FieldEnums.hxx>
#include <utilities/idd/AirflowNetwork_IntraZone_Linkage_FieldEnums.hxx>
#include <utilities/idd/Exterior_Lights_FieldEnums.hxx>
#include <utilities/idd/Exterior_FuelEquipment_FieldEnums.hxx>
#include <utilities/idd/Exterior_WaterEquipment_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Thermostat_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_IdealLoadsAirSystem_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_BaseboardHeat_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_FanCoil_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_PTAC_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_PTHP_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_WaterToAirHeatPump_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_VRF_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_Unitary_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_VAV_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_VAV_FanPowered_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_VAV_HeatAndCool_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Zone_DualDuct_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_VRF_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_Unitary_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_UnitaryHeatPump_AirToAir_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_UnitarySystem_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_VAV_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_PackagedVAV_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_DualDuct_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_System_DedicatedOutdoorAir_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_ChilledWaterLoop_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Chiller_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Chiller_ObjectReference_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Tower_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Tower_ObjectReference_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_HotWaterLoop_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Boiler_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_Boiler_ObjectReference_FieldEnums.hxx>
#include <utilities/idd/HVACTemplate_Plant_MixedWaterLoop_FieldEnums.hxx>
#include <utilities/idd/DesignSpecification_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/DesignSpecification_OutdoorAir_SpaceList_FieldEnums.hxx>
#include <utilities/idd/DesignSpecification_ZoneAirDistribution_FieldEnums.hxx>
#include <utilities/idd/Sizing_Parameters_FieldEnums.hxx>
#include <utilities/idd/Sizing_Zone_FieldEnums.hxx>
#include <utilities/idd/DesignSpecification_ZoneHVAC_Sizing_FieldEnums.hxx>
#include <utilities/idd/DesignSpecification_AirTerminal_Sizing_FieldEnums.hxx>
#include <utilities/idd/Sizing_System_FieldEnums.hxx>
#include <utilities/idd/Sizing_Plant_FieldEnums.hxx>
#include <utilities/idd/OutputControl_Sizing_Style_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Humidistat_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Thermostat_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Thermostat_OperativeTemperature_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Thermostat_ThermalComfort_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Thermostat_TemperatureAndHumidity_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_SingleHeating_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_SingleCooling_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_SingleHeatingOrCooling_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_DualSetpoint_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_ThermalComfort_Fanger_SingleHeating_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_ThermalComfort_Fanger_SingleCooling_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_ThermalComfort_Fanger_SingleHeatingOrCooling_FieldEnums.hxx>
#include <utilities/idd/ThermostatSetpoint_ThermalComfort_Fanger_DualSetpoint_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_Thermostat_StagedDualSetpoint_FieldEnums.hxx>
#include <utilities/idd/ZoneControl_ContaminantController_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_IdealLoadsAirSystem_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_FourPipeFanCoil_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_WindowAirConditioner_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_PackagedTerminalAirConditioner_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_PackagedTerminalHeatPump_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_WaterToAirHeatPump_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Dehumidifier_DX_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_EnergyRecoveryVentilator_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_EnergyRecoveryVentilator_Controller_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_UnitVentilator_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_UnitHeater_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_EvaporativeCoolerUnit_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_HybridUnitaryHVAC_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_OutdoorAirUnit_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_OutdoorAirUnit_EquipmentList_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_TerminalUnit_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_RadiantConvective_Water_Design_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_RadiantConvective_Water_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_RadiantConvective_Steam_Design_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_RadiantConvective_Steam_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_RadiantConvective_Electric_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_CoolingPanel_RadiantConvective_Water_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_Convective_Water_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_Baseboard_Convective_Electric_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_VariableFlow_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_VariableFlow_Design_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_ConstantFlow_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_ConstantFlow_Design_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_Electric_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_LowTemperatureRadiant_SurfaceGroup_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_HighTemperatureRadiant_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_VentilatedSlab_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_VentilatedSlab_SlabGroup_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ConstantVolume_Reheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ConstantVolume_NoReheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_VAV_NoReheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_VAV_Reheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_VAV_Reheat_VariableSpeedFan_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_VAV_HeatAndCool_NoReheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_VAV_HeatAndCool_Reheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_SeriesPIU_Reheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ParallelPIU_Reheat_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ConstantVolume_FourPipeInduction_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ConstantVolume_FourPipeBeam_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_ConstantVolume_CooledBeam_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_Mixer_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_DualDuct_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_DualDuct_VAV_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_DualDuct_VAV_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_AirDistributionUnit_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_ExhaustControl_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_EquipmentList_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_EquipmentConnections_FieldEnums.hxx>
#include <utilities/idd/SpaceHVAC_EquipmentConnections_FieldEnums.hxx>
#include <utilities/idd/SpaceHVAC_ZoneEquipmentSplitter_FieldEnums.hxx>
#include <utilities/idd/SpaceHVAC_ZoneEquipmentMixer_FieldEnums.hxx>
#include <utilities/idd/SpaceHVAC_ZoneReturnMixer_FieldEnums.hxx>
#include <utilities/idd/Fan_SystemModel_FieldEnums.hxx>
#include <utilities/idd/Fan_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/Fan_VariableVolume_FieldEnums.hxx>
#include <utilities/idd/Fan_OnOff_FieldEnums.hxx>
#include <utilities/idd/Fan_ZoneExhaust_FieldEnums.hxx>
#include <utilities/idd/FanPerformance_NightVentilation_FieldEnums.hxx>
#include <utilities/idd/Fan_ComponentModel_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_Water_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_Water_DetailedGeometry_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_Cooling_Water_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_CurveFit_Performance_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_CurveFit_OperatingMode_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_CurveFit_Speed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_TwoStageWithHumidityControlMode_FieldEnums.hxx>
#include <utilities/idd/CoilPerformance_DX_Cooling_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_DX_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_DX_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Water_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Steam_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Electric_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Electric_MultiStage_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Fuel_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Gas_MultiStage_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_Desuperheater_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_DX_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_DX_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_DX_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_WaterToAirHeatPump_ParameterEstimation_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_WaterToAirHeatPump_ParameterEstimation_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_WaterToAirHeatPump_EquationFit_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_WaterToAirHeatPump_EquationFit_FieldEnums.hxx>
#include <utilities/idd/Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit_FieldEnums.hxx>
#include <utilities/idd/Coil_WaterHeating_AirToWaterHeatPump_Pumped_FieldEnums.hxx>
#include <utilities/idd/Coil_WaterHeating_AirToWaterHeatPump_Wrapped_FieldEnums.hxx>
#include <utilities/idd/Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/Coil_WaterHeating_Desuperheater_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_Cooling_DX_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_Heating_DX_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_Cooling_Water_HeatExchangerAssisted_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_Cooling_DX_HeatExchangerAssisted_FieldEnums.hxx>
#include <utilities/idd/CoilSystem_IntegratedHeatPump_AirSource_FieldEnums.hxx>
#include <utilities/idd/Coil_Cooling_DX_SingleSpeed_ThermalStorage_FieldEnums.hxx>
#include <utilities/idd/EvaporativeCooler_Direct_CelDekPad_FieldEnums.hxx>
#include <utilities/idd/EvaporativeCooler_Indirect_CelDekPad_FieldEnums.hxx>
#include <utilities/idd/EvaporativeCooler_Indirect_WetCoil_FieldEnums.hxx>
#include <utilities/idd/EvaporativeCooler_Indirect_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/EvaporativeCooler_Direct_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/Humidifier_Steam_Electric_FieldEnums.hxx>
#include <utilities/idd/Humidifier_Steam_Gas_FieldEnums.hxx>
#include <utilities/idd/Dehumidifier_Desiccant_NoFans_FieldEnums.hxx>
#include <utilities/idd/Dehumidifier_Desiccant_System_FieldEnums.hxx>
#include <utilities/idd/HeatExchanger_AirToAir_FlatPlate_FieldEnums.hxx>
#include <utilities/idd/HeatExchanger_AirToAir_SensibleAndLatent_FieldEnums.hxx>
#include <utilities/idd/HeatExchanger_Desiccant_BalancedFlow_FieldEnums.hxx>
#include <utilities/idd/HeatExchanger_Desiccant_BalancedFlow_PerformanceDataType1_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitarySystem_FieldEnums.hxx>
#include <utilities/idd/UnitarySystemPerformance_Multispeed_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_Unitary_Furnace_HeatOnly_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_Unitary_Furnace_HeatCool_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatOnly_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatCool_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatPump_AirToAir_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatPump_WaterToAir_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatCool_VAVChangeoverBypass_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_UnitaryHeatPump_AirToAir_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/AirConditioner_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_HR_FieldEnums.hxx>
#include <utilities/idd/ZoneTerminalUnitList_FieldEnums.hxx>
#include <utilities/idd/Controller_WaterCoil_FieldEnums.hxx>
#include <utilities/idd/Controller_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/Controller_MechanicalVentilation_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ControllerList_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_OutdoorAirSystem_EquipmentList_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_OutdoorAirSystem_FieldEnums.hxx>
#include <utilities/idd/OutdoorAir_Mixer_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ZoneSplitter_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_SupplyPlenum_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_SupplyPath_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ZoneMixer_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ReturnPlenum_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ReturnPath_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_ExhaustSystem_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_DedicatedOutdoorAirSystem_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_Mixer_FieldEnums.hxx>
#include <utilities/idd/AirLoopHVAC_Splitter_FieldEnums.hxx>
#include <utilities/idd/Branch_FieldEnums.hxx>
#include <utilities/idd/BranchList_FieldEnums.hxx>
#include <utilities/idd/Connector_Splitter_FieldEnums.hxx>
#include <utilities/idd/Connector_Mixer_FieldEnums.hxx>
#include <utilities/idd/ConnectorList_FieldEnums.hxx>
#include <utilities/idd/NodeList_FieldEnums.hxx>
#include <utilities/idd/OutdoorAir_Node_FieldEnums.hxx>
#include <utilities/idd/OutdoorAir_NodeList_FieldEnums.hxx>
#include <utilities/idd/Pipe_Adiabatic_FieldEnums.hxx>
#include <utilities/idd/Pipe_Adiabatic_Steam_FieldEnums.hxx>
#include <utilities/idd/Pipe_Indoor_FieldEnums.hxx>
#include <utilities/idd/Pipe_Outdoor_FieldEnums.hxx>
#include <utilities/idd/Pipe_Underground_FieldEnums.hxx>
#include <utilities/idd/PipingSystem_Underground_Domain_FieldEnums.hxx>
#include <utilities/idd/PipingSystem_Underground_PipeCircuit_FieldEnums.hxx>
#include <utilities/idd/PipingSystem_Underground_PipeSegment_FieldEnums.hxx>
#include <utilities/idd/Duct_FieldEnums.hxx>
#include <utilities/idd/Pump_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/Pump_ConstantSpeed_FieldEnums.hxx>
#include <utilities/idd/Pump_VariableSpeed_Condensate_FieldEnums.hxx>
#include <utilities/idd/HeaderedPumps_ConstantSpeed_FieldEnums.hxx>
#include <utilities/idd/HeaderedPumps_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/TemperingValve_FieldEnums.hxx>
#include <utilities/idd/LoadProfile_Plant_FieldEnums.hxx>
#include <utilities/idd/SolarCollectorPerformance_FlatPlate_FieldEnums.hxx>
#include <utilities/idd/SolarCollector_FlatPlate_Water_FieldEnums.hxx>
#include <utilities/idd/SolarCollector_FlatPlate_PhotovoltaicThermal_FieldEnums.hxx>
#include <utilities/idd/SolarCollectorPerformance_PhotovoltaicThermal_Simple_FieldEnums.hxx>
#include <utilities/idd/SolarCollectorPerformance_PhotovoltaicThermal_BIPVT_FieldEnums.hxx>
#include <utilities/idd/SolarCollector_IntegralCollectorStorage_FieldEnums.hxx>
#include <utilities/idd/SolarCollectorPerformance_IntegralCollectorStorage_FieldEnums.hxx>
#include <utilities/idd/SolarCollector_UnglazedTranspired_FieldEnums.hxx>
#include <utilities/idd/SolarCollector_UnglazedTranspired_Multisystem_FieldEnums.hxx>
#include <utilities/idd/Boiler_HotWater_FieldEnums.hxx>
#include <utilities/idd/Boiler_Steam_FieldEnums.hxx>
#include <utilities/idd/Chiller_Electric_ASHRAE205_FieldEnums.hxx>
#include <utilities/idd/Chiller_Electric_EIR_FieldEnums.hxx>
#include <utilities/idd/Chiller_Electric_ReformulatedEIR_FieldEnums.hxx>
#include <utilities/idd/Chiller_Electric_FieldEnums.hxx>
#include <utilities/idd/Chiller_Absorption_Indirect_FieldEnums.hxx>
#include <utilities/idd/Chiller_Absorption_FieldEnums.hxx>
#include <utilities/idd/Chiller_ConstantCOP_FieldEnums.hxx>
#include <utilities/idd/Chiller_EngineDriven_FieldEnums.hxx>
#include <utilities/idd/Chiller_CombustionTurbine_FieldEnums.hxx>
#include <utilities/idd/ChillerHeater_Absorption_DirectFired_FieldEnums.hxx>
#include <utilities/idd/ChillerHeater_Absorption_DoubleEffect_FieldEnums.hxx>
#include <utilities/idd/HeatPump_PlantLoop_EIR_Cooling_FieldEnums.hxx>
#include <utilities/idd/HeatPump_PlantLoop_EIR_Heating_FieldEnums.hxx>
#include <utilities/idd/HeatPump_AirToWater_FuelFired_Heating_FieldEnums.hxx>
#include <utilities/idd/HeatPump_AirToWater_FuelFired_Cooling_FieldEnums.hxx>
#include <utilities/idd/HeatPump_WaterToWater_EquationFit_Heating_FieldEnums.hxx>
#include <utilities/idd/HeatPump_WaterToWater_EquationFit_Cooling_FieldEnums.hxx>
#include <utilities/idd/HeatPump_WaterToWater_ParameterEstimation_Cooling_FieldEnums.hxx>
#include <utilities/idd/HeatPump_WaterToWater_ParameterEstimation_Heating_FieldEnums.hxx>
#include <utilities/idd/DistrictCooling_FieldEnums.hxx>
#include <utilities/idd/DistrictHeating_Water_FieldEnums.hxx>
#include <utilities/idd/DistrictHeating_Steam_FieldEnums.hxx>
#include <utilities/idd/PlantComponent_TemperatureSource_FieldEnums.hxx>
#include <utilities/idd/CentralHeatPumpSystem_FieldEnums.hxx>
#include <utilities/idd/ChillerHeaterPerformance_Electric_EIR_FieldEnums.hxx>
#include <utilities/idd/CoolingTower_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/CoolingTower_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/CoolingTower_VariableSpeed_Merkel_FieldEnums.hxx>
#include <utilities/idd/CoolingTower_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/CoolingTowerPerformance_CoolTools_FieldEnums.hxx>
#include <utilities/idd/CoolingTowerPerformance_YorkCalc_FieldEnums.hxx>
#include <utilities/idd/EvaporativeFluidCooler_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/EvaporativeFluidCooler_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/FluidCooler_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/FluidCooler_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_System_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Vertical_Properties_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Vertical_Array_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Vertical_Single_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_ResponseFactors_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Pond_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Surface_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_HorizontalTrench_FieldEnums.hxx>
#include <utilities/idd/GroundHeatExchanger_Slinky_FieldEnums.hxx>
#include <utilities/idd/HeatExchanger_FluidToFluid_FieldEnums.hxx>
#include <utilities/idd/WaterHeater_Mixed_FieldEnums.hxx>
#include <utilities/idd/WaterHeater_Stratified_FieldEnums.hxx>
#include <utilities/idd/WaterHeater_Sizing_FieldEnums.hxx>
#include <utilities/idd/WaterHeater_HeatPump_PumpedCondenser_FieldEnums.hxx>
#include <utilities/idd/WaterHeater_HeatPump_WrappedCondenser_FieldEnums.hxx>
#include <utilities/idd/ThermalStorage_Ice_Simple_FieldEnums.hxx>
#include <utilities/idd/ThermalStorage_Ice_Detailed_FieldEnums.hxx>
#include <utilities/idd/ThermalStorage_ChilledWater_Mixed_FieldEnums.hxx>
#include <utilities/idd/ThermalStorage_ChilledWater_Stratified_FieldEnums.hxx>
#include <utilities/idd/PlantLoop_FieldEnums.hxx>
#include <utilities/idd/CondenserLoop_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentList_FieldEnums.hxx>
#include <utilities/idd/CondenserEquipmentList_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_Uncontrolled_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_CoolingLoad_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_HeatingLoad_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorDryBulb_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorWetBulb_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorRelativeHumidity_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorDewpoint_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_ComponentSetpoint_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_ThermalEnergyStorage_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorDryBulbDifference_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorWetBulbDifference_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_OutdoorDewpointDifference_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_ChillerHeaterChangeover_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperationSchemes_FieldEnums.hxx>
#include <utilities/idd/CondenserEquipmentOperationSchemes_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_Sensor_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_Actuator_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_ProgramCallingManager_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_Program_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_Subroutine_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_GlobalVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_OutputVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_MeteredOutputVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_TrendVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_InternalVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_CurveOrTableIndexVariable_FieldEnums.hxx>
#include <utilities/idd/EnergyManagementSystem_ConstructionIndexVariable_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_Schedule_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_Variable_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_Actuator_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitImport_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitImport_From_Variable_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitImport_To_Schedule_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitImport_To_Actuator_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitImport_To_Variable_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitExport_From_Variable_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitExport_To_Schedule_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitExport_To_Actuator_FieldEnums.hxx>
#include <utilities/idd/ExternalInterface_FunctionalMockupUnitExport_To_Variable_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_ForcedAir_UserDefined_FieldEnums.hxx>
#include <utilities/idd/AirTerminal_SingleDuct_UserDefined_FieldEnums.hxx>
#include <utilities/idd/Coil_UserDefined_FieldEnums.hxx>
#include <utilities/idd/PlantComponent_UserDefined_FieldEnums.hxx>
#include <utilities/idd/PlantEquipmentOperation_UserDefined_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_Scheduled_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_ScheduledOn_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_ScheduledOff_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_OptimumStart_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_NightCycle_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_DifferentialThermostat_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_HighTemperatureTurnOff_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_HighTemperatureTurnOn_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_LowTemperatureTurnOff_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_LowTemperatureTurnOn_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_NightVentilation_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManager_HybridVentilation_FieldEnums.hxx>
#include <utilities/idd/AvailabilityManagerAssignmentList_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_Scheduled_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_Scheduled_DualSetpoint_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_OutdoorAirReset_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_Reheat_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_Heating_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_Cooling_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_Humidity_Minimum_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_Humidity_Maximum_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MixedAir_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_OutdoorAirPretreat_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_Warmest_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_Coldest_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_ReturnAirBypassFlow_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_WarmestTemperatureFlow_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_Heating_Average_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_Cooling_Average_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_MinimumHumidity_Average_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_MaximumHumidity_Average_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_Humidity_Minimum_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_MultiZone_Humidity_Maximum_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_FollowOutdoorAirTemperature_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_FollowSystemNodeTemperature_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_FollowGroundTemperature_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_CondenserEnteringReset_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_CondenserEnteringReset_Ideal_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_OneStageCooling_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SingleZone_OneStageHeating_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_ReturnTemperature_ChilledWater_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_ReturnTemperature_HotWater_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SystemNodeReset_Temperature_FieldEnums.hxx>
#include <utilities/idd/SetpointManager_SystemNodeReset_Humidity_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Case_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_CompressorRack_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_CaseAndWalkInList_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Condenser_AirCooled_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Condenser_EvaporativeCooled_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Condenser_WaterCooled_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Condenser_Cascade_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_GasCooler_AirCooled_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_TransferLoadList_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Subcooler_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_Compressor_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_CompressorList_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_System_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_TranscriticalSystem_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_SecondarySystem_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_WalkIn_FieldEnums.hxx>
#include <utilities/idd/Refrigeration_AirChiller_FieldEnums.hxx>
#include <utilities/idd/ZoneHVAC_RefrigerationChillerSet_FieldEnums.hxx>
#include <utilities/idd/DemandManagerAssignmentList_FieldEnums.hxx>
#include <utilities/idd/DemandManager_ExteriorLights_FieldEnums.hxx>
#include <utilities/idd/DemandManager_Lights_FieldEnums.hxx>
#include <utilities/idd/DemandManager_ElectricEquipment_FieldEnums.hxx>
#include <utilities/idd/DemandManager_Thermostats_FieldEnums.hxx>
#include <utilities/idd/DemandManager_Ventilation_FieldEnums.hxx>
#include <utilities/idd/Generator_InternalCombustionEngine_FieldEnums.hxx>
#include <utilities/idd/Generator_CombustionTurbine_FieldEnums.hxx>
#include <utilities/idd/Generator_MicroTurbine_FieldEnums.hxx>
#include <utilities/idd/Generator_Photovoltaic_FieldEnums.hxx>
#include <utilities/idd/PhotovoltaicPerformance_Simple_FieldEnums.hxx>
#include <utilities/idd/PhotovoltaicPerformance_EquivalentOneDiode_FieldEnums.hxx>
#include <utilities/idd/PhotovoltaicPerformance_Sandia_FieldEnums.hxx>
#include <utilities/idd/Generator_PVWatts_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Inverter_PVWatts_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_PowerModule_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_AirSupply_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_WaterSupply_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_AuxiliaryHeater_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_ExhaustGasToWaterHeatExchanger_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_ElectricalStorage_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_Inverter_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelCell_StackCooler_FieldEnums.hxx>
#include <utilities/idd/Generator_MicroCHP_FieldEnums.hxx>
#include <utilities/idd/Generator_MicroCHP_NonNormalizedParameters_FieldEnums.hxx>
#include <utilities/idd/Generator_FuelSupply_FieldEnums.hxx>
#include <utilities/idd/Generator_WindTurbine_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Generators_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Inverter_Simple_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Inverter_FunctionOfPower_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Inverter_LookUpTable_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Storage_Simple_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Storage_Battery_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Storage_LiIonNMCBattery_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Transformer_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Distribution_FieldEnums.hxx>
#include <utilities/idd/ElectricLoadCenter_Storage_Converter_FieldEnums.hxx>
#include <utilities/idd/WaterUse_Equipment_FieldEnums.hxx>
#include <utilities/idd/WaterUse_Connections_FieldEnums.hxx>
#include <utilities/idd/WaterUse_Storage_FieldEnums.hxx>
#include <utilities/idd/WaterUse_Well_FieldEnums.hxx>
#include <utilities/idd/WaterUse_RainCollector_FieldEnums.hxx>
#include <utilities/idd/FaultModel_TemperatureSensorOffset_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_HumiditySensorOffset_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_EnthalpySensorOffset_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_TemperatureSensorOffset_ReturnAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_EnthalpySensorOffset_ReturnAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_TemperatureSensorOffset_ChillerSupplyWater_FieldEnums.hxx>
#include <utilities/idd/FaultModel_TemperatureSensorOffset_CoilSupplyAir_FieldEnums.hxx>
#include <utilities/idd/FaultModel_TemperatureSensorOffset_CondenserSupplyWater_FieldEnums.hxx>
#include <utilities/idd/FaultModel_ThermostatOffset_FieldEnums.hxx>
#include <utilities/idd/FaultModel_HumidistatOffset_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_AirFilter_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_Boiler_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_EvaporativeCooler_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_Chiller_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_CoolingTower_FieldEnums.hxx>
#include <utilities/idd/FaultModel_Fouling_Coil_FieldEnums.hxx>
#include <utilities/idd/Matrix_TwoDimension_FieldEnums.hxx>
#include <utilities/idd/HybridModel_Zone_FieldEnums.hxx>
#include <utilities/idd/Curve_Linear_FieldEnums.hxx>
#include <utilities/idd/Curve_QuadLinear_FieldEnums.hxx>
#include <utilities/idd/Curve_QuintLinear_FieldEnums.hxx>
#include <utilities/idd/Curve_Quadratic_FieldEnums.hxx>
#include <utilities/idd/Curve_Cubic_FieldEnums.hxx>
#include <utilities/idd/Curve_Quartic_FieldEnums.hxx>
#include <utilities/idd/Curve_Exponent_FieldEnums.hxx>
#include <utilities/idd/Curve_Bicubic_FieldEnums.hxx>
#include <utilities/idd/Curve_Biquadratic_FieldEnums.hxx>
#include <utilities/idd/Curve_QuadraticLinear_FieldEnums.hxx>
#include <utilities/idd/Curve_CubicLinear_FieldEnums.hxx>
#include <utilities/idd/Curve_Triquadratic_FieldEnums.hxx>
#include <utilities/idd/Curve_Functional_PressureDrop_FieldEnums.hxx>
#include <utilities/idd/Curve_FanPressureRise_FieldEnums.hxx>
#include <utilities/idd/Curve_ExponentialSkewNormal_FieldEnums.hxx>
#include <utilities/idd/Curve_Sigmoid_FieldEnums.hxx>
#include <utilities/idd/Curve_RectangularHyperbola1_FieldEnums.hxx>
#include <utilities/idd/Curve_RectangularHyperbola2_FieldEnums.hxx>
#include <utilities/idd/Curve_ExponentialDecay_FieldEnums.hxx>
#include <utilities/idd/Curve_DoubleExponentialDecay_FieldEnums.hxx>
#include <utilities/idd/Curve_ChillerPartLoadWithLift_FieldEnums.hxx>
#include <utilities/idd/Table_IndependentVariable_FieldEnums.hxx>
#include <utilities/idd/Table_IndependentVariableList_FieldEnums.hxx>
#include <utilities/idd/Table_Lookup_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_Name_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_GlycolConcentration_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_Temperatures_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_Saturated_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_Superheated_FieldEnums.hxx>
#include <utilities/idd/FluidProperties_Concentration_FieldEnums.hxx>
#include <utilities/idd/CurrencyType_FieldEnums.hxx>
#include <utilities/idd/ComponentCost_Adjustments_FieldEnums.hxx>
#include <utilities/idd/ComponentCost_Reference_FieldEnums.hxx>
#include <utilities/idd/ComponentCost_LineItem_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Tariff_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Qualify_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Charge_Simple_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Charge_Block_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Ratchet_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Variable_FieldEnums.hxx>
#include <utilities/idd/UtilityCost_Computation_FieldEnums.hxx>
#include <utilities/idd/LifeCycleCost_Parameters_FieldEnums.hxx>
#include <utilities/idd/LifeCycleCost_RecurringCosts_FieldEnums.hxx>
#include <utilities/idd/LifeCycleCost_NonrecurringCost_FieldEnums.hxx>
#include <utilities/idd/LifeCycleCost_UsePriceEscalation_FieldEnums.hxx>
#include <utilities/idd/LifeCycleCost_UseAdjustment_FieldEnums.hxx>
#include <utilities/idd/Parametric_SetValueForRun_FieldEnums.hxx>
#include <utilities/idd/Parametric_Logic_FieldEnums.hxx>
#include <utilities/idd/Parametric_RunControl_FieldEnums.hxx>
#include <utilities/idd/Parametric_FileNameSuffix_FieldEnums.hxx>
#include <utilities/idd/Output_VariableDictionary_FieldEnums.hxx>
#include <utilities/idd/Output_Surfaces_List_FieldEnums.hxx>
#include <utilities/idd/Output_Surfaces_Drawing_FieldEnums.hxx>
#include <utilities/idd/Output_Schedules_FieldEnums.hxx>
#include <utilities/idd/Output_Constructions_FieldEnums.hxx>
#include <utilities/idd/Output_EnergyManagementSystem_FieldEnums.hxx>
#include <utilities/idd/OutputControl_SurfaceColorScheme_FieldEnums.hxx>
#include <utilities/idd/Output_Table_SummaryReports_FieldEnums.hxx>
#include <utilities/idd/Output_Table_TimeBins_FieldEnums.hxx>
#include <utilities/idd/Output_Table_Monthly_FieldEnums.hxx>
#include <utilities/idd/Output_Table_Annual_FieldEnums.hxx>
#include <utilities/idd/OutputControl_Table_Style_FieldEnums.hxx>
#include <utilities/idd/OutputControl_ReportingTolerances_FieldEnums.hxx>
#include <utilities/idd/OutputControl_ResilienceSummaries_FieldEnums.hxx>
#include <utilities/idd/Output_Variable_FieldEnums.hxx>
#include <utilities/idd/Output_Meter_FieldEnums.hxx>
#include <utilities/idd/Output_Meter_MeterFileOnly_FieldEnums.hxx>
#include <utilities/idd/Output_Meter_Cumulative_FieldEnums.hxx>
#include <utilities/idd/Output_Meter_Cumulative_MeterFileOnly_FieldEnums.hxx>
#include <utilities/idd/Meter_Custom_FieldEnums.hxx>
#include <utilities/idd/Meter_CustomDecrement_FieldEnums.hxx>
#include <utilities/idd/OutputControl_Files_FieldEnums.hxx>
#include <utilities/idd/OutputControl_Timestamp_FieldEnums.hxx>
#include <utilities/idd/Output_JSON_FieldEnums.hxx>
#include <utilities/idd/Output_SQLite_FieldEnums.hxx>
#include <utilities/idd/Output_EnvironmentalImpactFactors_FieldEnums.hxx>
#include <utilities/idd/EnvironmentalImpactFactors_FieldEnums.hxx>
#include <utilities/idd/FuelFactors_FieldEnums.hxx>
#include <utilities/idd/Output_Diagnostics_FieldEnums.hxx>
#include <utilities/idd/Output_DebuggingData_FieldEnums.hxx>
#include <utilities/idd/Output_PreprocessorMessage_FieldEnums.hxx>
#include <utilities/idd/PythonPlugin_SearchPaths_FieldEnums.hxx>
#include <utilities/idd/PythonPlugin_Instance_FieldEnums.hxx>
#include <utilities/idd/PythonPlugin_Variables_FieldEnums.hxx>
#include <utilities/idd/PythonPlugin_TrendVariable_FieldEnums.hxx>
#include <utilities/idd/PythonPlugin_OutputVariable_FieldEnums.hxx>
#include <utilities/idd/OS_Version_FieldEnums.hxx>
#include <utilities/idd/OS_ComponentData_FieldEnums.hxx>
#include <utilities/idd/OS_ConvergenceLimits_FieldEnums.hxx>
#include <utilities/idd/OS_ProgramControl_FieldEnums.hxx>
#include <utilities/idd/OS_HeatBalanceAlgorithm_FieldEnums.hxx>
#include <utilities/idd/OS_RunPeriod_FieldEnums.hxx>
#include <utilities/idd/OS_RunPeriodControl_DaylightSavingTime_FieldEnums.hxx>
#include <utilities/idd/OS_RunPeriodControl_SpecialDays_FieldEnums.hxx>
#include <utilities/idd/OS_ShadowCalculation_FieldEnums.hxx>
#include <utilities/idd/OS_SimulationControl_FieldEnums.hxx>
#include <utilities/idd/OS_PerformancePrecisionTradeoffs_FieldEnums.hxx>
#include <utilities/idd/OS_Sizing_Parameters_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceConvectionAlgorithm_Inside_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceConvectionAlgorithm_Outside_FieldEnums.hxx>
#include <utilities/idd/OS_Timestep_FieldEnums.hxx>
#include <utilities/idd/OS_YearDescription_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneAirContaminantBalance_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneAirHeatBalanceAlgorithm_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneAirMassFlowConservation_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneCapacitanceMultiplier_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/OS_RadianceParameters_FieldEnums.hxx>
#include <utilities/idd/OS_ClimateZones_FieldEnums.hxx>
#include <utilities/idd/OS_Site_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_BuildingSurface_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_FCfactorMethod_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_Shallow_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_Deep_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_Undisturbed_KusudaAchenbach_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundTemperature_Undisturbed_Xing_FieldEnums.hxx>
#include <utilities/idd/OS_Site_GroundReflectance_FieldEnums.hxx>
#include <utilities/idd/OS_Site_WaterMainsTemperature_FieldEnums.hxx>
#include <utilities/idd/OS_SizingPeriod_DesignDay_FieldEnums.hxx>
#include <utilities/idd/OS_SizingPeriod_WeatherFileConditionType_FieldEnums.hxx>
#include <utilities/idd/OS_SizingPeriod_WeatherFileDays_FieldEnums.hxx>
#include <utilities/idd/OS_WeatherFile_FieldEnums.hxx>
#include <utilities/idd/OS_WeatherProperty_SkyTemperature_FieldEnums.hxx>
#include <utilities/idd/OS_AdditionalProperties_FieldEnums.hxx>
#include <utilities/idd/OS_BuildingStory_FieldEnums.hxx>
#include <utilities/idd/OS_BuildingUnit_FieldEnums.hxx>
#include <utilities/idd/OS_DefaultConstructionSet_FieldEnums.hxx>
#include <utilities/idd/OS_DefaultScheduleSet_FieldEnums.hxx>
#include <utilities/idd/OS_DefaultSubSurfaceConstructions_FieldEnums.hxx>
#include <utilities/idd/OS_DefaultSurfaceConstructions_FieldEnums.hxx>
#include <utilities/idd/OS_Rendering_Color_FieldEnums.hxx>
#include <utilities/idd/OS_SpaceType_FieldEnums.hxx>
#include <utilities/idd/OS_ModelObjectList_FieldEnums.hxx>
#include <utilities/idd/OS_Material_FieldEnums.hxx>
#include <utilities/idd/OS_Material_AirGap_FieldEnums.hxx>
#include <utilities/idd/OS_Material_InfraredTransparent_FieldEnums.hxx>
#include <utilities/idd/OS_Material_NoMass_FieldEnums.hxx>
#include <utilities/idd/OS_Material_RoofVegetation_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Blind_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_DaylightRedirectionDevice_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Gas_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_GasMixture_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Glazing_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_GlazingGroup_Thermochromic_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Glazing_RefractionExtinctionMethod_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Screen_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_Shade_FieldEnums.hxx>
#include <utilities/idd/OS_WindowMaterial_SimpleGlazingSystem_FieldEnums.hxx>
#include <utilities/idd/OS_StandardsInformation_Material_FieldEnums.hxx>
#include <utilities/idd/OS_MaterialProperty_GlazingSpectralData_FieldEnums.hxx>
#include <utilities/idd/OS_MaterialProperty_MoisturePenetrationDepth_Settings_FieldEnums.hxx>
#include <utilities/idd/OS_MaterialProperty_PhaseChange_FieldEnums.hxx>
#include <utilities/idd/OS_MaterialProperty_PhaseChangeHysteresis_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_CfactorUndergroundWall_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_FfactorGroundFloor_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_InternalSource_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_AirBoundary_FieldEnums.hxx>
#include <utilities/idd/OS_Construction_WindowDataFile_FieldEnums.hxx>
#include <utilities/idd/OS_StandardsInformation_Construction_FieldEnums.hxx>
#include <utilities/idd/OS_InternalMass_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_People_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Lights_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Luminaire_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricEquipment_ITE_AirCooled_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_GasEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_HotWaterEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_SteamEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_OtherEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_Lights_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_FuelEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_WaterEquipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Compact_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Day_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Week_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Year_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Rule_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Ruleset_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_Constant_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_FixedInterval_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_VariableInterval_FieldEnums.hxx>
#include <utilities/idd/OS_ScheduleTypeLimits_FieldEnums.hxx>
#include <utilities/idd/OS_External_File_FieldEnums.hxx>
#include <utilities/idd/OS_Schedule_File_FieldEnums.hxx>
#include <utilities/idd/OS_Building_FieldEnums.hxx>
#include <utilities/idd/OS_DaylightingDevice_Tubular_FieldEnums.hxx>
#include <utilities/idd/OS_DaylightingDevice_Shelf_FieldEnums.hxx>
#include <utilities/idd/OS_DaylightingDevice_LightWell_FieldEnums.hxx>
#include <utilities/idd/OS_Facility_FieldEnums.hxx>
#include <utilities/idd/OS_InteriorPartitionSurface_FieldEnums.hxx>
#include <utilities/idd/OS_InteriorPartitionSurfaceGroup_FieldEnums.hxx>
#include <utilities/idd/OS_ShadingSurface_FieldEnums.hxx>
#include <utilities/idd/OS_ShadingSurfaceGroup_FieldEnums.hxx>
#include <utilities/idd/OS_Space_FieldEnums.hxx>
#include <utilities/idd/OS_Surface_FieldEnums.hxx>
#include <utilities/idd/OS_SubSurface_FieldEnums.hxx>
#include <utilities/idd/OS_ShadingControl_FieldEnums.hxx>
#include <utilities/idd/OS_WindowProperty_FrameAndDivider_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceControl_MovableInsulation_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_ConvectionCoefficients_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_ConvectionCoefficients_MultipleSurface_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_ExposedFoundationPerimeter_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_OtherSideCoefficients_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_OtherSideConditionsModel_FieldEnums.hxx>
#include <utilities/idd/OS_Foundation_Kiva_FieldEnums.hxx>
#include <utilities/idd/OS_Foundation_Kiva_Settings_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneProperty_UserViewFactors_BySurfaceName_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_SurroundingSurfaces_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_LocalEnvironment_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_GroundSurfaces_FieldEnums.hxx>
#include <utilities/idd/OS_SurfaceProperty_IncidentSolarMultiplier_FieldEnums.hxx>
#include <utilities/idd/OS_InternalMass_FieldEnums.hxx>
#include <utilities/idd/OS_People_FieldEnums.hxx>
#include <utilities/idd/OS_Lights_FieldEnums.hxx>
#include <utilities/idd/OS_Luminaire_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricEquipment_ITE_AirCooled_FieldEnums.hxx>
#include <utilities/idd/OS_GasEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_HotWaterEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_SteamEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_OtherEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_SpaceInfiltration_DesignFlowRate_FieldEnums.hxx>
#include <utilities/idd/OS_SpaceInfiltration_EffectiveLeakageArea_FieldEnums.hxx>
#include <utilities/idd/OS_SpaceInfiltration_FlowCoefficient_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_Lights_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_FuelEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_Exterior_WaterEquipment_FieldEnums.hxx>
#include <utilities/idd/OS_Daylighting_Control_FieldEnums.hxx>
#include <utilities/idd/OS_Glare_Sensor_FieldEnums.hxx>
#include <utilities/idd/OS_IlluminanceMap_FieldEnums.hxx>
#include <utilities/idd/OS_LightingDesignDay_FieldEnums.hxx>
#include <utilities/idd/OS_LightingSimulationControl_FieldEnums.hxx>
#include <utilities/idd/OS_LightingSimulationZone_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Case_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Condenser_AirCooled_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Condenser_EvaporativeCooled_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Condenser_WaterCooled_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Condenser_Cascade_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Compressor_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_CompressorRack_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_DefrostCycleParameters_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_GasCooler_AirCooled_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Subcooler_Mechanical_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_Subcooler_LiquidSuction_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_System_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_TranscriticalSystem_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_SecondarySystem_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_WalkIn_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_WalkIn_ZoneBoundary_FieldEnums.hxx>
#include <utilities/idd/OS_Refrigeration_AirChiller_FieldEnums.hxx>
#include <utilities/idd/OS_AirConditioner_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_LoadingIndex_FieldEnums.hxx>
#include <utilities/idd/OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_HR_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_OutdoorAirSystem_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_DedicatedOutdoorAirSystem_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_ReturnPlenum_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_SupplyPlenum_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_UnitaryHeatPump_AirToAir_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_UnitaryCoolOnly_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_UnitaryHeatPump_AirToAir_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_UnitaryHeatCool_VAVChangeoverBypass_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_UnitarySystem_FieldEnums.hxx>
#include <utilities/idd/OS_UnitarySystemPerformance_Multispeed_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_ZoneMixer_FieldEnums.hxx>
#include <utilities/idd/OS_AirLoopHVAC_ZoneSplitter_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_VAV_HeatAndCool_NoReheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_VAV_HeatAndCool_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_InletSideMixer_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ConstantVolume_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_SeriesPIU_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ParallelPIU_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ConstantVolume_FourPipeInduction_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ConstantVolume_FourPipeBeam_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ConstantVolume_CooledBeam_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_ConstantVolume_NoReheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_VAV_NoReheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_SingleDuct_VAV_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_DualDuct_VAV_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_DualDuct_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/OS_AirTerminal_DualDuct_VAV_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManagerAssignmentList_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_Scheduled_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_ScheduledOn_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_ScheduledOff_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_NightCycle_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_OptimumStart_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_DifferentialThermostat_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_HighTemperatureTurnOff_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_HighTemperatureTurnOn_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_LowTemperatureTurnOff_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_LowTemperatureTurnOn_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_NightVentilation_FieldEnums.hxx>
#include <utilities/idd/OS_AvailabilityManager_HybridVentilation_FieldEnums.hxx>
#include <utilities/idd/OS_Boiler_HotWater_FieldEnums.hxx>
#include <utilities/idd/OS_Boiler_Steam_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_WaterToWater_EquationFit_Heating_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_WaterToWater_EquationFit_Cooling_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_PlantLoop_EIR_Heating_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_PlantLoop_EIR_Cooling_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_AirToWater_FuelFired_Heating_FieldEnums.hxx>
#include <utilities/idd/OS_HeatPump_AirToWater_FuelFired_Cooling_FieldEnums.hxx>
#include <utilities/idd/OS_Chiller_Electric_EIR_FieldEnums.hxx>
#include <utilities/idd/OS_Chiller_Electric_ReformulatedEIR_FieldEnums.hxx>
#include <utilities/idd/OS_Chiller_Electric_ASHRAE205_FieldEnums.hxx>
#include <utilities/idd/OS_CentralHeatPumpSystem_FieldEnums.hxx>
#include <utilities/idd/OS_CentralHeatPumpSystem_Module_FieldEnums.hxx>
#include <utilities/idd/OS_ChillerHeaterPerformance_Electric_EIR_FieldEnums.hxx>
#include <utilities/idd/OS_Chiller_Absorption_Indirect_FieldEnums.hxx>
#include <utilities/idd/OS_Chiller_Absorption_FieldEnums.hxx>
#include <utilities/idd/OS_CoolingTower_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_CoolingTower_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_CoolingTower_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_CoolingTowerPerformance_CoolTools_FieldEnums.hxx>
#include <utilities/idd/OS_CoolingTowerPerformance_YorkCalc_FieldEnums.hxx>
#include <utilities/idd/OS_DistrictCooling_FieldEnums.hxx>
#include <utilities/idd/OS_DistrictHeating_Water_FieldEnums.hxx>
#include <utilities/idd/OS_DistrictHeating_Steam_FieldEnums.hxx>
#include <utilities/idd/OS_GroundHeatExchanger_Vertical_FieldEnums.hxx>
#include <utilities/idd/OS_GroundHeatExchanger_HorizontalTrench_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_CooledBeam_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_FourPipeBeam_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_FourPipeBeam_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_CurveFit_Performance_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_CurveFit_OperatingMode_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_CurveFit_Speed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_TwoStageWithHumidityControlMode_FieldEnums.hxx>
#include <utilities/idd/OS_CoilPerformance_DX_Cooling_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_MultiSpeed_StageData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_CoilSystem_Cooling_Water_HeatExchangerAssisted_FieldEnums.hxx>
#include <utilities/idd/OS_CoilSystem_Cooling_DX_HeatExchangerAssisted_FieldEnums.hxx>
#include <utilities/idd/OS_CoilSystem_IntegratedHeatPump_AirSource_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_SingleSpeed_ThermalStorage_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_LowTemperatureRadiant_ConstantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_LowTemperatureRadiant_VariableFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_Water_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_WaterToAirHeatPump_EquationFit_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_VariableRefrigerantFlow_FluidTemperatureControl_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Electric_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Electric_MultiStage_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Electric_MultiStage_StageData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Gas_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Gas_MultiStage_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Gas_MultiStage_StageData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Desuperheater_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_WaterHeating_Desuperheater_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_LowTemperatureRadiant_ConstantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_LowTemperatureRadiant_VariableFlow_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Water_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Water_Baseboard_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_Water_Baseboard_Radiant_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_WaterToAirHeatPump_EquationFit_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_MultiSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_MultiSpeed_StageData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_DX_VariableSpeed_SpeedData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_DX_VariableSpeed_SpeedData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit_SpeedData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit_SpeedData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_Cooling_Water_Panel_Radiant_FieldEnums.hxx>
#include <utilities/idd/OS_Connection_FieldEnums.hxx>
#include <utilities/idd/OS_Connector_Mixer_FieldEnums.hxx>
#include <utilities/idd/OS_Connector_Splitter_FieldEnums.hxx>
#include <utilities/idd/OS_Controller_MechanicalVentilation_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneControl_ContaminantController_FieldEnums.hxx>
#include <utilities/idd/OS_Controller_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/OS_Controller_WaterCoil_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Linear_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_QuadLinear_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_QuintLinear_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Quadratic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Cubic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Quartic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Exponent_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Bicubic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Biquadratic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_QuadraticLinear_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Triquadratic_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Functional_PressureDrop_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_FanPressureRise_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_ExponentialSkewNormal_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_Sigmoid_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_RectangularHyperbola1_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_RectangularHyperbola2_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_ExponentialDecay_FieldEnums.hxx>
#include <utilities/idd/OS_Curve_DoubleExponentialDecay_FieldEnums.hxx>
#include <utilities/idd/OS_Table_MultiVariableLookup_FieldEnums.hxx>
#include <utilities/idd/OS_Table_IndependentVariable_FieldEnums.hxx>
#include <utilities/idd/OS_Table_Lookup_FieldEnums.hxx>
#include <utilities/idd/OS_DesignSpecification_OutdoorAir_FieldEnums.hxx>
#include <utilities/idd/OS_DesignSpecification_ZoneAirDistribution_FieldEnums.hxx>
#include <utilities/idd/OS_Humidifier_Steam_Electric_FieldEnums.hxx>
#include <utilities/idd/OS_Humidifier_Steam_Gas_FieldEnums.hxx>
#include <utilities/idd/OS_EvaporativeCooler_Indirect_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/OS_EvaporativeCooler_Direct_ResearchSpecial_FieldEnums.hxx>
#include <utilities/idd/OS_EvaporativeFluidCooler_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_EvaporativeFluidCooler_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_SystemModel_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_ConstantVolume_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_VariableVolume_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_OnOff_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_ComponentModel_FieldEnums.hxx>
#include <utilities/idd/OS_Fan_ZoneExhaust_FieldEnums.hxx>
#include <utilities/idd/OS_HeatExchanger_AirToAir_SensibleAndLatent_FieldEnums.hxx>
#include <utilities/idd/OS_HeatExchanger_Desiccant_BalancedFlow_FieldEnums.hxx>
#include <utilities/idd/OS_HeatExchanger_Desiccant_BalancedFlow_PerformanceDataType1_FieldEnums.hxx>
#include <utilities/idd/OS_HeatExchanger_FluidToFluid_FieldEnums.hxx>
#include <utilities/idd/OS_HVACComponentList_FieldEnums.hxx>
#include <utilities/idd/OS_Node_FieldEnums.hxx>
#include <utilities/idd/OS_PortList_FieldEnums.hxx>
#include <utilities/idd/OS_Pipe_Adiabatic_FieldEnums.hxx>
#include <utilities/idd/OS_PlantLoop_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_CoolingLoad_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_HeatingLoad_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorDryBulb_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorWetBulb_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorRelativeHumidity_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorDewpoint_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorDryBulbDifference_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorDewpointDifference_FieldEnums.hxx>
#include <utilities/idd/OS_PlantEquipmentOperation_OutdoorWetBulbDifference_FieldEnums.hxx>
#include <utilities/idd/OS_PlantComponent_TemperatureSource_FieldEnums.hxx>
#include <utilities/idd/OS_LoadProfile_Plant_FieldEnums.hxx>
#include <utilities/idd/OS_Pump_ConstantSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Pump_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_HeaderedPumps_ConstantSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_HeaderedPumps_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_TemperingValve_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_FollowOutdoorAirTemperature_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MixedAir_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_OutdoorAirReset_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_OutdoorAirPretreat_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_Reheat_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_Humidity_Minimum_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_MinimumHumidity_Average_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_Humidity_Minimum_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_Scheduled_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_Scheduled_DualSetpoint_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_Warmest_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_WarmestTemperatureFlow_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_Coldest_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_FollowGroundTemperature_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_FollowSystemNodeTemperature_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_Cooling_Average_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_Heating_Average_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_Humidity_Maximum_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_MultiZone_MaximumHumidity_Average_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_OneStageCooling_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_OneStageHeating_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_Humidity_Maximum_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_Cooling_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SingleZone_Heating_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SystemNodeReset_Temperature_FieldEnums.hxx>
#include <utilities/idd/OS_SetpointManager_SystemNodeReset_Humidity_FieldEnums.hxx>
#include <utilities/idd/OS_Sizing_Plant_FieldEnums.hxx>
#include <utilities/idd/OS_Sizing_System_FieldEnums.hxx>
#include <utilities/idd/OS_Sizing_Zone_FieldEnums.hxx>
#include <utilities/idd/OS_Splitter_FieldEnums.hxx>
#include <utilities/idd/OS_ThermalZone_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneControl_Humidistat_FieldEnums.hxx>
#include <utilities/idd/OS_ThermostatSetpoint_DualSetpoint_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneControl_Thermostat_StagedDualSetpoint_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_EquipmentList_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneVentilation_DesignFlowRate_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneVentilation_WindandStackOpenArea_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_Baseboard_Convective_Electric_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_Baseboard_Convective_Water_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_HighTemperatureRadiant_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_LowTemperatureRadiant_Electric_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_IdealLoadsAirSystem_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_FourPipeFanCoil_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_LowTemperatureRadiant_ConstantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_LowTemperatureRadiant_VariableFlow_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_PackagedTerminalHeatPump_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_PackagedTerminalAirConditioner_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_TerminalUnit_VariableRefrigerantFlow_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_WaterToAirHeatPump_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_UnitHeater_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_Dehumidifier_DX_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_EnergyRecoveryVentilator_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_EnergyRecoveryVentilator_Controller_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_UnitVentilator_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_Baseboard_RadiantConvective_Water_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_Baseboard_RadiantConvective_Electric_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_CoolingPanel_RadiantConvective_Water_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneHVAC_EvaporativeCoolerUnit_FieldEnums.hxx>
#include <utilities/idd/OS_ZoneMixing_FieldEnums.hxx>
#include <utilities/idd/OS_WaterHeater_Mixed_FieldEnums.hxx>
#include <utilities/idd/OS_WaterHeater_HeatPump_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_WaterHeating_AirToWaterHeatPump_FieldEnums.hxx>
#include <utilities/idd/OS_WaterHeater_HeatPump_WrappedCondenser_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed_SpeedData_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_WaterHeating_AirToWaterHeatPump_Wrapped_FieldEnums.hxx>
#include <utilities/idd/OS_WaterHeater_Stratified_FieldEnums.hxx>
#include <utilities/idd/OS_WaterHeater_Sizing_FieldEnums.hxx>
#include <utilities/idd/OS_WaterUse_Equipment_FieldEnums.hxx>
#include <utilities/idd/OS_WaterUse_Equipment_Definition_FieldEnums.hxx>
#include <utilities/idd/OS_WaterUse_Connections_FieldEnums.hxx>
#include <utilities/idd/OS_ThermalStorage_Ice_Detailed_FieldEnums.hxx>
#include <utilities/idd/OS_ThermalStorage_ChilledWater_Stratified_FieldEnums.hxx>
#include <utilities/idd/OS_Duct_FieldEnums.hxx>
#include <utilities/idd/OS_FluidCooler_SingleSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_FluidCooler_TwoSpeed_FieldEnums.hxx>
#include <utilities/idd/OS_Pipe_Indoor_FieldEnums.hxx>
#include <utilities/idd/OS_Pipe_Outdoor_FieldEnums.hxx>
#include <utilities/idd/OS_SwimmingPool_Indoor_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollectorPerformance_FlatPlate_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollector_FlatPlate_Water_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollectorPerformance_IntegralCollectorStorage_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollector_IntegralCollectorStorage_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollectorPerformance_PhotovoltaicThermal_Simple_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollectorPerformance_PhotovoltaicThermal_BIPVT_FieldEnums.hxx>
#include <utilities/idd/OS_SolarCollector_FlatPlate_PhotovoltaicThermal_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_MicroTurbine_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_MicroTurbine_HeatRecovery_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_Photovoltaic_FieldEnums.hxx>
#include <utilities/idd/OS_PhotovoltaicPerformance_Simple_FieldEnums.hxx>
#include <utilities/idd/OS_PhotovoltaicPerformance_EquivalentOneDiode_FieldEnums.hxx>
#include <utilities/idd/OS_PhotovoltaicPerformance_Sandia_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_PowerModule_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_AirSupply_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_WaterSupply_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_AuxiliaryHeater_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_ExhaustGasToWaterHeatExchanger_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_ElectricalStorage_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_Inverter_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelCell_StackCooler_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_FuelSupply_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_WindTurbine_FieldEnums.hxx>
#include <utilities/idd/OS_Generator_PVWatts_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Inverter_PVWatts_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Inverter_Simple_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Inverter_LookUpTable_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Storage_Simple_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Storage_LiIonNMCBattery_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Transformer_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Distribution_FieldEnums.hxx>
#include <utilities/idd/OS_ElectricLoadCenter_Storage_Converter_FieldEnums.hxx>
#include <utilities/idd/OS_ComponentCost_Adjustments_FieldEnums.hxx>
#include <utilities/idd/OS_LifeCycleCost_FieldEnums.hxx>
#include <utilities/idd/OS_CurrencyType_FieldEnums.hxx>
#include <utilities/idd/OS_LifeCycleCost_Parameters_FieldEnums.hxx>
#include <utilities/idd/OS_LifeCycleCost_UsePriceEscalation_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityBill_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Tariff_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Qualify_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Charge_Simple_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Charge_Block_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Ratchet_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_UtilityCost_Computation_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Schedules_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Constructions_FieldEnums.hxx>
#include <utilities/idd/OS_OutputControl_Files_FieldEnums.hxx>
#include <utilities/idd/OS_OutputControl_Timestamp_FieldEnums.hxx>
#include <utilities/idd/OS_OutputControl_ReportingTolerances_FieldEnums.hxx>
#include <utilities/idd/OS_OutputControl_ResilienceSummaries_FieldEnums.hxx>
#include <utilities/idd/OS_OutputControl_Table_Style_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Meter_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_Meter_Custom_FieldEnums.hxx>
#include <utilities/idd/OS_Meter_CustomDecrement_FieldEnums.hxx>
#include <utilities/idd/OS_Output_EnvironmentalImpactFactors_FieldEnums.hxx>
#include <utilities/idd/OS_EnvironmentalImpactFactors_FieldEnums.hxx>
#include <utilities/idd/OS_FuelFactors_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Diagnostics_FieldEnums.hxx>
#include <utilities/idd/OS_Output_DebuggingData_FieldEnums.hxx>
#include <utilities/idd/OS_Output_JSON_FieldEnums.hxx>
#include <utilities/idd/OS_Output_SQLite_FieldEnums.hxx>
#include <utilities/idd/OS_Output_EnergyManagementSystem_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Table_SummaryReports_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Table_Monthly_FieldEnums.hxx>
#include <utilities/idd/OS_Output_Table_Annual_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_Sensor_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_Actuator_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_ProgramCallingManager_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_Program_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_Subroutine_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_GlobalVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_OutputVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_MeteredOutputVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_TrendVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_InternalVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_CurveOrTableIndexVariable_FieldEnums.hxx>
#include <utilities/idd/OS_EnergyManagementSystem_ConstructionIndexVariable_FieldEnums.hxx>
#include <utilities/idd/OS_PythonPlugin_SearchPaths_FieldEnums.hxx>
#include <utilities/idd/OS_PythonPlugin_Instance_FieldEnums.hxx>
#include <utilities/idd/OS_PythonPlugin_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_PythonPlugin_TrendVariable_FieldEnums.hxx>
#include <utilities/idd/OS_PythonPlugin_OutputVariable_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkSimulationControl_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkZone_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkSurface_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkReferenceCrackConditions_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkCrack_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkEffectiveLeakageArea_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkSpecifiedFlowRate_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkDetailedOpening_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkSimpleOpening_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkHorizontalOpening_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkOutdoorAirflow_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkZoneExhaustFan_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkExternalNode_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkPressureController_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkDistributionNode_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkLeak_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkLeakageRatio_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkDuct_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkFan_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkEquivalentDuct_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkConstantPressureDrop_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkReliefAirFlow_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkDistributionLinkage_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkDuctViewFactors_FieldEnums.hxx>
#include <utilities/idd/OS_AirflowNetworkOccupantVentilationControl_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_Schedule_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_Actuator_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitImport_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitImport_From_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitImport_To_Schedule_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitImport_To_Actuator_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitImport_To_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitExport_From_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitExport_To_Schedule_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitExport_To_Actuator_FieldEnums.hxx>
#include <utilities/idd/OS_ExternalInterface_FunctionalMockupUnitExport_To_Variable_FieldEnums.hxx>
#include <utilities/idd/OS_Coil_UserDefined_FieldEnums.hxx>
#include <utilities/idd/OS_PlantComponent_UserDefined_FieldEnums.hxx>

#endif // UTILITIES_IDD_IDDFIELDENUMS_HXX
