/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_INSULATION_FIELDENUMS_HXX
#define UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_INSULATION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GroundHeatTransfer_Basement_InsulationFields
 *  \brief Enumeration of GroundHeatTransfer:Basement:Insulation's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GroundHeatTransfer_Basement_InsulationFields, )
#else
class GroundHeatTransfer_Basement_InsulationFields: public ::EnumBase<GroundHeatTransfer_Basement_InsulationFields> {
 public: 
  enum domain 
  {
REXT_RValueofanyexteriorinsulation, INSFULL_Flag_Isthewallfullyinsulated,   };
  GroundHeatTransfer_Basement_InsulationFields()
   : EnumBase<GroundHeatTransfer_Basement_InsulationFields>(REXT_RValueofanyexteriorinsulation) {} 
  GroundHeatTransfer_Basement_InsulationFields(const std::string &t_name) 
   : EnumBase<GroundHeatTransfer_Basement_InsulationFields>(t_name) {} 
  GroundHeatTransfer_Basement_InsulationFields(int t_value) 
   : EnumBase<GroundHeatTransfer_Basement_InsulationFields>(t_value) {} 
  static std::string enumName() 
  { return "GroundHeatTransfer_Basement_InsulationFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GroundHeatTransfer_Basement_InsulationFields>::integer_value()); }
   private:
    friend class EnumBase<GroundHeatTransfer_Basement_InsulationFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GroundHeatTransfer_Basement_InsulationFields::REXT_RValueofanyexteriorinsulation, "REXT_RValueofanyexteriorinsulation", "REXT: R Value of any exterior insulation"},
{ GroundHeatTransfer_Basement_InsulationFields::INSFULL_Flag_Isthewallfullyinsulated, "INSFULL_Flag_Isthewallfullyinsulated", "INSFULL: Flag: Is the wall fully insulated?"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GroundHeatTransfer_Basement_InsulationFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GroundHeatTransfer_Basement_InsulationFields> OptionalGroundHeatTransfer_Basement_InsulationFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_INSULATION_FIELDENUMS_HXX
