/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_HeatPump_AirToWater_FuelFired_HeatingFields
 *  \brief Enumeration of OS:HeatPump:AirToWater:FuelFired:Heating's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_HeatPump_AirToWater_FuelFired_HeatingFields, )
#else
class OS_HeatPump_AirToWater_FuelFired_HeatingFields: public ::EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields> {
 public: 
  enum domain 
  {
Handle, Name, WaterInletNodeName, WaterOutletNodeName, AirSourceNodeName, CompanionCoolingHeatPumpName, FuelType, EndUseSubcategory, NominalHeatingCapacity, NominalCOP, DesignFlowRate, DesignSupplyTemperature, DesignTemperatureLift, SizingFactor, FlowMode, OutdoorAirTemperatureCurveInputVariable, WaterTemperatureCurveInputVariable, NormalizedCapacityFunctionofTemperatureCurveName, FuelEnergyInputRatioFunctionofTemperatureCurveName, FuelEnergyInputRatioFunctionofPLRCurveName, MinimumPartLoadRatio, MaximumPartLoadRatio, DefrostControlType, DefrostOperationTimeFraction, FuelEnergyInputRatioDefrostAdjustmentCurveName, ResistiveDefrostHeaterCapacity, MaximumOutdoorDrybulbTemperatureforDefrostOperation, CyclingRatioFactorCurveName, NominalAuxiliaryElectricPower, AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName, AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName, StandbyElectricPower,   };
  OS_HeatPump_AirToWater_FuelFired_HeatingFields()
   : EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields>(Handle) {} 
  OS_HeatPump_AirToWater_FuelFired_HeatingFields(const std::string &t_name) 
   : EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields>(t_name) {} 
  OS_HeatPump_AirToWater_FuelFired_HeatingFields(int t_value) 
   : EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_HeatPump_AirToWater_FuelFired_HeatingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields>::integer_value()); }
   private:
    friend class EnumBase<OS_HeatPump_AirToWater_FuelFired_HeatingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::Handle, "Handle", "Handle"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::Name, "Name", "Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::WaterInletNodeName, "WaterInletNodeName", "Water Inlet Node Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::WaterOutletNodeName, "WaterOutletNodeName", "Water Outlet Node Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::AirSourceNodeName, "AirSourceNodeName", "Air Source Node Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::CompanionCoolingHeatPumpName, "CompanionCoolingHeatPumpName", "Companion Cooling Heat Pump Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::FuelType, "FuelType", "Fuel Type"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::NominalHeatingCapacity, "NominalHeatingCapacity", "Nominal Heating Capacity"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::NominalCOP, "NominalCOP", "Nominal COP"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::DesignFlowRate, "DesignFlowRate", "Design Flow Rate"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::DesignSupplyTemperature, "DesignSupplyTemperature", "Design Supply Temperature"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::DesignTemperatureLift, "DesignTemperatureLift", "Design Temperature Lift"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::SizingFactor, "SizingFactor", "Sizing Factor"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::FlowMode, "FlowMode", "Flow Mode"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::OutdoorAirTemperatureCurveInputVariable, "OutdoorAirTemperatureCurveInputVariable", "Outdoor Air Temperature Curve Input Variable"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::WaterTemperatureCurveInputVariable, "WaterTemperatureCurveInputVariable", "Water Temperature Curve Input Variable"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::NormalizedCapacityFunctionofTemperatureCurveName, "NormalizedCapacityFunctionofTemperatureCurveName", "Normalized Capacity Function of Temperature Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioFunctionofTemperatureCurveName, "FuelEnergyInputRatioFunctionofTemperatureCurveName", "Fuel Energy Input Ratio Function of Temperature Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioFunctionofPLRCurveName, "FuelEnergyInputRatioFunctionofPLRCurveName", "Fuel Energy Input Ratio Function of PLR Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::MinimumPartLoadRatio, "MinimumPartLoadRatio", "Minimum Part Load Ratio"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::MaximumPartLoadRatio, "MaximumPartLoadRatio", "Maximum Part Load Ratio"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::DefrostControlType, "DefrostControlType", "Defrost Control Type"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::DefrostOperationTimeFraction, "DefrostOperationTimeFraction", "Defrost Operation Time Fraction"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::FuelEnergyInputRatioDefrostAdjustmentCurveName, "FuelEnergyInputRatioDefrostAdjustmentCurveName", "Fuel Energy Input Ratio Defrost Adjustment Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::ResistiveDefrostHeaterCapacity, "ResistiveDefrostHeaterCapacity", "Resistive Defrost Heater Capacity"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::MaximumOutdoorDrybulbTemperatureforDefrostOperation, "MaximumOutdoorDrybulbTemperatureforDefrostOperation", "Maximum Outdoor Dry-bulb Temperature for Defrost Operation"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::CyclingRatioFactorCurveName, "CyclingRatioFactorCurveName", "Cycling Ratio Factor Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::NominalAuxiliaryElectricPower, "NominalAuxiliaryElectricPower", "Nominal Auxiliary Electric Power"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName, "AuxiliaryElectricEnergyInputRatioFunctionofTemperatureCurveName", "Auxiliary Electric Energy Input Ratio Function of Temperature Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName, "AuxiliaryElectricEnergyInputRatioFunctionofPLRCurveName", "Auxiliary Electric Energy Input Ratio Function of PLR Curve Name"},
{ OS_HeatPump_AirToWater_FuelFired_HeatingFields::StandbyElectricPower, "StandbyElectricPower", "Standby Electric Power"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_HeatPump_AirToWater_FuelFired_HeatingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_HeatPump_AirToWater_FuelFired_HeatingFields> OptionalOS_HeatPump_AirToWater_FuelFired_HeatingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FUELFIRED_HEATING_FIELDENUMS_HXX
