/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_PLANTEQUIPMENTOPERATION_UNCONTROLLED_FIELDENUMS_HXX
#define UTILITIES_IDD_PLANTEQUIPMENTOPERATION_UNCONTROLLED_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class PlantEquipmentOperation_UncontrolledFields
 *  \brief Enumeration of PlantEquipmentOperation:Uncontrolled's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(PlantEquipmentOperation_UncontrolledFields, )
#else
class PlantEquipmentOperation_UncontrolledFields: public ::EnumBase<PlantEquipmentOperation_UncontrolledFields> {
 public: 
  enum domain 
  {
Name, EquipmentListName,   };
  PlantEquipmentOperation_UncontrolledFields()
   : EnumBase<PlantEquipmentOperation_UncontrolledFields>(Name) {} 
  PlantEquipmentOperation_UncontrolledFields(const std::string &t_name) 
   : EnumBase<PlantEquipmentOperation_UncontrolledFields>(t_name) {} 
  PlantEquipmentOperation_UncontrolledFields(int t_value) 
   : EnumBase<PlantEquipmentOperation_UncontrolledFields>(t_value) {} 
  static std::string enumName() 
  { return "PlantEquipmentOperation_UncontrolledFields"; }
  domain value() const { return static_cast<domain>(EnumBase<PlantEquipmentOperation_UncontrolledFields>::integer_value()); }
   private:
    friend class EnumBase<PlantEquipmentOperation_UncontrolledFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ PlantEquipmentOperation_UncontrolledFields::Name, "Name", "Name"},
{ PlantEquipmentOperation_UncontrolledFields::EquipmentListName, "EquipmentListName", "Equipment List Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const PlantEquipmentOperation_UncontrolledFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<PlantEquipmentOperation_UncontrolledFields> OptionalPlantEquipmentOperation_UncontrolledFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_PLANTEQUIPMENTOPERATION_UNCONTROLLED_FIELDENUMS_HXX
