/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_UTILITYCOST_CHARGE_SIMPLE_FIELDENUMS_HXX
#define UTILITIES_IDD_UTILITYCOST_CHARGE_SIMPLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class UtilityCost_Charge_SimpleFields
 *  \brief Enumeration of UtilityCost:Charge:Simple's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(UtilityCost_Charge_SimpleFields, )
#else
class UtilityCost_Charge_SimpleFields: public ::EnumBase<UtilityCost_Charge_SimpleFields> {
 public: 
  enum domain 
  {
UtilityCostChargeSimpleName, TariffName, SourceVariable, Season, CategoryVariableName, CostperUnitValueorVariableName,   };
  UtilityCost_Charge_SimpleFields()
   : EnumBase<UtilityCost_Charge_SimpleFields>(UtilityCostChargeSimpleName) {} 
  UtilityCost_Charge_SimpleFields(const std::string &t_name) 
   : EnumBase<UtilityCost_Charge_SimpleFields>(t_name) {} 
  UtilityCost_Charge_SimpleFields(int t_value) 
   : EnumBase<UtilityCost_Charge_SimpleFields>(t_value) {} 
  static std::string enumName() 
  { return "UtilityCost_Charge_SimpleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<UtilityCost_Charge_SimpleFields>::integer_value()); }
   private:
    friend class EnumBase<UtilityCost_Charge_SimpleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ UtilityCost_Charge_SimpleFields::UtilityCostChargeSimpleName, "UtilityCostChargeSimpleName", "Utility Cost Charge Simple Name"},
{ UtilityCost_Charge_SimpleFields::TariffName, "TariffName", "Tariff Name"},
{ UtilityCost_Charge_SimpleFields::SourceVariable, "SourceVariable", "Source Variable"},
{ UtilityCost_Charge_SimpleFields::Season, "Season", "Season"},
{ UtilityCost_Charge_SimpleFields::CategoryVariableName, "CategoryVariableName", "Category Variable Name"},
{ UtilityCost_Charge_SimpleFields::CostperUnitValueorVariableName, "CostperUnitValueorVariableName", "Cost per Unit Value or Variable Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const UtilityCost_Charge_SimpleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<UtilityCost_Charge_SimpleFields> OptionalUtilityCost_Charge_SimpleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_UTILITYCOST_CHARGE_SIMPLE_FIELDENUMS_HXX
