/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ZONECONTAMINANTSOURCEANDSINK_CARBONDIOXIDE_FIELDENUMS_HXX
#define UTILITIES_IDD_ZONECONTAMINANTSOURCEANDSINK_CARBONDIOXIDE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ZoneContaminantSourceAndSink_CarbonDioxideFields
 *  \brief Enumeration of ZoneContaminantSourceAndSink:CarbonDioxide's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ZoneContaminantSourceAndSink_CarbonDioxideFields, )
#else
class ZoneContaminantSourceAndSink_CarbonDioxideFields: public ::EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields> {
 public: 
  enum domain 
  {
Name, ZoneName, DesignGenerationRate, ScheduleName,   };
  ZoneContaminantSourceAndSink_CarbonDioxideFields()
   : EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields>(Name) {} 
  ZoneContaminantSourceAndSink_CarbonDioxideFields(const std::string &t_name) 
   : EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields>(t_name) {} 
  ZoneContaminantSourceAndSink_CarbonDioxideFields(int t_value) 
   : EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields>(t_value) {} 
  static std::string enumName() 
  { return "ZoneContaminantSourceAndSink_CarbonDioxideFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields>::integer_value()); }
   private:
    friend class EnumBase<ZoneContaminantSourceAndSink_CarbonDioxideFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ZoneContaminantSourceAndSink_CarbonDioxideFields::Name, "Name", "Name"},
{ ZoneContaminantSourceAndSink_CarbonDioxideFields::ZoneName, "ZoneName", "Zone Name"},
{ ZoneContaminantSourceAndSink_CarbonDioxideFields::DesignGenerationRate, "DesignGenerationRate", "Design Generation Rate"},
{ ZoneContaminantSourceAndSink_CarbonDioxideFields::ScheduleName, "ScheduleName", "Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ZoneContaminantSourceAndSink_CarbonDioxideFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ZoneContaminantSourceAndSink_CarbonDioxideFields> OptionalZoneContaminantSourceAndSink_CarbonDioxideFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ZONECONTAMINANTSOURCEANDSINK_CARBONDIOXIDE_FIELDENUMS_HXX
