/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GLAZEDDOOR_FIELDENUMS_HXX
#define UTILITIES_IDD_GLAZEDDOOR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GlazedDoorFields
 *  \brief Enumeration of GlazedDoor's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GlazedDoorFields, )
#else
class GlazedDoorFields: public ::EnumBase<GlazedDoorFields> {
 public: 
  enum domain 
  {
Name, ConstructionName, BuildingSurfaceName, FrameandDividerName, Multiplier, StartingXCoordinate, StartingZCoordinate, Length, Height,   };
  GlazedDoorFields()
   : EnumBase<GlazedDoorFields>(Name) {} 
  GlazedDoorFields(const std::string &t_name) 
   : EnumBase<GlazedDoorFields>(t_name) {} 
  GlazedDoorFields(int t_value) 
   : EnumBase<GlazedDoorFields>(t_value) {} 
  static std::string enumName() 
  { return "GlazedDoorFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GlazedDoorFields>::integer_value()); }
   private:
    friend class EnumBase<GlazedDoorFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GlazedDoorFields::Name, "Name", "Name"},
{ GlazedDoorFields::ConstructionName, "ConstructionName", "Construction Name"},
{ GlazedDoorFields::BuildingSurfaceName, "BuildingSurfaceName", "Building Surface Name"},
{ GlazedDoorFields::FrameandDividerName, "FrameandDividerName", "Frame and Divider Name"},
{ GlazedDoorFields::Multiplier, "Multiplier", "Multiplier"},
{ GlazedDoorFields::StartingXCoordinate, "StartingXCoordinate", "Starting X Coordinate"},
{ GlazedDoorFields::StartingZCoordinate, "StartingZCoordinate", "Starting Z Coordinate"},
{ GlazedDoorFields::Length, "Length", "Length"},
{ GlazedDoorFields::Height, "Height", "Height"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GlazedDoorFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GlazedDoorFields> OptionalGlazedDoorFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GLAZEDDOOR_FIELDENUMS_HXX
