/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SURFACEPROPERTY_OTHERSIDECONDITIONSMODEL_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SURFACEPROPERTY_OTHERSIDECONDITIONSMODEL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SurfaceProperty_OtherSideConditionsModelFields
 *  \brief Enumeration of OS:SurfaceProperty:OtherSideConditionsModel's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SurfaceProperty_OtherSideConditionsModelFields, )
#else
class OS_SurfaceProperty_OtherSideConditionsModelFields: public ::EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields> {
 public: 
  enum domain 
  {
Handle, Name, TypeofModeling,   };
  OS_SurfaceProperty_OtherSideConditionsModelFields()
   : EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields>(Handle) {} 
  OS_SurfaceProperty_OtherSideConditionsModelFields(const std::string &t_name) 
   : EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields>(t_name) {} 
  OS_SurfaceProperty_OtherSideConditionsModelFields(int t_value) 
   : EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SurfaceProperty_OtherSideConditionsModelFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SurfaceProperty_OtherSideConditionsModelFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SurfaceProperty_OtherSideConditionsModelFields::Handle, "Handle", "Handle"},
{ OS_SurfaceProperty_OtherSideConditionsModelFields::Name, "Name", "Name"},
{ OS_SurfaceProperty_OtherSideConditionsModelFields::TypeofModeling, "TypeofModeling", "Type of Modeling"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SurfaceProperty_OtherSideConditionsModelFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SurfaceProperty_OtherSideConditionsModelFields> OptionalOS_SurfaceProperty_OtherSideConditionsModelFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SURFACEPROPERTY_OTHERSIDECONDITIONSMODEL_FIELDENUMS_HXX
