/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OUTPUT_TABLE_REPORTPERIOD_FIELDENUMS_HXX
#define UTILITIES_IDD_OUTPUT_TABLE_REPORTPERIOD_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Output_Table_ReportPeriodFields
 *  \brief Enumeration of Output:Table:ReportPeriod's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Output_Table_ReportPeriodFields, )
#else
class Output_Table_ReportPeriodFields: public ::EnumBase<Output_Table_ReportPeriodFields> {
 public: 
  enum domain 
  {
Name, ReportName, BeginYear, BeginMonth, BeginDayofMonth, BeginHourofDay, EndYear, EndMonth, EndDayofMonth, EndHourofDay,   };
  Output_Table_ReportPeriodFields()
   : EnumBase<Output_Table_ReportPeriodFields>(Name) {} 
  Output_Table_ReportPeriodFields(const std::string &t_name) 
   : EnumBase<Output_Table_ReportPeriodFields>(t_name) {} 
  Output_Table_ReportPeriodFields(int t_value) 
   : EnumBase<Output_Table_ReportPeriodFields>(t_value) {} 
  static std::string enumName() 
  { return "Output_Table_ReportPeriodFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Output_Table_ReportPeriodFields>::integer_value()); }
   private:
    friend class EnumBase<Output_Table_ReportPeriodFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Output_Table_ReportPeriodFields::Name, "Name", "Name"},
{ Output_Table_ReportPeriodFields::ReportName, "ReportName", "Report Name"},
{ Output_Table_ReportPeriodFields::BeginYear, "BeginYear", "Begin Year"},
{ Output_Table_ReportPeriodFields::BeginMonth, "BeginMonth", "Begin Month"},
{ Output_Table_ReportPeriodFields::BeginDayofMonth, "BeginDayofMonth", "Begin Day of Month"},
{ Output_Table_ReportPeriodFields::BeginHourofDay, "BeginHourofDay", "Begin Hour of Day"},
{ Output_Table_ReportPeriodFields::EndYear, "EndYear", "End Year"},
{ Output_Table_ReportPeriodFields::EndMonth, "EndMonth", "End Month"},
{ Output_Table_ReportPeriodFields::EndDayofMonth, "EndDayofMonth", "End Day of Month"},
{ Output_Table_ReportPeriodFields::EndHourofDay, "EndHourofDay", "End Hour of Day"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Output_Table_ReportPeriodFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Output_Table_ReportPeriodFields> OptionalOutput_Table_ReportPeriodFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OUTPUT_TABLE_REPORTPERIOD_FIELDENUMS_HXX
