/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_IDDENUMS_HXX
#define UTILITIES_IDD_IDDENUMS_HXX

#include <utilities/core/Enum.hpp>

#include <boost/optional.hpp>

#include <vector>
#include <set>

namespace openstudio {

/** \class IddFileType */
  enum IddFileType::domain : int
  {
UserCustom, WholeFactory, EnergyPlus, OpenStudio,   };

/** \class IddObjectType */
  enum IddObjectType::domain : int
  {
Catchall, UserCustom, LeadInput, EndLeadInput, SimulationData, EndSimulationData, Version, SimulationControl, PerformancePrecisionTradeoffs, Building, ShadowCalculation, SurfaceConvectionAlgorithm_Inside, SurfaceConvectionAlgorithm_Outside, HeatBalanceAlgorithm, HeatBalanceSettings_ConductionFiniteDifference, ZoneAirHeatBalanceAlgorithm, ZoneAirContaminantBalance, ZoneAirMassFlowConservation, ZoneCapacitanceMultiplier_ResearchSpecial, Timestep, ConvergenceLimits, HVACSystemRootFindingAlgorithm, Compliance_Building, Site_Location, Site_VariableLocation, SizingPeriod_DesignDay, SizingPeriod_WeatherFileDays, SizingPeriod_WeatherFileConditionType, RunPeriod, RunPeriodControl_SpecialDays, RunPeriodControl_DaylightSavingTime, WeatherProperty_SkyTemperature, Site_WeatherStation, Site_HeightVariation, Site_GroundTemperature_BuildingSurface, Site_GroundTemperature_FCfactorMethod, Site_GroundTemperature_Shallow, Site_GroundTemperature_Deep, Site_GroundTemperature_Undisturbed_FiniteDifference, Site_GroundTemperature_Undisturbed_KusudaAchenbach, Site_GroundTemperature_Undisturbed_Xing, Site_GroundDomain_Slab, Site_GroundDomain_Basement, Site_GroundReflectance, Site_GroundReflectance_SnowModifier, Site_WaterMainsTemperature, Site_Precipitation, RoofIrrigation, Site_SolarAndVisibleSpectrum, Site_SpectrumData, ScheduleTypeLimits, Schedule_Day_Hourly, Schedule_Day_Interval, Schedule_Day_List, Schedule_Week_Daily, Schedule_Week_Compact, Schedule_Year, Schedule_Compact, Schedule_Constant, Schedule_File_Shading, Schedule_File, Material, Material_NoMass, Material_InfraredTransparent, Material_AirGap, Material_RoofVegetation, WindowMaterial_SimpleGlazingSystem, WindowMaterial_Glazing, WindowMaterial_GlazingGroup_Thermochromic, WindowMaterial_Glazing_RefractionExtinctionMethod, WindowMaterial_Gas, WindowGap_SupportPillar, WindowGap_DeflectionState, WindowMaterial_GasMixture, WindowMaterial_Gap, WindowMaterial_Shade, WindowMaterial_ComplexShade, WindowMaterial_Blind, WindowMaterial_Screen, WindowMaterial_Shade_EquivalentLayer, WindowMaterial_Drape_EquivalentLayer, WindowMaterial_Blind_EquivalentLayer, WindowMaterial_Screen_EquivalentLayer, WindowMaterial_Glazing_EquivalentLayer, WindowMaterial_Gap_EquivalentLayer, MaterialProperty_MoisturePenetrationDepth_Settings, MaterialProperty_PhaseChange, MaterialProperty_PhaseChangeHysteresis, MaterialProperty_VariableThermalConductivity, MaterialProperty_VariableAbsorptance, MaterialProperty_HeatAndMoistureTransfer_Settings, MaterialProperty_HeatAndMoistureTransfer_SorptionIsotherm, MaterialProperty_HeatAndMoistureTransfer_Suction, MaterialProperty_HeatAndMoistureTransfer_Redistribution, MaterialProperty_HeatAndMoistureTransfer_Diffusion, MaterialProperty_HeatAndMoistureTransfer_ThermalConductivity, MaterialProperty_GlazingSpectralData, Construction, Construction_CfactorUndergroundWall, Construction_FfactorGroundFloor, ConstructionProperty_InternalHeatSource, Construction_AirBoundary, WindowThermalModel_Params, WindowsCalculationEngine, Construction_ComplexFenestrationState, Construction_WindowEquivalentLayer, Construction_WindowDataFile, GlobalGeometryRules, GeometryTransform, Space, SpaceList, Zone, ZoneList, ZoneGroup, BuildingSurface_Detailed, Wall_Detailed, RoofCeiling_Detailed, Floor_Detailed, Wall_Exterior, Wall_Adiabatic, Wall_Underground, Wall_Interzone, Roof, Ceiling_Adiabatic, Ceiling_Interzone, Floor_GroundContact, Floor_Adiabatic, Floor_Interzone, FenestrationSurface_Detailed, Window, Door, GlazedDoor, Window_Interzone, Door_Interzone, GlazedDoor_Interzone, WindowShadingControl, WindowProperty_FrameAndDivider, WindowProperty_AirflowControl, WindowProperty_StormWindow, InternalMass, Shading_Site, Shading_Building, Shading_Site_Detailed, Shading_Building_Detailed, Shading_Overhang, Shading_Overhang_Projection, Shading_Fin, Shading_Fin_Projection, Shading_Zone_Detailed, ShadingProperty_Reflectance, SurfaceProperty_HeatTransferAlgorithm, SurfaceProperty_HeatTransferAlgorithm_MultipleSurface, SurfaceProperty_HeatTransferAlgorithm_SurfaceList, SurfaceProperty_HeatTransferAlgorithm_Construction, SurfaceProperty_HeatBalanceSourceTerm, SurfaceControl_MovableInsulation, SurfaceProperty_OtherSideCoefficients, SurfaceProperty_OtherSideConditionsModel, SurfaceProperty_Underwater, Foundation_Kiva, Foundation_Kiva_Settings, SurfaceProperty_ExposedFoundationPerimeter, SurfaceConvectionAlgorithm_Inside_AdaptiveModelSelections, SurfaceConvectionAlgorithm_Outside_AdaptiveModelSelections, SurfaceConvectionAlgorithm_Inside_UserCurve, SurfaceConvectionAlgorithm_Outside_UserCurve, SurfaceProperty_ConvectionCoefficients, SurfaceProperty_ConvectionCoefficients_MultipleSurface, SurfaceProperties_VaporCoefficients, SurfaceProperty_ExteriorNaturalVentedCavity, SurfaceProperty_SolarIncidentInside, SurfaceProperty_IncidentSolarMultiplier, SurfaceProperty_LocalEnvironment, ZoneProperty_LocalEnvironment, SurfaceProperty_SurroundingSurfaces, SurfaceProperty_GroundSurfaces, ComplexFenestrationProperty_SolarAbsorbedLayers, ZoneProperty_UserViewFactors_BySurfaceName, GroundHeatTransfer_Control, GroundHeatTransfer_Slab_Materials, GroundHeatTransfer_Slab_MatlProps, GroundHeatTransfer_Slab_BoundConds, GroundHeatTransfer_Slab_BldgProps, GroundHeatTransfer_Slab_Insulation, GroundHeatTransfer_Slab_EquivalentSlab, GroundHeatTransfer_Slab_AutoGrid, GroundHeatTransfer_Slab_ManualGrid, GroundHeatTransfer_Slab_XFACE, GroundHeatTransfer_Slab_YFACE, GroundHeatTransfer_Slab_ZFACE, GroundHeatTransfer_Basement_SimParameters, GroundHeatTransfer_Basement_MatlProps, GroundHeatTransfer_Basement_Insulation, GroundHeatTransfer_Basement_SurfaceProps, GroundHeatTransfer_Basement_BldgData, GroundHeatTransfer_Basement_Interior, GroundHeatTransfer_Basement_ComBldg, GroundHeatTransfer_Basement_EquivSlab, GroundHeatTransfer_Basement_EquivAutoGrid, GroundHeatTransfer_Basement_AutoGrid, GroundHeatTransfer_Basement_ManualGrid, GroundHeatTransfer_Basement_XFACE, GroundHeatTransfer_Basement_YFACE, GroundHeatTransfer_Basement_ZFACE, RoomAirModelType, RoomAir_TemperaturePattern_UserDefined, RoomAir_TemperaturePattern_ConstantGradient, RoomAir_TemperaturePattern_TwoGradient, RoomAir_TemperaturePattern_NondimensionalHeight, RoomAir_TemperaturePattern_SurfaceMapping, RoomAir_Node, RoomAirSettings_OneNodeDisplacementVentilation, RoomAirSettings_ThreeNodeDisplacementVentilation, RoomAirSettings_CrossVentilation, RoomAirSettings_UnderFloorAirDistributionInterior, RoomAirSettings_UnderFloorAirDistributionExterior, RoomAir_Node_AirflowNetwork, RoomAir_Node_AirflowNetwork_AdjacentSurfaceList, RoomAir_Node_AirflowNetwork_InternalGains, RoomAir_Node_AirflowNetwork_HVACEquipment, RoomAirSettings_AirflowNetwork, People, ComfortViewFactorAngles, Lights, ElectricEquipment, GasEquipment, HotWaterEquipment, SteamEquipment, OtherEquipment, IndoorLivingWall, ElectricEquipment_ITE_AirCooled, ZoneBaseboard_OutdoorTemperatureControlled, SwimmingPool_Indoor, ZoneContaminantSourceAndSink_CarbonDioxide, ZoneContaminantSourceAndSink_Generic_Constant, SurfaceContaminantSourceAndSink_Generic_PressureDriven, ZoneContaminantSourceAndSink_Generic_CutoffModel, ZoneContaminantSourceAndSink_Generic_DecaySource, SurfaceContaminantSourceAndSink_Generic_BoundaryLayerDiffusion, SurfaceContaminantSourceAndSink_Generic_DepositionVelocitySink, ZoneContaminantSourceAndSink_Generic_DepositionRateSink, Daylighting_Controls, Daylighting_ReferencePoint, Daylighting_DELight_ComplexFenestration, DaylightingDevice_Tubular, DaylightingDevice_Shelf, DaylightingDevice_LightWell, Output_DaylightFactors, Output_IlluminanceMap, OutputControl_IlluminanceMap_Style, ZoneInfiltration_DesignFlowRate, ZoneInfiltration_EffectiveLeakageArea, ZoneInfiltration_FlowCoefficient, ZoneVentilation_DesignFlowRate, ZoneVentilation_WindandStackOpenArea, ZoneAirBalance_OutdoorAir, ZoneMixing, ZoneCrossMixing, ZoneRefrigerationDoorMixing, ZoneEarthtube, ZoneEarthtube_Parameters, ZoneCoolTower_Shower, ZoneThermalChimney, AirflowNetwork_SimulationControl, AirflowNetwork_MultiZone_Zone, AirflowNetwork_MultiZone_Surface, AirflowNetwork_MultiZone_ReferenceCrackConditions, AirflowNetwork_MultiZone_Surface_Crack, AirflowNetwork_MultiZone_Surface_EffectiveLeakageArea, AirflowNetwork_MultiZone_SpecifiedFlowRate, AirflowNetwork_MultiZone_Component_DetailedOpening, AirflowNetwork_MultiZone_Component_SimpleOpening, AirflowNetwork_MultiZone_Component_HorizontalOpening, AirflowNetwork_MultiZone_Component_ZoneExhaustFan, AirflowNetwork_MultiZone_ExternalNode, AirflowNetwork_MultiZone_WindPressureCoefficientArray, AirflowNetwork_MultiZone_WindPressureCoefficientValues, AirflowNetwork_ZoneControl_PressureController, AirflowNetwork_Distribution_Node, AirflowNetwork_Distribution_Component_Leak, AirflowNetwork_Distribution_Component_LeakageRatio, AirflowNetwork_Distribution_Component_Duct, AirflowNetwork_Distribution_Component_Fan, AirflowNetwork_Distribution_Component_Coil, AirflowNetwork_Distribution_Component_HeatExchanger, AirflowNetwork_Distribution_Component_TerminalUnit, AirflowNetwork_Distribution_Component_ConstantPressureDrop, AirflowNetwork_Distribution_Component_OutdoorAirFlow, AirflowNetwork_Distribution_Component_ReliefAirFlow, AirflowNetwork_Distribution_Linkage, AirflowNetwork_Distribution_DuctViewFactors, AirflowNetwork_Distribution_DuctSizing, AirflowNetwork_OccupantVentilationControl, AirflowNetwork_IntraZone_Node, AirflowNetwork_IntraZone_Linkage, Duct_Loss_Conduction, Duct_Loss_Leakage, Duct_Loss_MakeupAir, Exterior_Lights, Exterior_FuelEquipment, Exterior_WaterEquipment, HVACTemplate_Thermostat, HVACTemplate_Zone_IdealLoadsAirSystem, HVACTemplate_Zone_BaseboardHeat, HVACTemplate_Zone_FanCoil, HVACTemplate_Zone_PTAC, HVACTemplate_Zone_PTHP, HVACTemplate_Zone_WaterToAirHeatPump, HVACTemplate_Zone_VRF, HVACTemplate_Zone_Unitary, HVACTemplate_Zone_VAV, HVACTemplate_Zone_VAV_FanPowered, HVACTemplate_Zone_VAV_HeatAndCool, HVACTemplate_Zone_ConstantVolume, HVACTemplate_Zone_DualDuct, HVACTemplate_System_VRF, HVACTemplate_System_Unitary, HVACTemplate_System_UnitaryHeatPump_AirToAir, HVACTemplate_System_UnitarySystem, HVACTemplate_System_VAV, HVACTemplate_System_PackagedVAV, HVACTemplate_System_ConstantVolume, HVACTemplate_System_DualDuct, HVACTemplate_System_DedicatedOutdoorAir, HVACTemplate_Plant_ChilledWaterLoop, HVACTemplate_Plant_Chiller, HVACTemplate_Plant_Chiller_ObjectReference, HVACTemplate_Plant_Tower, HVACTemplate_Plant_Tower_ObjectReference, HVACTemplate_Plant_HotWaterLoop, HVACTemplate_Plant_Boiler, HVACTemplate_Plant_Boiler_ObjectReference, HVACTemplate_Plant_MixedWaterLoop, DesignSpecification_OutdoorAir, DesignSpecification_OutdoorAir_SpaceList, DesignSpecification_ZoneAirDistribution, Sizing_Parameters, Sizing_Zone, DesignSpecification_ZoneHVAC_Sizing, DesignSpecification_AirTerminal_Sizing, Sizing_System, Sizing_Plant, OutputControl_Sizing_Style, ZoneControl_Humidistat, ZoneControl_Thermostat, ZoneControl_Thermostat_OperativeTemperature, ZoneControl_Thermostat_ThermalComfort, ZoneControl_Thermostat_TemperatureAndHumidity, ThermostatSetpoint_SingleHeating, ThermostatSetpoint_SingleCooling, ThermostatSetpoint_SingleHeatingOrCooling, ThermostatSetpoint_DualSetpoint, ThermostatSetpoint_ThermalComfort_Fanger_SingleHeating, ThermostatSetpoint_ThermalComfort_Fanger_SingleCooling, ThermostatSetpoint_ThermalComfort_Fanger_SingleHeatingOrCooling, ThermostatSetpoint_ThermalComfort_Fanger_DualSetpoint, ZoneControl_Thermostat_StagedDualSetpoint, ZoneControl_ContaminantController, ZoneHVAC_IdealLoadsAirSystem, ZoneHVAC_FourPipeFanCoil, ZoneHVAC_WindowAirConditioner, ZoneHVAC_PackagedTerminalAirConditioner, ZoneHVAC_PackagedTerminalHeatPump, ZoneHVAC_WaterToAirHeatPump, ZoneHVAC_Dehumidifier_DX, ZoneHVAC_EnergyRecoveryVentilator, ZoneHVAC_EnergyRecoveryVentilator_Controller, ZoneHVAC_UnitVentilator, ZoneHVAC_UnitHeater, ZoneHVAC_EvaporativeCoolerUnit, ZoneHVAC_HybridUnitaryHVAC, ZoneHVAC_OutdoorAirUnit, ZoneHVAC_OutdoorAirUnit_EquipmentList, ZoneHVAC_TerminalUnit_VariableRefrigerantFlow, ZoneHVAC_Baseboard_RadiantConvective_Water_Design, ZoneHVAC_Baseboard_RadiantConvective_Water, ZoneHVAC_Baseboard_RadiantConvective_Steam_Design, ZoneHVAC_Baseboard_RadiantConvective_Steam, ZoneHVAC_Baseboard_RadiantConvective_Electric, ZoneHVAC_CoolingPanel_RadiantConvective_Water, ZoneHVAC_Baseboard_Convective_Water, ZoneHVAC_Baseboard_Convective_Electric, ZoneHVAC_LowTemperatureRadiant_VariableFlow, ZoneHVAC_LowTemperatureRadiant_VariableFlow_Design, ZoneHVAC_LowTemperatureRadiant_ConstantFlow, ZoneHVAC_LowTemperatureRadiant_ConstantFlow_Design, ZoneHVAC_LowTemperatureRadiant_Electric, ZoneHVAC_LowTemperatureRadiant_SurfaceGroup, ZoneHVAC_HighTemperatureRadiant, ZoneHVAC_VentilatedSlab, ZoneHVAC_VentilatedSlab_SlabGroup, AirTerminal_SingleDuct_ConstantVolume_Reheat, AirTerminal_SingleDuct_ConstantVolume_NoReheat, AirTerminal_SingleDuct_VAV_NoReheat, AirTerminal_SingleDuct_VAV_Reheat, AirTerminal_SingleDuct_VAV_Reheat_VariableSpeedFan, AirTerminal_SingleDuct_VAV_HeatAndCool_NoReheat, AirTerminal_SingleDuct_VAV_HeatAndCool_Reheat, AirTerminal_SingleDuct_SeriesPIU_Reheat, AirTerminal_SingleDuct_ParallelPIU_Reheat, AirTerminal_SingleDuct_ConstantVolume_FourPipeInduction, AirTerminal_SingleDuct_ConstantVolume_FourPipeBeam, AirTerminal_SingleDuct_ConstantVolume_CooledBeam, AirTerminal_SingleDuct_Mixer, AirTerminal_DualDuct_ConstantVolume, AirTerminal_DualDuct_VAV, AirTerminal_DualDuct_VAV_OutdoorAir, ZoneHVAC_AirDistributionUnit, ZoneHVAC_ExhaustControl, ZoneHVAC_EquipmentList, ZoneHVAC_EquipmentConnections, SpaceHVAC_EquipmentConnections, SpaceHVAC_ZoneEquipmentSplitter, SpaceHVAC_ZoneEquipmentMixer, SpaceHVAC_ZoneReturnMixer, Fan_SystemModel, Fan_ConstantVolume, Fan_VariableVolume, Fan_OnOff, Fan_ZoneExhaust, FanPerformance_NightVentilation, Fan_ComponentModel, Coil_Cooling_Water, Coil_Cooling_Water_DetailedGeometry, CoilSystem_Cooling_Water, Coil_Cooling_DX, Coil_Cooling_DX_CurveFit_Performance, Coil_Cooling_DX_CurveFit_OperatingMode, Coil_Cooling_DX_CurveFit_Speed, Coil_DX_ASHRAE205_Performance, Coil_Cooling_DX_SingleSpeed, Coil_Cooling_DX_TwoSpeed, Coil_Cooling_DX_MultiSpeed, Coil_Cooling_DX_VariableSpeed, Coil_Cooling_DX_TwoStageWithHumidityControlMode, CoilPerformance_DX_Cooling, Coil_Cooling_DX_VariableRefrigerantFlow, Coil_Heating_DX_VariableRefrigerantFlow, Coil_Cooling_DX_VariableRefrigerantFlow_FluidTemperatureControl, Coil_Heating_DX_VariableRefrigerantFlow_FluidTemperatureControl, Coil_Heating_Water, Coil_Heating_Steam, Coil_Heating_Electric, Coil_Heating_Electric_MultiStage, Coil_Heating_Fuel, Coil_Heating_Gas_MultiStage, Coil_Heating_Desuperheater, Coil_Heating_DX_SingleSpeed, Coil_Heating_DX_MultiSpeed, Coil_Heating_DX_VariableSpeed, Coil_Cooling_WaterToAirHeatPump_ParameterEstimation, Coil_Heating_WaterToAirHeatPump_ParameterEstimation, Coil_Cooling_WaterToAirHeatPump_EquationFit, Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit, Coil_Heating_WaterToAirHeatPump_EquationFit, Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit, Coil_WaterHeating_AirToWaterHeatPump_Pumped, Coil_WaterHeating_AirToWaterHeatPump_Wrapped, Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed, Coil_WaterHeating_Desuperheater, CoilSystem_Cooling_DX, CoilSystem_Heating_DX, CoilSystem_Cooling_Water_HeatExchangerAssisted, CoilSystem_Cooling_DX_HeatExchangerAssisted, CoilSystem_IntegratedHeatPump_AirSource, Coil_Cooling_DX_SingleSpeed_ThermalStorage, EvaporativeCooler_Direct_CelDekPad, EvaporativeCooler_Indirect_CelDekPad, EvaporativeCooler_Indirect_WetCoil, EvaporativeCooler_Indirect_ResearchSpecial, EvaporativeCooler_Direct_ResearchSpecial, Humidifier_Steam_Electric, Humidifier_Steam_Gas, Dehumidifier_Desiccant_NoFans, Dehumidifier_Desiccant_System, HeatExchanger_AirToAir_FlatPlate, HeatExchanger_AirToAir_SensibleAndLatent, HeatExchanger_Desiccant_BalancedFlow, HeatExchanger_Desiccant_BalancedFlow_PerformanceDataType1, AirLoopHVAC_UnitarySystem, UnitarySystemPerformance_Multispeed, AirLoopHVAC_Unitary_Furnace_HeatOnly, AirLoopHVAC_Unitary_Furnace_HeatCool, AirLoopHVAC_UnitaryHeatOnly, AirLoopHVAC_UnitaryHeatCool, AirLoopHVAC_UnitaryHeatPump_AirToAir, AirLoopHVAC_UnitaryHeatPump_WaterToAir, AirLoopHVAC_UnitaryHeatCool_VAVChangeoverBypass, AirLoopHVAC_UnitaryHeatPump_AirToAir_MultiSpeed, AirConditioner_VariableRefrigerantFlow, AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl, AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_HR, ZoneTerminalUnitList, Controller_WaterCoil, Controller_OutdoorAir, Controller_MechanicalVentilation, AirLoopHVAC_ControllerList, AirLoopHVAC, AirLoopHVAC_OutdoorAirSystem_EquipmentList, AirLoopHVAC_OutdoorAirSystem, OutdoorAir_Mixer, AirLoopHVAC_ZoneSplitter, AirLoopHVAC_SupplyPlenum, AirLoopHVAC_SupplyPath, AirLoopHVAC_ZoneMixer, AirLoopHVAC_ReturnPlenum, AirLoopHVAC_ReturnPath, AirLoopHVAC_ExhaustSystem, AirLoopHVAC_DedicatedOutdoorAirSystem, AirLoopHVAC_Mixer, AirLoopHVAC_Splitter, Branch, BranchList, Connector_Splitter, Connector_Mixer, ConnectorList, NodeList, OutdoorAir_Node, OutdoorAir_NodeList, Pipe_Adiabatic, Pipe_Adiabatic_Steam, Pipe_Indoor, Pipe_Outdoor, Pipe_Underground, PipingSystem_Underground_Domain, PipingSystem_Underground_PipeCircuit, PipingSystem_Underground_PipeSegment, Duct, Pump_VariableSpeed, Pump_ConstantSpeed, Pump_VariableSpeed_Condensate, HeaderedPumps_ConstantSpeed, HeaderedPumps_VariableSpeed, TemperingValve, LoadProfile_Plant, SolarCollectorPerformance_FlatPlate, SolarCollector_FlatPlate_Water, SolarCollector_FlatPlate_PhotovoltaicThermal, SolarCollectorPerformance_PhotovoltaicThermal_Simple, SolarCollectorPerformance_PhotovoltaicThermal_BIPVT, SolarCollector_IntegralCollectorStorage, SolarCollectorPerformance_IntegralCollectorStorage, SolarCollector_UnglazedTranspired, SolarCollector_UnglazedTranspired_Multisystem, Boiler_HotWater, Boiler_Steam, Chiller_Electric_ASHRAE205, Chiller_Electric_EIR, Chiller_Electric_ReformulatedEIR, Chiller_Electric, Chiller_Absorption_Indirect, Chiller_Absorption, Chiller_ConstantCOP, Chiller_EngineDriven, Chiller_CombustionTurbine, ChillerHeater_Absorption_DirectFired, ChillerHeater_Absorption_DoubleEffect, HeatPump_PlantLoop_EIR_Cooling, HeatPump_PlantLoop_EIR_Heating, HeatPump_AirToWater_FuelFired_Heating, HeatPump_AirToWater_FuelFired_Cooling, HeatPump_AirToWater, HeatPump_WaterToWater_EquationFit_Heating, HeatPump_WaterToWater_EquationFit_Cooling, HeatPump_WaterToWater_ParameterEstimation_Cooling, HeatPump_WaterToWater_ParameterEstimation_Heating, DistrictCooling, DistrictHeating_Water, DistrictHeating_Steam, PlantComponent_TemperatureSource, CentralHeatPumpSystem, ChillerHeaterPerformance_Electric_EIR, CoolingTower_SingleSpeed, CoolingTower_TwoSpeed, CoolingTower_VariableSpeed_Merkel, CoolingTower_VariableSpeed, CoolingTowerPerformance_CoolTools, CoolingTowerPerformance_YorkCalc, EvaporativeFluidCooler_SingleSpeed, EvaporativeFluidCooler_TwoSpeed, FluidCooler_SingleSpeed, FluidCooler_TwoSpeed, GroundHeatExchanger_System, GroundHeatExchanger_Vertical_Sizing_Rectangle, GroundHeatExchanger_Vertical_Properties, GroundHeatExchanger_Vertical_Array, GroundHeatExchanger_Vertical_Single, GroundHeatExchanger_ResponseFactors, GroundHeatExchanger_Pond, GroundHeatExchanger_Surface, GroundHeatExchanger_HorizontalTrench, GroundHeatExchanger_Slinky, HeatExchanger_FluidToFluid, WaterHeater_Mixed, WaterHeater_Stratified, WaterHeater_Sizing, WaterHeater_HeatPump_PumpedCondenser, WaterHeater_HeatPump_WrappedCondenser, ThermalStorage_Ice_Simple, ThermalStorage_Ice_Detailed, ThermalStorage_ChilledWater_Mixed, ThermalStorage_ChilledWater_Stratified, ThermalStorage_HotWater_Stratified, ThermalStorage_PCM, ThermalStorage_Sizing, PlantLoop, CondenserLoop, PlantEquipmentList, CondenserEquipmentList, PlantEquipmentOperation_Uncontrolled, PlantEquipmentOperation_CoolingLoad, PlantEquipmentOperation_HeatingLoad, PlantEquipmentOperation_OutdoorDryBulb, PlantEquipmentOperation_OutdoorWetBulb, PlantEquipmentOperation_OutdoorRelativeHumidity, PlantEquipmentOperation_OutdoorDewpoint, PlantEquipmentOperation_ComponentSetpoint, PlantEquipmentOperation_ThermalEnergyStorage, PlantEquipmentOperation_OutdoorDryBulbDifference, PlantEquipmentOperation_OutdoorWetBulbDifference, PlantEquipmentOperation_OutdoorDewpointDifference, PlantEquipmentOperation_ChillerHeaterChangeover, PlantEquipmentOperationSchemes, CondenserEquipmentOperationSchemes, EnergyManagementSystem_Sensor, EnergyManagementSystem_Actuator, EnergyManagementSystem_ProgramCallingManager, EnergyManagementSystem_Program, EnergyManagementSystem_Subroutine, EnergyManagementSystem_GlobalVariable, EnergyManagementSystem_OutputVariable, EnergyManagementSystem_MeteredOutputVariable, EnergyManagementSystem_TrendVariable, EnergyManagementSystem_InternalVariable, EnergyManagementSystem_CurveOrTableIndexVariable, EnergyManagementSystem_ConstructionIndexVariable, ExternalInterface, ExternalInterface_Schedule, ExternalInterface_Variable, ExternalInterface_Actuator, ExternalInterface_FunctionalMockupUnitImport, ExternalInterface_FunctionalMockupUnitImport_From_Variable, ExternalInterface_FunctionalMockupUnitImport_To_Schedule, ExternalInterface_FunctionalMockupUnitImport_To_Actuator, ExternalInterface_FunctionalMockupUnitImport_To_Variable, ExternalInterface_FunctionalMockupUnitExport_From_Variable, ExternalInterface_FunctionalMockupUnitExport_To_Schedule, ExternalInterface_FunctionalMockupUnitExport_To_Actuator, ExternalInterface_FunctionalMockupUnitExport_To_Variable, ZoneHVAC_ForcedAir_UserDefined, AirTerminal_SingleDuct_UserDefined, Coil_UserDefined, PlantComponent_UserDefined, PlantEquipmentOperation_UserDefined, AvailabilityManager_Scheduled, AvailabilityManager_ScheduledOn, AvailabilityManager_ScheduledOff, AvailabilityManager_OptimumStart, AvailabilityManager_NightCycle, AvailabilityManager_DifferentialThermostat, AvailabilityManager_HighTemperatureTurnOff, AvailabilityManager_HighTemperatureTurnOn, AvailabilityManager_LowTemperatureTurnOff, AvailabilityManager_LowTemperatureTurnOn, AvailabilityManager_NightVentilation, AvailabilityManager_HybridVentilation, AvailabilityManagerAssignmentList, SetpointManager_Scheduled, SetpointManager_Scheduled_DualSetpoint, SetpointManager_OutdoorAirReset, SetpointManager_SingleZone_Reheat, SetpointManager_SingleZone_Heating, SetpointManager_SingleZone_Cooling, SetpointManager_SingleZone_Humidity_Minimum, SetpointManager_SingleZone_Humidity_Maximum, SetpointManager_MixedAir, SetpointManager_OutdoorAirPretreat, SetpointManager_Warmest, SetpointManager_Coldest, SetpointManager_ReturnAirBypassFlow, SetpointManager_WarmestTemperatureFlow, SetpointManager_MultiZone_Heating_Average, SetpointManager_MultiZone_Cooling_Average, SetpointManager_MultiZone_MinimumHumidity_Average, SetpointManager_MultiZone_MaximumHumidity_Average, SetpointManager_MultiZone_Humidity_Minimum, SetpointManager_MultiZone_Humidity_Maximum, SetpointManager_FollowOutdoorAirTemperature, SetpointManager_FollowSystemNodeTemperature, SetpointManager_FollowGroundTemperature, SetpointManager_CondenserEnteringReset, SetpointManager_CondenserEnteringReset_Ideal, SetpointManager_SingleZone_OneStageCooling, SetpointManager_SingleZone_OneStageHeating, SetpointManager_ReturnTemperature_ChilledWater, SetpointManager_ReturnTemperature_HotWater, SetpointManager_SystemNodeReset_Temperature, SetpointManager_SystemNodeReset_Humidity, Refrigeration_Case, Refrigeration_CompressorRack, Refrigeration_CaseAndWalkInList, Refrigeration_Condenser_AirCooled, Refrigeration_Condenser_EvaporativeCooled, Refrigeration_Condenser_WaterCooled, Refrigeration_Condenser_Cascade, Refrigeration_GasCooler_AirCooled, Refrigeration_TransferLoadList, Refrigeration_Subcooler, Refrigeration_Compressor, Refrigeration_CompressorList, Refrigeration_System, Refrigeration_TranscriticalSystem, Refrigeration_SecondarySystem, Refrigeration_WalkIn, Refrigeration_AirChiller, ZoneHVAC_RefrigerationChillerSet, DemandManagerAssignmentList, DemandManager_ExteriorLights, DemandManager_Lights, DemandManager_ElectricEquipment, DemandManager_Thermostats, DemandManager_Ventilation, Generator_InternalCombustionEngine, Generator_CombustionTurbine, Generator_MicroTurbine, Generator_Photovoltaic, PhotovoltaicPerformance_Simple, PhotovoltaicPerformance_EquivalentOneDiode, PhotovoltaicPerformance_Sandia, Generator_PVWatts, ElectricLoadCenter_Inverter_PVWatts, Generator_FuelCell, Generator_FuelCell_PowerModule, Generator_FuelCell_AirSupply, Generator_FuelCell_WaterSupply, Generator_FuelCell_AuxiliaryHeater, Generator_FuelCell_ExhaustGasToWaterHeatExchanger, Generator_FuelCell_ElectricalStorage, Generator_FuelCell_Inverter, Generator_FuelCell_StackCooler, Generator_MicroCHP, Generator_MicroCHP_NonNormalizedParameters, Generator_FuelSupply, Generator_WindTurbine, ElectricLoadCenter_Generators, ElectricLoadCenter_Inverter_Simple, ElectricLoadCenter_Inverter_FunctionOfPower, ElectricLoadCenter_Inverter_LookUpTable, ElectricLoadCenter_Storage_Simple, ElectricLoadCenter_Storage_Battery, ElectricLoadCenter_Storage_LiIonNMCBattery, ElectricLoadCenter_Transformer, ElectricLoadCenter_Distribution, ElectricLoadCenter_Storage_Converter, WaterUse_Equipment, WaterUse_Connections, WaterUse_Storage, WaterUse_Well, WaterUse_RainCollector, FaultModel_TemperatureSensorOffset_OutdoorAir, FaultModel_HumiditySensorOffset_OutdoorAir, FaultModel_EnthalpySensorOffset_OutdoorAir, FaultModel_TemperatureSensorOffset_ReturnAir, FaultModel_EnthalpySensorOffset_ReturnAir, FaultModel_TemperatureSensorOffset_ChillerSupplyWater, FaultModel_TemperatureSensorOffset_CoilSupplyAir, FaultModel_TemperatureSensorOffset_CondenserSupplyWater, FaultModel_ThermostatOffset, FaultModel_HumidistatOffset, FaultModel_Fouling_AirFilter, FaultModel_Fouling_Boiler, FaultModel_Fouling_EvaporativeCooler, FaultModel_Fouling_Chiller, FaultModel_Fouling_CoolingTower, FaultModel_Fouling_Coil, Matrix_TwoDimension, HybridModel_Zone, Curve_Linear, Curve_QuadLinear, Curve_QuintLinear, Curve_Quadratic, Curve_Cubic, Curve_Quartic, Curve_Exponent, Curve_Bicubic, Curve_Biquadratic, Curve_QuadraticLinear, Curve_CubicLinear, Curve_Triquadratic, Curve_Functional_PressureDrop, Curve_FanPressureRise, Curve_ExponentialSkewNormal, Curve_Sigmoid, Curve_RectangularHyperbola1, Curve_RectangularHyperbola2, Curve_ExponentialDecay, Curve_DoubleExponentialDecay, Curve_ChillerPartLoadWithLift, Table_IndependentVariable, Table_IndependentVariableList, Table_Lookup, FluidProperties_Name, FluidProperties_GlycolConcentration, FluidProperties_Temperatures, FluidProperties_Saturated, FluidProperties_Superheated, FluidProperties_Concentration, CurrencyType, ComponentCost_Adjustments, ComponentCost_Reference, ComponentCost_LineItem, UtilityCost_Tariff, UtilityCost_Qualify, UtilityCost_Charge_Simple, UtilityCost_Charge_Block, UtilityCost_Ratchet, UtilityCost_Variable, UtilityCost_Computation, LifeCycleCost_Parameters, LifeCycleCost_RecurringCosts, LifeCycleCost_NonrecurringCost, LifeCycleCost_UsePriceEscalation, LifeCycleCost_UseAdjustment, Parametric_SetValueForRun, Parametric_Logic, Parametric_RunControl, Parametric_FileNameSuffix, Output_VariableDictionary, Output_Surfaces_List, Output_Surfaces_Drawing, Output_Schedules, Output_Constructions, Output_EnergyManagementSystem, OutputControl_SurfaceColorScheme, Output_Table_SummaryReports, Output_Table_TimeBins, Output_Table_Monthly, Output_Table_Annual, Output_Table_ReportPeriod, OutputControl_Table_Style, OutputControl_ReportingTolerances, OutputControl_ResilienceSummaries, Output_Variable, Output_Meter, Output_Meter_MeterFileOnly, Output_Meter_Cumulative, Output_Meter_Cumulative_MeterFileOnly, Meter_Custom, Meter_CustomDecrement, OutputControl_Files, OutputControl_Timestamp, Output_JSON, Output_SQLite, Output_EnvironmentalImpactFactors, EnvironmentalImpactFactors, FuelFactors, Output_Diagnostics, Output_DebuggingData, Output_PreprocessorMessage, PythonPlugin_SearchPaths, PythonPlugin_Instance, PythonPlugin_Variables, PythonPlugin_TrendVariable, PythonPlugin_OutputVariable, OS_Version, OS_ComponentData, OS_ConvergenceLimits, OS_ProgramControl, OS_HeatBalanceAlgorithm, OS_RunPeriod, OS_RunPeriodControl_DaylightSavingTime, OS_RunPeriodControl_SpecialDays, OS_ShadowCalculation, OS_SimulationControl, OS_PerformancePrecisionTradeoffs, OS_Sizing_Parameters, OS_SurfaceConvectionAlgorithm_Inside, OS_SurfaceConvectionAlgorithm_Outside, OS_Timestep, OS_YearDescription, OS_ZoneAirContaminantBalance, OS_ZoneAirHeatBalanceAlgorithm, OS_ZoneAirMassFlowConservation, OS_ZoneCapacitanceMultiplier_ResearchSpecial, OS_RadianceParameters, OS_ClimateZones, OS_Site, OS_Site_GroundTemperature_BuildingSurface, OS_Site_GroundTemperature_FCfactorMethod, OS_Site_GroundTemperature_Shallow, OS_Site_GroundTemperature_Deep, OS_Site_GroundTemperature_Undisturbed_KusudaAchenbach, OS_Site_GroundTemperature_Undisturbed_Xing, OS_Site_GroundReflectance, OS_Site_WaterMainsTemperature, OS_SizingPeriod_DesignDay, OS_SizingPeriod_WeatherFileConditionType, OS_SizingPeriod_WeatherFileDays, OS_WeatherFile, OS_WeatherProperty_SkyTemperature, OS_AdditionalProperties, OS_BuildingStory, OS_BuildingUnit, OS_DefaultConstructionSet, OS_DefaultScheduleSet, OS_DefaultSubSurfaceConstructions, OS_DefaultSurfaceConstructions, OS_Rendering_Color, OS_SpaceType, OS_ModelObjectList, OS_Material, OS_Material_AirGap, OS_Material_InfraredTransparent, OS_Material_NoMass, OS_Material_RoofVegetation, OS_WindowMaterial_Blind, OS_WindowMaterial_DaylightRedirectionDevice, OS_WindowMaterial_Gas, OS_WindowMaterial_GasMixture, OS_WindowMaterial_Glazing, OS_WindowMaterial_GlazingGroup_Thermochromic, OS_WindowMaterial_Glazing_RefractionExtinctionMethod, OS_WindowMaterial_Screen, OS_WindowMaterial_Shade, OS_WindowMaterial_SimpleGlazingSystem, OS_StandardsInformation_Material, OS_MaterialProperty_GlazingSpectralData, OS_MaterialProperty_MoisturePenetrationDepth_Settings, OS_MaterialProperty_PhaseChange, OS_MaterialProperty_PhaseChangeHysteresis, OS_Construction, OS_Construction_CfactorUndergroundWall, OS_Construction_FfactorGroundFloor, OS_Construction_InternalSource, OS_Construction_AirBoundary, OS_Construction_WindowDataFile, OS_StandardsInformation_Construction, OS_InternalMass_Definition, OS_People_Definition, OS_Lights_Definition, OS_Luminaire_Definition, OS_ElectricEquipment_Definition, OS_ElectricEquipment_ITE_AirCooled_Definition, OS_GasEquipment_Definition, OS_HotWaterEquipment_Definition, OS_SteamEquipment_Definition, OS_OtherEquipment_Definition, OS_Exterior_Lights_Definition, OS_Exterior_FuelEquipment_Definition, OS_Exterior_WaterEquipment_Definition, OS_Schedule_Compact, OS_Schedule_Day, OS_Schedule_Week, OS_Schedule_Year, OS_Schedule_Rule, OS_Schedule_Ruleset, OS_Schedule_Constant, OS_Schedule_FixedInterval, OS_Schedule_VariableInterval, OS_ScheduleTypeLimits, OS_External_File, OS_Schedule_File, OS_Building, OS_DaylightingDevice_Tubular, OS_DaylightingDevice_Shelf, OS_DaylightingDevice_LightWell, OS_Facility, OS_InteriorPartitionSurface, OS_InteriorPartitionSurfaceGroup, OS_ShadingSurface, OS_ShadingSurfaceGroup, OS_Space, OS_Surface, OS_SubSurface, OS_ShadingControl, OS_WindowProperty_FrameAndDivider, OS_SurfaceControl_MovableInsulation, OS_SurfaceProperty_ConvectionCoefficients, OS_SurfaceProperty_ConvectionCoefficients_MultipleSurface, OS_SurfaceProperty_ExposedFoundationPerimeter, OS_SurfaceProperty_OtherSideCoefficients, OS_SurfaceProperty_OtherSideConditionsModel, OS_Foundation_Kiva, OS_Foundation_Kiva_Settings, OS_ZoneProperty_UserViewFactors_BySurfaceName, OS_SurfaceProperty_SurroundingSurfaces, OS_SurfaceProperty_LocalEnvironment, OS_SurfaceProperty_GroundSurfaces, OS_SurfaceProperty_IncidentSolarMultiplier, OS_InternalMass, OS_People, OS_Lights, OS_Luminaire, OS_ElectricEquipment, OS_ElectricEquipment_ITE_AirCooled, OS_GasEquipment, OS_HotWaterEquipment, OS_SteamEquipment, OS_OtherEquipment, OS_SpaceInfiltration_DesignFlowRate, OS_SpaceInfiltration_EffectiveLeakageArea, OS_SpaceInfiltration_FlowCoefficient, OS_Exterior_Lights, OS_Exterior_FuelEquipment, OS_Exterior_WaterEquipment, OS_Daylighting_Control, OS_Glare_Sensor, OS_IlluminanceMap, OS_LightingDesignDay, OS_LightingSimulationControl, OS_LightingSimulationZone, OS_Refrigeration_Case, OS_Refrigeration_Condenser_AirCooled, OS_Refrigeration_Condenser_EvaporativeCooled, OS_Refrigeration_Condenser_WaterCooled, OS_Refrigeration_Condenser_Cascade, OS_Refrigeration_Compressor, OS_Refrigeration_CompressorRack, OS_Refrigeration_DefrostCycleParameters, OS_Refrigeration_GasCooler_AirCooled, OS_Refrigeration_Subcooler_Mechanical, OS_Refrigeration_Subcooler_LiquidSuction, OS_Refrigeration_System, OS_Refrigeration_TranscriticalSystem, OS_Refrigeration_SecondarySystem, OS_Refrigeration_WalkIn, OS_Refrigeration_WalkIn_ZoneBoundary, OS_Refrigeration_AirChiller, OS_AirConditioner_VariableRefrigerantFlow, OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl, OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_LoadingIndex, OS_AirConditioner_VariableRefrigerantFlow_FluidTemperatureControl_HR, OS_AirLoopHVAC, OS_AirLoopHVAC_OutdoorAirSystem, OS_AirLoopHVAC_DedicatedOutdoorAirSystem, OS_AirLoopHVAC_ReturnPlenum, OS_AirLoopHVAC_SupplyPlenum, OS_AirLoopHVAC_UnitaryHeatPump_AirToAir_MultiSpeed, OS_AirLoopHVAC_UnitaryCoolOnly, OS_AirLoopHVAC_UnitaryHeatPump_AirToAir, OS_AirLoopHVAC_UnitaryHeatCool_VAVChangeoverBypass, OS_AirLoopHVAC_UnitarySystem, OS_UnitarySystemPerformance_Multispeed, OS_AirLoopHVAC_ZoneMixer, OS_AirLoopHVAC_ZoneSplitter, OS_AirTerminal_SingleDuct_VAV_HeatAndCool_NoReheat, OS_AirTerminal_SingleDuct_VAV_HeatAndCool_Reheat, OS_AirTerminal_SingleDuct_InletSideMixer, OS_AirTerminal_SingleDuct_ConstantVolume_Reheat, OS_AirTerminal_SingleDuct_SeriesPIU_Reheat, OS_AirTerminal_SingleDuct_ParallelPIU_Reheat, OS_AirTerminal_SingleDuct_ConstantVolume_FourPipeInduction, OS_AirTerminal_SingleDuct_ConstantVolume_FourPipeBeam, OS_AirTerminal_SingleDuct_ConstantVolume_CooledBeam, OS_AirTerminal_SingleDuct_ConstantVolume_NoReheat, OS_AirTerminal_SingleDuct_VAV_NoReheat, OS_AirTerminal_SingleDuct_VAV_Reheat, OS_AirTerminal_DualDuct_VAV_OutdoorAir, OS_AirTerminal_DualDuct_ConstantVolume, OS_AirTerminal_DualDuct_VAV, OS_AvailabilityManagerAssignmentList, OS_AvailabilityManager_Scheduled, OS_AvailabilityManager_ScheduledOn, OS_AvailabilityManager_ScheduledOff, OS_AvailabilityManager_NightCycle, OS_AvailabilityManager_OptimumStart, OS_AvailabilityManager_DifferentialThermostat, OS_AvailabilityManager_HighTemperatureTurnOff, OS_AvailabilityManager_HighTemperatureTurnOn, OS_AvailabilityManager_LowTemperatureTurnOff, OS_AvailabilityManager_LowTemperatureTurnOn, OS_AvailabilityManager_NightVentilation, OS_AvailabilityManager_HybridVentilation, OS_Boiler_HotWater, OS_Boiler_Steam, OS_HeatPump_WaterToWater_EquationFit_Heating, OS_HeatPump_WaterToWater_EquationFit_Cooling, OS_HeatPump_PlantLoop_EIR_Heating, OS_HeatPump_PlantLoop_EIR_Cooling, OS_HeatPump_AirToWater_FuelFired_Heating, OS_HeatPump_AirToWater_FuelFired_Cooling, OS_Chiller_Electric_EIR, OS_Chiller_Electric_ReformulatedEIR, OS_Chiller_Electric_ASHRAE205, OS_CentralHeatPumpSystem, OS_CentralHeatPumpSystem_Module, OS_ChillerHeaterPerformance_Electric_EIR, OS_Chiller_Absorption_Indirect, OS_Chiller_Absorption, OS_CoolingTower_SingleSpeed, OS_CoolingTower_TwoSpeed, OS_CoolingTower_VariableSpeed, OS_CoolingTowerPerformance_CoolTools, OS_CoolingTowerPerformance_YorkCalc, OS_DistrictCooling, OS_DistrictHeating_Water, OS_DistrictHeating_Steam, OS_GroundHeatExchanger_Vertical, OS_GroundHeatExchanger_HorizontalTrench, OS_Coil_Cooling_CooledBeam, OS_Coil_Cooling_FourPipeBeam, OS_Coil_Heating_FourPipeBeam, OS_Coil_Cooling_DX, OS_Coil_Cooling_DX_CurveFit_Performance, OS_Coil_Cooling_DX_CurveFit_OperatingMode, OS_Coil_Cooling_DX_CurveFit_Speed, OS_Coil_Cooling_DX_SingleSpeed, OS_Coil_Cooling_DX_TwoStageWithHumidityControlMode, OS_CoilPerformance_DX_Cooling, OS_Coil_Cooling_DX_MultiSpeed, OS_Coil_Cooling_DX_MultiSpeed_StageData, OS_Coil_Cooling_DX_TwoSpeed, OS_CoilSystem_Cooling_Water, OS_CoilSystem_Cooling_Water_HeatExchangerAssisted, OS_CoilSystem_Cooling_DX_HeatExchangerAssisted, OS_CoilSystem_IntegratedHeatPump_AirSource, OS_Coil_Cooling_DX_SingleSpeed_ThermalStorage, OS_Coil_Cooling_DX_VariableRefrigerantFlow, OS_Coil_Cooling_DX_VariableRefrigerantFlow_FluidTemperatureControl, OS_Coil_Cooling_LowTemperatureRadiant_ConstantFlow, OS_Coil_Cooling_LowTemperatureRadiant_VariableFlow, OS_Coil_Cooling_Water, OS_Coil_Cooling_WaterToAirHeatPump_EquationFit, OS_Coil_Heating_DX_SingleSpeed, OS_Coil_Heating_DX_VariableRefrigerantFlow, OS_Coil_Heating_DX_VariableRefrigerantFlow_FluidTemperatureControl, OS_Coil_Heating_Electric, OS_Coil_Heating_Electric_MultiStage, OS_Coil_Heating_Electric_MultiStage_StageData, OS_Coil_Heating_Gas, OS_Coil_Heating_Gas_MultiStage, OS_Coil_Heating_Gas_MultiStage_StageData, OS_Coil_Heating_Desuperheater, OS_Coil_WaterHeating_Desuperheater, OS_Coil_Heating_LowTemperatureRadiant_ConstantFlow, OS_Coil_Heating_LowTemperatureRadiant_VariableFlow, OS_Coil_Heating_Water, OS_Coil_Heating_Steam, OS_Coil_Heating_Water_Baseboard, OS_Coil_Heating_Water_Baseboard_Radiant, OS_Coil_Heating_Steam_Baseboard_Radiant, OS_Coil_Heating_WaterToAirHeatPump_EquationFit, OS_Coil_Heating_DX_MultiSpeed, OS_Coil_Heating_DX_MultiSpeed_StageData, OS_Coil_Heating_DX_VariableSpeed, OS_Coil_Heating_DX_VariableSpeed_SpeedData, OS_Coil_Cooling_DX_VariableSpeed, OS_Coil_Cooling_DX_VariableSpeed_SpeedData, OS_Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit, OS_Coil_Heating_WaterToAirHeatPump_VariableSpeedEquationFit_SpeedData, OS_Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit, OS_Coil_Cooling_WaterToAirHeatPump_VariableSpeedEquationFit_SpeedData, OS_Coil_Cooling_Water_Panel_Radiant, OS_Connection, OS_Connector_Mixer, OS_Connector_Splitter, OS_Controller_MechanicalVentilation, OS_ZoneControl_ContaminantController, OS_Controller_OutdoorAir, OS_Controller_WaterCoil, OS_Curve_Linear, OS_Curve_QuadLinear, OS_Curve_QuintLinear, OS_Curve_Quadratic, OS_Curve_Cubic, OS_Curve_Quartic, OS_Curve_Exponent, OS_Curve_Bicubic, OS_Curve_Biquadratic, OS_Curve_QuadraticLinear, OS_Curve_Triquadratic, OS_Curve_Functional_PressureDrop, OS_Curve_FanPressureRise, OS_Curve_ExponentialSkewNormal, OS_Curve_Sigmoid, OS_Curve_RectangularHyperbola1, OS_Curve_RectangularHyperbola2, OS_Curve_ExponentialDecay, OS_Curve_DoubleExponentialDecay, OS_Table_MultiVariableLookup, OS_Table_IndependentVariable, OS_Table_Lookup, OS_DesignSpecification_OutdoorAir, OS_DesignSpecification_ZoneAirDistribution, OS_Humidifier_Steam_Electric, OS_Humidifier_Steam_Gas, OS_EvaporativeCooler_Indirect_ResearchSpecial, OS_EvaporativeCooler_Direct_ResearchSpecial, OS_EvaporativeFluidCooler_SingleSpeed, OS_EvaporativeFluidCooler_TwoSpeed, OS_Fan_SystemModel, OS_Fan_ConstantVolume, OS_Fan_VariableVolume, OS_Fan_OnOff, OS_Fan_ComponentModel, OS_Fan_ZoneExhaust, OS_HeatExchanger_AirToAir_SensibleAndLatent, OS_HeatExchanger_Desiccant_BalancedFlow, OS_HeatExchanger_Desiccant_BalancedFlow_PerformanceDataType1, OS_HeatExchanger_FluidToFluid, OS_HVACComponentList, OS_Node, OS_PortList, OS_Pipe_Adiabatic, OS_PlantLoop, OS_PlantEquipmentOperation_CoolingLoad, OS_PlantEquipmentOperation_HeatingLoad, OS_PlantEquipmentOperation_OutdoorDryBulb, OS_PlantEquipmentOperation_OutdoorWetBulb, OS_PlantEquipmentOperation_OutdoorRelativeHumidity, OS_PlantEquipmentOperation_OutdoorDewpoint, OS_PlantEquipmentOperation_OutdoorDryBulbDifference, OS_PlantEquipmentOperation_OutdoorDewpointDifference, OS_PlantEquipmentOperation_OutdoorWetBulbDifference, OS_PlantComponent_TemperatureSource, OS_LoadProfile_Plant, OS_Pump_ConstantSpeed, OS_Pump_VariableSpeed, OS_Pump_VariableSpeed_Condensate, OS_HeaderedPumps_ConstantSpeed, OS_HeaderedPumps_VariableSpeed, OS_TemperingValve, OS_SetpointManager_FollowOutdoorAirTemperature, OS_SetpointManager_MixedAir, OS_SetpointManager_OutdoorAirReset, OS_SetpointManager_OutdoorAirPretreat, OS_SetpointManager_SingleZone_Reheat, OS_SetpointManager_SingleZone_Humidity_Minimum, OS_SetpointManager_MultiZone_MinimumHumidity_Average, OS_SetpointManager_MultiZone_Humidity_Minimum, OS_SetpointManager_Scheduled, OS_SetpointManager_Scheduled_DualSetpoint, OS_SetpointManager_Warmest, OS_SetpointManager_WarmestTemperatureFlow, OS_SetpointManager_Coldest, OS_SetpointManager_FollowGroundTemperature, OS_SetpointManager_FollowSystemNodeTemperature, OS_SetpointManager_MultiZone_Cooling_Average, OS_SetpointManager_MultiZone_Heating_Average, OS_SetpointManager_MultiZone_Humidity_Maximum, OS_SetpointManager_MultiZone_MaximumHumidity_Average, OS_SetpointManager_SingleZone_OneStageCooling, OS_SetpointManager_SingleZone_OneStageHeating, OS_SetpointManager_SingleZone_Humidity_Maximum, OS_SetpointManager_SingleZone_Cooling, OS_SetpointManager_SingleZone_Heating, OS_SetpointManager_SystemNodeReset_Temperature, OS_SetpointManager_SystemNodeReset_Humidity, OS_Sizing_Plant, OS_Sizing_System, OS_Sizing_Zone, OS_Splitter, OS_ThermalZone, OS_ZoneControl_Humidistat, OS_ThermostatSetpoint_DualSetpoint, OS_ZoneControl_Thermostat_StagedDualSetpoint, OS_ZoneHVAC_EquipmentList, OS_ZoneVentilation_DesignFlowRate, OS_ZoneVentilation_WindandStackOpenArea, OS_ZoneHVAC_Baseboard_Convective_Electric, OS_ZoneHVAC_Baseboard_Convective_Water, OS_ZoneHVAC_HighTemperatureRadiant, OS_ZoneHVAC_LowTemperatureRadiant_Electric, OS_ZoneHVAC_IdealLoadsAirSystem, OS_ZoneHVAC_FourPipeFanCoil, OS_ZoneHVAC_LowTemperatureRadiant_ConstantFlow, OS_ZoneHVAC_LowTemperatureRadiant_VariableFlow, OS_ZoneHVAC_PackagedTerminalHeatPump, OS_ZoneHVAC_PackagedTerminalAirConditioner, OS_ZoneHVAC_TerminalUnit_VariableRefrigerantFlow, OS_ZoneHVAC_WaterToAirHeatPump, OS_ZoneHVAC_UnitHeater, OS_ZoneHVAC_Dehumidifier_DX, OS_ZoneHVAC_EnergyRecoveryVentilator, OS_ZoneHVAC_EnergyRecoveryVentilator_Controller, OS_ZoneHVAC_UnitVentilator, OS_ZoneHVAC_Baseboard_RadiantConvective_Water, OS_ZoneHVAC_Baseboard_RadiantConvective_Steam, OS_ZoneHVAC_Baseboard_RadiantConvective_Electric, OS_ZoneHVAC_CoolingPanel_RadiantConvective_Water, OS_ZoneHVAC_EvaporativeCoolerUnit, OS_ZoneMixing, OS_WaterHeater_Mixed, OS_WaterHeater_HeatPump, OS_Coil_WaterHeating_AirToWaterHeatPump, OS_WaterHeater_HeatPump_WrappedCondenser, OS_Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed, OS_Coil_WaterHeating_AirToWaterHeatPump_VariableSpeed_SpeedData, OS_Coil_WaterHeating_AirToWaterHeatPump_Wrapped, OS_WaterHeater_Stratified, OS_WaterHeater_Sizing, OS_WaterUse_Equipment, OS_WaterUse_Equipment_Definition, OS_WaterUse_Connections, OS_ThermalStorage_Ice_Detailed, OS_ThermalStorage_ChilledWater_Stratified, OS_Duct, OS_FluidCooler_SingleSpeed, OS_FluidCooler_TwoSpeed, OS_Pipe_Indoor, OS_Pipe_Outdoor, OS_SwimmingPool_Indoor, OS_SolarCollectorPerformance_FlatPlate, OS_SolarCollector_FlatPlate_Water, OS_SolarCollectorPerformance_IntegralCollectorStorage, OS_SolarCollector_IntegralCollectorStorage, OS_SolarCollectorPerformance_PhotovoltaicThermal_Simple, OS_SolarCollectorPerformance_PhotovoltaicThermal_BIPVT, OS_SolarCollector_FlatPlate_PhotovoltaicThermal, OS_Generator_MicroTurbine, OS_Generator_MicroTurbine_HeatRecovery, OS_Generator_Photovoltaic, OS_PhotovoltaicPerformance_Simple, OS_PhotovoltaicPerformance_EquivalentOneDiode, OS_PhotovoltaicPerformance_Sandia, OS_Generator_FuelCell, OS_Generator_FuelCell_PowerModule, OS_Generator_FuelCell_AirSupply, OS_Generator_FuelCell_WaterSupply, OS_Generator_FuelCell_AuxiliaryHeater, OS_Generator_FuelCell_ExhaustGasToWaterHeatExchanger, OS_Generator_FuelCell_ElectricalStorage, OS_Generator_FuelCell_Inverter, OS_Generator_FuelCell_StackCooler, OS_Generator_FuelSupply, OS_Generator_WindTurbine, OS_Generator_PVWatts, OS_ElectricLoadCenter_Inverter_PVWatts, OS_ElectricLoadCenter_Inverter_Simple, OS_ElectricLoadCenter_Inverter_LookUpTable, OS_ElectricLoadCenter_Storage_Simple, OS_ElectricLoadCenter_Storage_LiIonNMCBattery, OS_ElectricLoadCenter_Transformer, OS_ElectricLoadCenter_Distribution, OS_ElectricLoadCenter_Storage_Converter, OS_ComponentCost_Adjustments, OS_LifeCycleCost, OS_CurrencyType, OS_LifeCycleCost_Parameters, OS_LifeCycleCost_UsePriceEscalation, OS_UtilityBill, OS_UtilityCost_Tariff, OS_UtilityCost_Qualify, OS_UtilityCost_Charge_Simple, OS_UtilityCost_Charge_Block, OS_UtilityCost_Ratchet, OS_UtilityCost_Variable, OS_UtilityCost_Computation, OS_Output_Schedules, OS_Output_Constructions, OS_OutputControl_Files, OS_OutputControl_Timestamp, OS_OutputControl_ReportingTolerances, OS_OutputControl_ResilienceSummaries, OS_OutputControl_Table_Style, OS_Output_Meter, OS_Output_Variable, OS_Meter_Custom, OS_Meter_CustomDecrement, OS_Output_EnvironmentalImpactFactors, OS_EnvironmentalImpactFactors, OS_FuelFactors, OS_Output_Diagnostics, OS_Output_DebuggingData, OS_Output_JSON, OS_Output_SQLite, OS_Output_EnergyManagementSystem, OS_Output_Table_SummaryReports, OS_Output_Table_Monthly, OS_Output_Table_Annual, OS_EnergyManagementSystem_Sensor, OS_EnergyManagementSystem_Actuator, OS_EnergyManagementSystem_ProgramCallingManager, OS_EnergyManagementSystem_Program, OS_EnergyManagementSystem_Subroutine, OS_EnergyManagementSystem_GlobalVariable, OS_EnergyManagementSystem_OutputVariable, OS_EnergyManagementSystem_MeteredOutputVariable, OS_EnergyManagementSystem_TrendVariable, OS_EnergyManagementSystem_InternalVariable, OS_EnergyManagementSystem_CurveOrTableIndexVariable, OS_EnergyManagementSystem_ConstructionIndexVariable, OS_PythonPlugin_SearchPaths, OS_PythonPlugin_Instance, OS_PythonPlugin_Variable, OS_PythonPlugin_TrendVariable, OS_PythonPlugin_OutputVariable, OS_AirflowNetworkSimulationControl, OS_AirflowNetworkZone, OS_AirflowNetworkSurface, OS_AirflowNetworkReferenceCrackConditions, OS_AirflowNetworkCrack, OS_AirflowNetworkEffectiveLeakageArea, OS_AirflowNetworkSpecifiedFlowRate, OS_AirflowNetworkDetailedOpening, OS_AirflowNetworkSimpleOpening, OS_AirflowNetworkHorizontalOpening, OS_AirflowNetworkOutdoorAirflow, OS_AirflowNetworkZoneExhaustFan, OS_AirflowNetworkExternalNode, OS_AirflowNetworkPressureController, OS_AirflowNetworkDistributionNode, OS_AirflowNetworkLeak, OS_AirflowNetworkLeakageRatio, OS_AirflowNetworkDuct, OS_AirflowNetworkFan, OS_AirflowNetworkEquivalentDuct, OS_AirflowNetworkConstantPressureDrop, OS_AirflowNetworkReliefAirFlow, OS_AirflowNetworkDistributionLinkage, OS_AirflowNetworkDuctViewFactors, OS_AirflowNetworkOccupantVentilationControl, OS_ExternalInterface, OS_ExternalInterface_Schedule, OS_ExternalInterface_Variable, OS_ExternalInterface_Actuator, OS_ExternalInterface_FunctionalMockupUnitImport, OS_ExternalInterface_FunctionalMockupUnitImport_From_Variable, OS_ExternalInterface_FunctionalMockupUnitImport_To_Schedule, OS_ExternalInterface_FunctionalMockupUnitImport_To_Actuator, OS_ExternalInterface_FunctionalMockupUnitImport_To_Variable, OS_ExternalInterface_FunctionalMockupUnitExport_From_Variable, OS_ExternalInterface_FunctionalMockupUnitExport_To_Schedule, OS_ExternalInterface_FunctionalMockupUnitExport_To_Actuator, OS_ExternalInterface_FunctionalMockupUnitExport_To_Variable, OS_Coil_UserDefined, OS_PlantComponent_UserDefined, CommentOnly,   };

}
#endif // UTILITIES_IDD_IDDENUMS_HXX
