/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_MATERIAL_NOMASS_FIELDENUMS_HXX
#define UTILITIES_IDD_MATERIAL_NOMASS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Material_NoMassFields
 *  \brief Enumeration of Material:NoMass's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Material_NoMassFields, )
#else
class Material_NoMassFields: public ::EnumBase<Material_NoMassFields> {
 public: 
  enum domain 
  {
Name, Roughness, ThermalResistance, ThermalAbsorptance, SolarAbsorptance, VisibleAbsorptance,   };
  Material_NoMassFields()
   : EnumBase<Material_NoMassFields>(Name) {} 
  Material_NoMassFields(const std::string &t_name) 
   : EnumBase<Material_NoMassFields>(t_name) {} 
  Material_NoMassFields(int t_value) 
   : EnumBase<Material_NoMassFields>(t_value) {} 
  static std::string enumName() 
  { return "Material_NoMassFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Material_NoMassFields>::integer_value()); }
   private:
    friend class EnumBase<Material_NoMassFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Material_NoMassFields::Name, "Name", "Name"},
{ Material_NoMassFields::Roughness, "Roughness", "Roughness"},
{ Material_NoMassFields::ThermalResistance, "ThermalResistance", "Thermal Resistance"},
{ Material_NoMassFields::ThermalAbsorptance, "ThermalAbsorptance", "Thermal Absorptance"},
{ Material_NoMassFields::SolarAbsorptance, "SolarAbsorptance", "Solar Absorptance"},
{ Material_NoMassFields::VisibleAbsorptance, "VisibleAbsorptance", "Visible Absorptance"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Material_NoMassFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Material_NoMassFields> OptionalMaterial_NoMassFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_MATERIAL_NOMASS_FIELDENUMS_HXX
