/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_HEATING_DX_VARIABLESPEED_SPEEDDATA_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_HEATING_DX_VARIABLESPEED_SPEEDDATA_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields
 *  \brief Enumeration of OS:Coil:Heating:DX:VariableSpeed:SpeedData's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields, )
#else
class OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields: public ::EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields> {
 public: 
  enum domain 
  {
Handle, Name, ReferenceUnitGrossRatedHeatingCapacity, ReferenceUnitGrossRatedHeatingCOP, ReferenceUnitRatedAirFlowRate, RatedSupplyAirFanPowerPerVolumeFlowRate2017, RatedSupplyAirFanPowerPerVolumeFlowRate2023, HeatingCapacityFunctionofTemperatureCurveName, TotalHeatingCapacityFunctionofAirFlowFractionCurveName, EnergyInputRatioFunctionofTemperatureCurveName, EnergyInputRatioFunctionofAirFlowFractionCurveName,   };
  OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields()
   : EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields>(Handle) {} 
  OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields>(t_name) {} 
  OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields(int t_value) 
   : EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::Handle, "Handle", "Handle"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::Name, "Name", "Name"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::ReferenceUnitGrossRatedHeatingCapacity, "ReferenceUnitGrossRatedHeatingCapacity", "Reference Unit Gross Rated Heating Capacity"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::ReferenceUnitGrossRatedHeatingCOP, "ReferenceUnitGrossRatedHeatingCOP", "Reference Unit Gross Rated Heating COP"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::ReferenceUnitRatedAirFlowRate, "ReferenceUnitRatedAirFlowRate", "Reference Unit Rated Air Flow Rate"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::RatedSupplyAirFanPowerPerVolumeFlowRate2017, "RatedSupplyAirFanPowerPerVolumeFlowRate2017", "Rated Supply Air Fan Power Per Volume Flow Rate 2017"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::RatedSupplyAirFanPowerPerVolumeFlowRate2023, "RatedSupplyAirFanPowerPerVolumeFlowRate2023", "Rated Supply Air Fan Power Per Volume Flow Rate 2023"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::HeatingCapacityFunctionofTemperatureCurveName, "HeatingCapacityFunctionofTemperatureCurveName", "Heating Capacity Function of Temperature Curve Name"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::TotalHeatingCapacityFunctionofAirFlowFractionCurveName, "TotalHeatingCapacityFunctionofAirFlowFractionCurveName", "Total  Heating Capacity Function of Air Flow Fraction Curve Name"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::EnergyInputRatioFunctionofTemperatureCurveName, "EnergyInputRatioFunctionofTemperatureCurveName", "Energy Input Ratio Function of Temperature Curve Name"},
{ OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields::EnergyInputRatioFunctionofAirFlowFractionCurveName, "EnergyInputRatioFunctionofAirFlowFractionCurveName", "Energy Input Ratio Function of Air Flow Fraction Curve Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Heating_DX_VariableSpeed_SpeedDataFields> OptionalOS_Coil_Heating_DX_VariableSpeed_SpeedDataFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_HEATING_DX_VARIABLESPEED_SPEEDDATA_FIELDENUMS_HXX
