/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_THERMALSTORAGE_PCM_FIELDENUMS_HXX
#define UTILITIES_IDD_THERMALSTORAGE_PCM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ThermalStorage_PCMFields
 *  \brief Enumeration of ThermalStorage:PCM's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ThermalStorage_PCMFields, )
#else
class ThermalStorage_PCMFields: public ::EnumBase<ThermalStorage_PCMFields> {
 public: 
  enum domain 
  {
Name, AvailabilityScheduleName, PlantSideInletNodeName, PlantSideOutletNodeName, UseSideInletNodeName, UseSideOutletNodeName, PCMMaterialName, TankCapacity, HeatLossRate, UseSideDesignFlowRate, PlantSideDesignFlowRate,   };
  ThermalStorage_PCMFields()
   : EnumBase<ThermalStorage_PCMFields>(Name) {} 
  ThermalStorage_PCMFields(const std::string &t_name) 
   : EnumBase<ThermalStorage_PCMFields>(t_name) {} 
  ThermalStorage_PCMFields(int t_value) 
   : EnumBase<ThermalStorage_PCMFields>(t_value) {} 
  static std::string enumName() 
  { return "ThermalStorage_PCMFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ThermalStorage_PCMFields>::integer_value()); }
   private:
    friend class EnumBase<ThermalStorage_PCMFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ThermalStorage_PCMFields::Name, "Name", "Name"},
{ ThermalStorage_PCMFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ ThermalStorage_PCMFields::PlantSideInletNodeName, "PlantSideInletNodeName", "Plant Side Inlet Node Name"},
{ ThermalStorage_PCMFields::PlantSideOutletNodeName, "PlantSideOutletNodeName", "Plant Side Outlet Node Name"},
{ ThermalStorage_PCMFields::UseSideInletNodeName, "UseSideInletNodeName", "Use Side Inlet Node Name"},
{ ThermalStorage_PCMFields::UseSideOutletNodeName, "UseSideOutletNodeName", "Use Side Outlet Node Name"},
{ ThermalStorage_PCMFields::PCMMaterialName, "PCMMaterialName", "PCM Material Name"},
{ ThermalStorage_PCMFields::TankCapacity, "TankCapacity", "Tank Capacity"},
{ ThermalStorage_PCMFields::HeatLossRate, "HeatLossRate", "Heat Loss Rate"},
{ ThermalStorage_PCMFields::UseSideDesignFlowRate, "UseSideDesignFlowRate", "Use Side Design Flow Rate"},
{ ThermalStorage_PCMFields::PlantSideDesignFlowRate, "PlantSideDesignFlowRate", "Plant Side Design Flow Rate"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ThermalStorage_PCMFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ThermalStorage_PCMFields> OptionalThermalStorage_PCMFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_THERMALSTORAGE_PCM_FIELDENUMS_HXX
