/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AIRFLOWNETWORK_DISTRIBUTION_COMPONENT_FAN_FIELDENUMS_HXX
#define UTILITIES_IDD_AIRFLOWNETWORK_DISTRIBUTION_COMPONENT_FAN_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AirflowNetwork_Distribution_Component_FanFields
 *  \brief Enumeration of AirflowNetwork:Distribution:Component:Fan's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AirflowNetwork_Distribution_Component_FanFields, )
#else
class AirflowNetwork_Distribution_Component_FanFields: public ::EnumBase<AirflowNetwork_Distribution_Component_FanFields> {
 public: 
  enum domain 
  {
FanName, SupplyFanObjectType,   };
  AirflowNetwork_Distribution_Component_FanFields()
   : EnumBase<AirflowNetwork_Distribution_Component_FanFields>(FanName) {} 
  AirflowNetwork_Distribution_Component_FanFields(const std::string &t_name) 
   : EnumBase<AirflowNetwork_Distribution_Component_FanFields>(t_name) {} 
  AirflowNetwork_Distribution_Component_FanFields(int t_value) 
   : EnumBase<AirflowNetwork_Distribution_Component_FanFields>(t_value) {} 
  static std::string enumName() 
  { return "AirflowNetwork_Distribution_Component_FanFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AirflowNetwork_Distribution_Component_FanFields>::integer_value()); }
   private:
    friend class EnumBase<AirflowNetwork_Distribution_Component_FanFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AirflowNetwork_Distribution_Component_FanFields::FanName, "FanName", "Fan Name"},
{ AirflowNetwork_Distribution_Component_FanFields::SupplyFanObjectType, "SupplyFanObjectType", "Supply Fan Object Type"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AirflowNetwork_Distribution_Component_FanFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AirflowNetwork_Distribution_Component_FanFields> OptionalAirflowNetwork_Distribution_Component_FanFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AIRFLOWNETWORK_DISTRIBUTION_COMPONENT_FAN_FIELDENUMS_HXX
