/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_LIFECYCLECOST_NONRECURRINGCOST_FIELDENUMS_HXX
#define UTILITIES_IDD_LIFECYCLECOST_NONRECURRINGCOST_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class LifeCycleCost_NonrecurringCostFields
 *  \brief Enumeration of LifeCycleCost:NonrecurringCost's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(LifeCycleCost_NonrecurringCostFields, )
#else
class LifeCycleCost_NonrecurringCostFields: public ::EnumBase<LifeCycleCost_NonrecurringCostFields> {
 public: 
  enum domain 
  {
Name, Category, Cost, StartofCosts, YearsfromStart, MonthsfromStart,   };
  LifeCycleCost_NonrecurringCostFields()
   : EnumBase<LifeCycleCost_NonrecurringCostFields>(Name) {} 
  LifeCycleCost_NonrecurringCostFields(const std::string &t_name) 
   : EnumBase<LifeCycleCost_NonrecurringCostFields>(t_name) {} 
  LifeCycleCost_NonrecurringCostFields(int t_value) 
   : EnumBase<LifeCycleCost_NonrecurringCostFields>(t_value) {} 
  static std::string enumName() 
  { return "LifeCycleCost_NonrecurringCostFields"; }
  domain value() const { return static_cast<domain>(EnumBase<LifeCycleCost_NonrecurringCostFields>::integer_value()); }
   private:
    friend class EnumBase<LifeCycleCost_NonrecurringCostFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ LifeCycleCost_NonrecurringCostFields::Name, "Name", "Name"},
{ LifeCycleCost_NonrecurringCostFields::Category, "Category", "Category"},
{ LifeCycleCost_NonrecurringCostFields::Cost, "Cost", "Cost"},
{ LifeCycleCost_NonrecurringCostFields::StartofCosts, "StartofCosts", "Start of Costs"},
{ LifeCycleCost_NonrecurringCostFields::YearsfromStart, "YearsfromStart", "Years from Start"},
{ LifeCycleCost_NonrecurringCostFields::MonthsfromStart, "MonthsfromStart", "Months from Start"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const LifeCycleCost_NonrecurringCostFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<LifeCycleCost_NonrecurringCostFields> OptionalLifeCycleCost_NonrecurringCostFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_LIFECYCLECOST_NONRECURRINGCOST_FIELDENUMS_HXX
