/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_PROGRAMCONTROL_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_PROGRAMCONTROL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_ProgramControlFields
 *  \brief Enumeration of OS:ProgramControl's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ProgramControlFields, )
#else
class OS_ProgramControlFields: public ::EnumBase<OS_ProgramControlFields> {
 public: 
  enum domain 
  {
Handle, NumberofThreadsAllowed,   };
  OS_ProgramControlFields()
   : EnumBase<OS_ProgramControlFields>(Handle) {} 
  OS_ProgramControlFields(const std::string &t_name) 
   : EnumBase<OS_ProgramControlFields>(t_name) {} 
  OS_ProgramControlFields(int t_value) 
   : EnumBase<OS_ProgramControlFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ProgramControlFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ProgramControlFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ProgramControlFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ProgramControlFields::Handle, "Handle", "Handle"},
{ OS_ProgramControlFields::NumberofThreadsAllowed, "NumberofThreadsAllowed", "Number of Threads Allowed"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ProgramControlFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ProgramControlFields> OptionalOS_ProgramControlFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_PROGRAMCONTROL_FIELDENUMS_HXX
