/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_CURVE_DOUBLEEXPONENTIALDECAY_FIELDENUMS_HXX
#define UTILITIES_IDD_CURVE_DOUBLEEXPONENTIALDECAY_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Curve_DoubleExponentialDecayFields
 *  \brief Enumeration of Curve:DoubleExponentialDecay's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Curve_DoubleExponentialDecayFields, )
#else
class Curve_DoubleExponentialDecayFields: public ::EnumBase<Curve_DoubleExponentialDecayFields> {
 public: 
  enum domain 
  {
Name, Coefficient1C1, Coefficient2C2, Coefficient3C3, Coefficient4C4, Coefficient5C5, MinimumValueofx, MaximumValueofx, MinimumCurveOutput, MaximumCurveOutput, InputUnitTypeforx, OutputUnitType,   };
  Curve_DoubleExponentialDecayFields()
   : EnumBase<Curve_DoubleExponentialDecayFields>(Name) {} 
  Curve_DoubleExponentialDecayFields(const std::string &t_name) 
   : EnumBase<Curve_DoubleExponentialDecayFields>(t_name) {} 
  Curve_DoubleExponentialDecayFields(int t_value) 
   : EnumBase<Curve_DoubleExponentialDecayFields>(t_value) {} 
  static std::string enumName() 
  { return "Curve_DoubleExponentialDecayFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Curve_DoubleExponentialDecayFields>::integer_value()); }
   private:
    friend class EnumBase<Curve_DoubleExponentialDecayFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Curve_DoubleExponentialDecayFields::Name, "Name", "Name"},
{ Curve_DoubleExponentialDecayFields::Coefficient1C1, "Coefficient1C1", "Coefficient1 C1"},
{ Curve_DoubleExponentialDecayFields::Coefficient2C2, "Coefficient2C2", "Coefficient2 C2"},
{ Curve_DoubleExponentialDecayFields::Coefficient3C3, "Coefficient3C3", "Coefficient3 C3"},
{ Curve_DoubleExponentialDecayFields::Coefficient4C4, "Coefficient4C4", "Coefficient4 C4"},
{ Curve_DoubleExponentialDecayFields::Coefficient5C5, "Coefficient5C5", "Coefficient5 C5"},
{ Curve_DoubleExponentialDecayFields::MinimumValueofx, "MinimumValueofx", "Minimum Value of x"},
{ Curve_DoubleExponentialDecayFields::MaximumValueofx, "MaximumValueofx", "Maximum Value of x"},
{ Curve_DoubleExponentialDecayFields::MinimumCurveOutput, "MinimumCurveOutput", "Minimum Curve Output"},
{ Curve_DoubleExponentialDecayFields::MaximumCurveOutput, "MaximumCurveOutput", "Maximum Curve Output"},
{ Curve_DoubleExponentialDecayFields::InputUnitTypeforx, "InputUnitTypeforx", "Input Unit Type for x"},
{ Curve_DoubleExponentialDecayFields::OutputUnitType, "OutputUnitType", "Output Unit Type"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Curve_DoubleExponentialDecayFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Curve_DoubleExponentialDecayFields> OptionalCurve_DoubleExponentialDecayFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_CURVE_DOUBLEEXPONENTIALDECAY_FIELDENUMS_HXX
