/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_AVAILABILITYMANAGER_NIGHTCYCLE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_AVAILABILITYMANAGER_NIGHTCYCLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_AvailabilityManager_NightCycleFields
 *  \brief Enumeration of OS:AvailabilityManager:NightCycle's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_AvailabilityManager_NightCycleFields, )
#else
class OS_AvailabilityManager_NightCycleFields: public ::EnumBase<OS_AvailabilityManager_NightCycleFields> {
 public: 
  enum domain 
  {
Handle, Name, ApplicabilitySchedule, FanSchedule, ControlType, ThermostatTolerance, CyclingRunTimeControlType, CyclingRunTime, ControlZoneorZoneListName, CoolingControlZoneorZoneListName, HeatingControlZoneorZoneListName, HeatingZoneFansOnlyZoneorZoneListName,   };
  OS_AvailabilityManager_NightCycleFields()
   : EnumBase<OS_AvailabilityManager_NightCycleFields>(Handle) {} 
  OS_AvailabilityManager_NightCycleFields(const std::string &t_name) 
   : EnumBase<OS_AvailabilityManager_NightCycleFields>(t_name) {} 
  OS_AvailabilityManager_NightCycleFields(int t_value) 
   : EnumBase<OS_AvailabilityManager_NightCycleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_AvailabilityManager_NightCycleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_AvailabilityManager_NightCycleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_AvailabilityManager_NightCycleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_AvailabilityManager_NightCycleFields::Handle, "Handle", "Handle"},
{ OS_AvailabilityManager_NightCycleFields::Name, "Name", "Name"},
{ OS_AvailabilityManager_NightCycleFields::ApplicabilitySchedule, "ApplicabilitySchedule", "Applicability Schedule"},
{ OS_AvailabilityManager_NightCycleFields::FanSchedule, "FanSchedule", "Fan Schedule"},
{ OS_AvailabilityManager_NightCycleFields::ControlType, "ControlType", "Control Type"},
{ OS_AvailabilityManager_NightCycleFields::ThermostatTolerance, "ThermostatTolerance", "Thermostat Tolerance"},
{ OS_AvailabilityManager_NightCycleFields::CyclingRunTimeControlType, "CyclingRunTimeControlType", "Cycling Run Time Control Type"},
{ OS_AvailabilityManager_NightCycleFields::CyclingRunTime, "CyclingRunTime", "Cycling Run Time"},
{ OS_AvailabilityManager_NightCycleFields::ControlZoneorZoneListName, "ControlZoneorZoneListName", "Control Zone or Zone List Name"},
{ OS_AvailabilityManager_NightCycleFields::CoolingControlZoneorZoneListName, "CoolingControlZoneorZoneListName", "Cooling Control Zone or Zone List Name"},
{ OS_AvailabilityManager_NightCycleFields::HeatingControlZoneorZoneListName, "HeatingControlZoneorZoneListName", "Heating Control Zone or Zone List Name"},
{ OS_AvailabilityManager_NightCycleFields::HeatingZoneFansOnlyZoneorZoneListName, "HeatingZoneFansOnlyZoneorZoneListName", "Heating Zone Fans Only Zone or Zone List Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_AvailabilityManager_NightCycleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_AvailabilityManager_NightCycleFields> OptionalOS_AvailabilityManager_NightCycleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_AVAILABILITYMANAGER_NIGHTCYCLE_FIELDENUMS_HXX
