/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_COMPONENT_SIMPLEOPENING_FIELDENUMS_HXX
#define UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_COMPONENT_SIMPLEOPENING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AirflowNetwork_MultiZone_Component_SimpleOpeningFields
 *  \brief Enumeration of AirflowNetwork:MultiZone:Component:SimpleOpening's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AirflowNetwork_MultiZone_Component_SimpleOpeningFields, )
#else
class AirflowNetwork_MultiZone_Component_SimpleOpeningFields: public ::EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields> {
 public: 
  enum domain 
  {
Name, AirMassFlowCoefficientWhenOpeningisClosed, AirMassFlowExponentWhenOpeningisClosed, MinimumDensityDifferenceforTwoWayFlow, DischargeCoefficient,   };
  AirflowNetwork_MultiZone_Component_SimpleOpeningFields()
   : EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields>(Name) {} 
  AirflowNetwork_MultiZone_Component_SimpleOpeningFields(const std::string &t_name) 
   : EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields>(t_name) {} 
  AirflowNetwork_MultiZone_Component_SimpleOpeningFields(int t_value) 
   : EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields>(t_value) {} 
  static std::string enumName() 
  { return "AirflowNetwork_MultiZone_Component_SimpleOpeningFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields>::integer_value()); }
   private:
    friend class EnumBase<AirflowNetwork_MultiZone_Component_SimpleOpeningFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AirflowNetwork_MultiZone_Component_SimpleOpeningFields::Name, "Name", "Name"},
{ AirflowNetwork_MultiZone_Component_SimpleOpeningFields::AirMassFlowCoefficientWhenOpeningisClosed, "AirMassFlowCoefficientWhenOpeningisClosed", "Air Mass Flow Coefficient When Opening is Closed"},
{ AirflowNetwork_MultiZone_Component_SimpleOpeningFields::AirMassFlowExponentWhenOpeningisClosed, "AirMassFlowExponentWhenOpeningisClosed", "Air Mass Flow Exponent When Opening is Closed"},
{ AirflowNetwork_MultiZone_Component_SimpleOpeningFields::MinimumDensityDifferenceforTwoWayFlow, "MinimumDensityDifferenceforTwoWayFlow", "Minimum Density Difference for Two-Way Flow"},
{ AirflowNetwork_MultiZone_Component_SimpleOpeningFields::DischargeCoefficient, "DischargeCoefficient", "Discharge Coefficient"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AirflowNetwork_MultiZone_Component_SimpleOpeningFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AirflowNetwork_MultiZone_Component_SimpleOpeningFields> OptionalAirflowNetwork_MultiZone_Component_SimpleOpeningFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AIRFLOWNETWORK_MULTIZONE_COMPONENT_SIMPLEOPENING_FIELDENUMS_HXX
