/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SIZINGPERIOD_WEATHERFILEDAYS_FIELDENUMS_HXX
#define UTILITIES_IDD_SIZINGPERIOD_WEATHERFILEDAYS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SizingPeriod_WeatherFileDaysFields
 *  \brief Enumeration of SizingPeriod:WeatherFileDays's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SizingPeriod_WeatherFileDaysFields, )
#else
class SizingPeriod_WeatherFileDaysFields: public ::EnumBase<SizingPeriod_WeatherFileDaysFields> {
 public: 
  enum domain 
  {
Name, BeginMonth, BeginDayofMonth, EndMonth, EndDayofMonth, DayofWeekforStartDay, UseWeatherFileDaylightSavingPeriod, UseWeatherFileRainandSnowIndicators,   };
  SizingPeriod_WeatherFileDaysFields()
   : EnumBase<SizingPeriod_WeatherFileDaysFields>(Name) {} 
  SizingPeriod_WeatherFileDaysFields(const std::string &t_name) 
   : EnumBase<SizingPeriod_WeatherFileDaysFields>(t_name) {} 
  SizingPeriod_WeatherFileDaysFields(int t_value) 
   : EnumBase<SizingPeriod_WeatherFileDaysFields>(t_value) {} 
  static std::string enumName() 
  { return "SizingPeriod_WeatherFileDaysFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SizingPeriod_WeatherFileDaysFields>::integer_value()); }
   private:
    friend class EnumBase<SizingPeriod_WeatherFileDaysFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SizingPeriod_WeatherFileDaysFields::Name, "Name", "Name"},
{ SizingPeriod_WeatherFileDaysFields::BeginMonth, "BeginMonth", "Begin Month"},
{ SizingPeriod_WeatherFileDaysFields::BeginDayofMonth, "BeginDayofMonth", "Begin Day of Month"},
{ SizingPeriod_WeatherFileDaysFields::EndMonth, "EndMonth", "End Month"},
{ SizingPeriod_WeatherFileDaysFields::EndDayofMonth, "EndDayofMonth", "End Day of Month"},
{ SizingPeriod_WeatherFileDaysFields::DayofWeekforStartDay, "DayofWeekforStartDay", "Day of Week for Start Day"},
{ SizingPeriod_WeatherFileDaysFields::UseWeatherFileDaylightSavingPeriod, "UseWeatherFileDaylightSavingPeriod", "Use Weather File Daylight Saving Period"},
{ SizingPeriod_WeatherFileDaysFields::UseWeatherFileRainandSnowIndicators, "UseWeatherFileRainandSnowIndicators", "Use Weather File Rain and Snow Indicators"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SizingPeriod_WeatherFileDaysFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SizingPeriod_WeatherFileDaysFields> OptionalSizingPeriod_WeatherFileDaysFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SIZINGPERIOD_WEATHERFILEDAYS_FIELDENUMS_HXX
