/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_ZONEHVAC_BASEBOARD_RADIANTCONVECTIVE_STEAM_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_ZONEHVAC_BASEBOARD_RADIANTCONVECTIVE_STEAM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields
 *  \brief Enumeration of OS:ZoneHVAC:Baseboard:RadiantConvective:Steam's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields, )
#else
class OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields: public ::EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, HeatingCoilName, FractionRadiant, FractionofRadiantEnergyIncidentonPeople,   };
  OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields()
   : EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields>(Handle) {} 
  OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields(const std::string &t_name) 
   : EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields>(t_name) {} 
  OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields(int t_value) 
   : EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::Handle, "Handle", "Handle"},
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::Name, "Name", "Name"},
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::HeatingCoilName, "HeatingCoilName", "Heating Coil Name"},
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::FractionRadiant, "FractionRadiant", "Fraction Radiant"},
{ OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields::FractionofRadiantEnergyIncidentonPeople, "FractionofRadiantEnergyIncidentonPeople", "Fraction of Radiant Energy Incident on People"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields> OptionalOS_ZoneHVAC_Baseboard_RadiantConvective_SteamFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_ZONEHVAC_BASEBOARD_RADIANTCONVECTIVE_STEAM_FIELDENUMS_HXX
