/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_COOLING_COOLEDBEAM_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_COOLING_COOLEDBEAM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Cooling_CooledBeamFields
 *  \brief Enumeration of OS:Coil:Cooling:CooledBeam's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Cooling_CooledBeamFields, )
#else
class OS_Coil_Cooling_CooledBeamFields: public ::EnumBase<OS_Coil_Cooling_CooledBeamFields> {
 public: 
  enum domain 
  {
Handle, Name, ChilledWaterInletNodeName, ChilledWaterOutletNodeName, CoilSurfaceAreaperCoilLength, ModelParametera, ModelParametern1, ModelParametern2, ModelParametern3, ModelParametera0, ModelParameterK1, ModelParametern, LeavingPipeInsideDiameter,   };
  OS_Coil_Cooling_CooledBeamFields()
   : EnumBase<OS_Coil_Cooling_CooledBeamFields>(Handle) {} 
  OS_Coil_Cooling_CooledBeamFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Cooling_CooledBeamFields>(t_name) {} 
  OS_Coil_Cooling_CooledBeamFields(int t_value) 
   : EnumBase<OS_Coil_Cooling_CooledBeamFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Cooling_CooledBeamFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Cooling_CooledBeamFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Cooling_CooledBeamFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Cooling_CooledBeamFields::Handle, "Handle", "Handle"},
{ OS_Coil_Cooling_CooledBeamFields::Name, "Name", "Name"},
{ OS_Coil_Cooling_CooledBeamFields::ChilledWaterInletNodeName, "ChilledWaterInletNodeName", "Chilled Water Inlet Node Name"},
{ OS_Coil_Cooling_CooledBeamFields::ChilledWaterOutletNodeName, "ChilledWaterOutletNodeName", "Chilled Water Outlet Node Name"},
{ OS_Coil_Cooling_CooledBeamFields::CoilSurfaceAreaperCoilLength, "CoilSurfaceAreaperCoilLength", "Coil Surface Area per Coil Length"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametera, "ModelParametera", "Model Parameter a"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametern1, "ModelParametern1", "Model Parameter n1"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametern2, "ModelParametern2", "Model Parameter n2"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametern3, "ModelParametern3", "Model Parameter n3"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametera0, "ModelParametera0", "Model Parameter a0"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParameterK1, "ModelParameterK1", "Model Parameter K1"},
{ OS_Coil_Cooling_CooledBeamFields::ModelParametern, "ModelParametern", "Model Parameter n"},
{ OS_Coil_Cooling_CooledBeamFields::LeavingPipeInsideDiameter, "LeavingPipeInsideDiameter", "Leaving Pipe Inside Diameter"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Cooling_CooledBeamFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Cooling_CooledBeamFields> OptionalOS_Coil_Cooling_CooledBeamFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_COOLING_COOLEDBEAM_FIELDENUMS_HXX
