/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_DUCT_LOSS_LEAKAGE_FIELDENUMS_HXX
#define UTILITIES_IDD_DUCT_LOSS_LEAKAGE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Duct_Loss_LeakageFields
 *  \brief Enumeration of Duct:Loss:Leakage's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Duct_Loss_LeakageFields, )
#else
class Duct_Loss_LeakageFields: public ::EnumBase<Duct_Loss_LeakageFields> {
 public: 
  enum domain 
  {
Name, AirLoopHVACName, AirflowNetwork_Distribution_LinkageName,   };
  Duct_Loss_LeakageFields()
   : EnumBase<Duct_Loss_LeakageFields>(Name) {} 
  Duct_Loss_LeakageFields(const std::string &t_name) 
   : EnumBase<Duct_Loss_LeakageFields>(t_name) {} 
  Duct_Loss_LeakageFields(int t_value) 
   : EnumBase<Duct_Loss_LeakageFields>(t_value) {} 
  static std::string enumName() 
  { return "Duct_Loss_LeakageFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Duct_Loss_LeakageFields>::integer_value()); }
   private:
    friend class EnumBase<Duct_Loss_LeakageFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Duct_Loss_LeakageFields::Name, "Name", "Name"},
{ Duct_Loss_LeakageFields::AirLoopHVACName, "AirLoopHVACName", "AirLoopHVAC Name"},
{ Duct_Loss_LeakageFields::AirflowNetwork_Distribution_LinkageName, "AirflowNetwork_Distribution_LinkageName", "AirflowNetwork:Distribution:Linkage Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Duct_Loss_LeakageFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Duct_Loss_LeakageFields> OptionalDuct_Loss_LeakageFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_DUCT_LOSS_LEAKAGE_FIELDENUMS_HXX
