/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Pipe_Adiabatic_SteamFields
 *  \brief Enumeration of OS:Pipe:Adiabatic:Steam's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Pipe_Adiabatic_SteamFields, )
#else
class OS_Pipe_Adiabatic_SteamFields: public ::EnumBase<OS_Pipe_Adiabatic_SteamFields> {
 public: 
  enum domain 
  {
Handle, Name, InletNodeName, OutletNodeName,   };
  OS_Pipe_Adiabatic_SteamFields()
   : EnumBase<OS_Pipe_Adiabatic_SteamFields>(Handle) {} 
  OS_Pipe_Adiabatic_SteamFields(const std::string &t_name) 
   : EnumBase<OS_Pipe_Adiabatic_SteamFields>(t_name) {} 
  OS_Pipe_Adiabatic_SteamFields(int t_value) 
   : EnumBase<OS_Pipe_Adiabatic_SteamFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Pipe_Adiabatic_SteamFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Pipe_Adiabatic_SteamFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Pipe_Adiabatic_SteamFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Pipe_Adiabatic_SteamFields::Handle, "Handle", "Handle"},
{ OS_Pipe_Adiabatic_SteamFields::Name, "Name", "Name"},
{ OS_Pipe_Adiabatic_SteamFields::InletNodeName, "InletNodeName", "Inlet Node Name"},
{ OS_Pipe_Adiabatic_SteamFields::OutletNodeName, "OutletNodeName", "Outlet Node Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Pipe_Adiabatic_SteamFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Pipe_Adiabatic_SteamFields> OptionalOS_Pipe_Adiabatic_SteamFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX
