/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_PUMP_VARIABLESPEED_CONDENSATE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_PUMP_VARIABLESPEED_CONDENSATE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Pump_VariableSpeed_CondensateFields
 *  \brief Enumeration of OS:Pump:VariableSpeed:Condensate's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Pump_VariableSpeed_CondensateFields, )
#else
class OS_Pump_VariableSpeed_CondensateFields: public ::EnumBase<OS_Pump_VariableSpeed_CondensateFields> {
 public: 
  enum domain 
  {
Handle, Name, InletNodeName, OutletNodeName, RatedSteamVolumeFlowRate, RatedPumpHead, RatedPowerConsumption, MotorEfficiency, FractionofMotorInefficienciestoFluidStream, Coefficient1ofthePartLoadPerformanceCurve, Coefficient2ofthePartLoadPerformanceCurve, Coefficient3ofthePartLoadPerformanceCurve, Coefficient4ofthePartLoadPerformanceCurve, PumpFlowRateScheduleName, ZoneName, SkinLossRadiativeFraction, DesignPowerSizingMethod, DesignElectricPowerperUnitFlowRate, DesignShaftPowerperUnitFlowRateperUnitHead, EndUseSubcategory,   };
  OS_Pump_VariableSpeed_CondensateFields()
   : EnumBase<OS_Pump_VariableSpeed_CondensateFields>(Handle) {} 
  OS_Pump_VariableSpeed_CondensateFields(const std::string &t_name) 
   : EnumBase<OS_Pump_VariableSpeed_CondensateFields>(t_name) {} 
  OS_Pump_VariableSpeed_CondensateFields(int t_value) 
   : EnumBase<OS_Pump_VariableSpeed_CondensateFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Pump_VariableSpeed_CondensateFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Pump_VariableSpeed_CondensateFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Pump_VariableSpeed_CondensateFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Pump_VariableSpeed_CondensateFields::Handle, "Handle", "Handle"},
{ OS_Pump_VariableSpeed_CondensateFields::Name, "Name", "Name"},
{ OS_Pump_VariableSpeed_CondensateFields::InletNodeName, "InletNodeName", "Inlet Node Name"},
{ OS_Pump_VariableSpeed_CondensateFields::OutletNodeName, "OutletNodeName", "Outlet Node Name"},
{ OS_Pump_VariableSpeed_CondensateFields::RatedSteamVolumeFlowRate, "RatedSteamVolumeFlowRate", "Rated Steam Volume Flow Rate"},
{ OS_Pump_VariableSpeed_CondensateFields::RatedPumpHead, "RatedPumpHead", "Rated Pump Head"},
{ OS_Pump_VariableSpeed_CondensateFields::RatedPowerConsumption, "RatedPowerConsumption", "Rated Power Consumption"},
{ OS_Pump_VariableSpeed_CondensateFields::MotorEfficiency, "MotorEfficiency", "Motor Efficiency"},
{ OS_Pump_VariableSpeed_CondensateFields::FractionofMotorInefficienciestoFluidStream, "FractionofMotorInefficienciestoFluidStream", "Fraction of Motor Inefficiencies to Fluid Stream"},
{ OS_Pump_VariableSpeed_CondensateFields::Coefficient1ofthePartLoadPerformanceCurve, "Coefficient1ofthePartLoadPerformanceCurve", "Coefficient 1 of the Part Load Performance Curve"},
{ OS_Pump_VariableSpeed_CondensateFields::Coefficient2ofthePartLoadPerformanceCurve, "Coefficient2ofthePartLoadPerformanceCurve", "Coefficient 2 of the Part Load Performance Curve"},
{ OS_Pump_VariableSpeed_CondensateFields::Coefficient3ofthePartLoadPerformanceCurve, "Coefficient3ofthePartLoadPerformanceCurve", "Coefficient 3 of the Part Load Performance Curve"},
{ OS_Pump_VariableSpeed_CondensateFields::Coefficient4ofthePartLoadPerformanceCurve, "Coefficient4ofthePartLoadPerformanceCurve", "Coefficient 4 of the Part Load Performance Curve"},
{ OS_Pump_VariableSpeed_CondensateFields::PumpFlowRateScheduleName, "PumpFlowRateScheduleName", "Pump Flow Rate Schedule Name"},
{ OS_Pump_VariableSpeed_CondensateFields::ZoneName, "ZoneName", "Zone Name"},
{ OS_Pump_VariableSpeed_CondensateFields::SkinLossRadiativeFraction, "SkinLossRadiativeFraction", "Skin Loss Radiative Fraction"},
{ OS_Pump_VariableSpeed_CondensateFields::DesignPowerSizingMethod, "DesignPowerSizingMethod", "Design Power Sizing Method"},
{ OS_Pump_VariableSpeed_CondensateFields::DesignElectricPowerperUnitFlowRate, "DesignElectricPowerperUnitFlowRate", "Design Electric Power per Unit Flow Rate"},
{ OS_Pump_VariableSpeed_CondensateFields::DesignShaftPowerperUnitFlowRateperUnitHead, "DesignShaftPowerperUnitFlowRateperUnitHead", "Design Shaft Power per Unit Flow Rate per Unit Head"},
{ OS_Pump_VariableSpeed_CondensateFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Pump_VariableSpeed_CondensateFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Pump_VariableSpeed_CondensateFields> OptionalOS_Pump_VariableSpeed_CondensateFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_PUMP_VARIABLESPEED_CONDENSATE_FIELDENUMS_HXX
