/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_THERMOSTATSETPOINT_THERMALCOMFORT_FANGER_DUALSETPOINT_FIELDENUMS_HXX
#define UTILITIES_IDD_THERMOSTATSETPOINT_THERMALCOMFORT_FANGER_DUALSETPOINT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields
 *  \brief Enumeration of ThermostatSetpoint:ThermalComfort:Fanger:DualSetpoint's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields, )
#else
class ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields: public ::EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields> {
 public: 
  enum domain 
  {
Name, FangerThermalComfortHeatingScheduleName, FangerThermalComfortCoolingScheduleName,   };
  ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields()
   : EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields>(Name) {} 
  ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields(const std::string &t_name) 
   : EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields>(t_name) {} 
  ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields(int t_value) 
   : EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields>(t_value) {} 
  static std::string enumName() 
  { return "ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields>::integer_value()); }
   private:
    friend class EnumBase<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields::Name, "Name", "Name"},
{ ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields::FangerThermalComfortHeatingScheduleName, "FangerThermalComfortHeatingScheduleName", "Fanger Thermal Comfort Heating Schedule Name"},
{ ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields::FangerThermalComfortCoolingScheduleName, "FangerThermalComfortCoolingScheduleName", "Fanger Thermal Comfort Cooling Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields> OptionalThermostatSetpoint_ThermalComfort_Fanger_DualSetpointFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_THERMOSTATSETPOINT_THERMALCOMFORT_FANGER_DUALSETPOINT_FIELDENUMS_HXX
