/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_WALL_EXTERIOR_FIELDENUMS_HXX
#define UTILITIES_IDD_WALL_EXTERIOR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Wall_ExteriorFields
 *  \brief Enumeration of Wall:Exterior's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Wall_ExteriorFields, )
#else
class Wall_ExteriorFields: public ::EnumBase<Wall_ExteriorFields> {
 public: 
  enum domain 
  {
Name, ConstructionName, ZoneName, SpaceName, AzimuthAngle, TiltAngle, StartingXCoordinate, StartingYCoordinate, StartingZCoordinate, Length, Height,   };
  Wall_ExteriorFields()
   : EnumBase<Wall_ExteriorFields>(Name) {} 
  Wall_ExteriorFields(const std::string &t_name) 
   : EnumBase<Wall_ExteriorFields>(t_name) {} 
  Wall_ExteriorFields(int t_value) 
   : EnumBase<Wall_ExteriorFields>(t_value) {} 
  static std::string enumName() 
  { return "Wall_ExteriorFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Wall_ExteriorFields>::integer_value()); }
   private:
    friend class EnumBase<Wall_ExteriorFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Wall_ExteriorFields::Name, "Name", "Name"},
{ Wall_ExteriorFields::ConstructionName, "ConstructionName", "Construction Name"},
{ Wall_ExteriorFields::ZoneName, "ZoneName", "Zone Name"},
{ Wall_ExteriorFields::SpaceName, "SpaceName", "Space Name"},
{ Wall_ExteriorFields::AzimuthAngle, "AzimuthAngle", "Azimuth Angle"},
{ Wall_ExteriorFields::TiltAngle, "TiltAngle", "Tilt Angle"},
{ Wall_ExteriorFields::StartingXCoordinate, "StartingXCoordinate", "Starting X Coordinate"},
{ Wall_ExteriorFields::StartingYCoordinate, "StartingYCoordinate", "Starting Y Coordinate"},
{ Wall_ExteriorFields::StartingZCoordinate, "StartingZCoordinate", "Starting Z Coordinate"},
{ Wall_ExteriorFields::Length, "Length", "Length"},
{ Wall_ExteriorFields::Height, "Height", "Height"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Wall_ExteriorFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Wall_ExteriorFields> OptionalWall_ExteriorFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_WALL_EXTERIOR_FIELDENUMS_HXX
