/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_DUCT_LOSS_MAKEUPAIR_FIELDENUMS_HXX
#define UTILITIES_IDD_DUCT_LOSS_MAKEUPAIR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Duct_Loss_MakeupAirFields
 *  \brief Enumeration of Duct:Loss:MakeupAir's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Duct_Loss_MakeupAirFields, )
#else
class Duct_Loss_MakeupAirFields: public ::EnumBase<Duct_Loss_MakeupAirFields> {
 public: 
  enum domain 
  {
Name, AirLoopHVACName, AirflowNetwork_Distribution_LinkageName,   };
  Duct_Loss_MakeupAirFields()
   : EnumBase<Duct_Loss_MakeupAirFields>(Name) {} 
  Duct_Loss_MakeupAirFields(const std::string &t_name) 
   : EnumBase<Duct_Loss_MakeupAirFields>(t_name) {} 
  Duct_Loss_MakeupAirFields(int t_value) 
   : EnumBase<Duct_Loss_MakeupAirFields>(t_value) {} 
  static std::string enumName() 
  { return "Duct_Loss_MakeupAirFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Duct_Loss_MakeupAirFields>::integer_value()); }
   private:
    friend class EnumBase<Duct_Loss_MakeupAirFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Duct_Loss_MakeupAirFields::Name, "Name", "Name"},
{ Duct_Loss_MakeupAirFields::AirLoopHVACName, "AirLoopHVACName", "AirLoopHVAC Name"},
{ Duct_Loss_MakeupAirFields::AirflowNetwork_Distribution_LinkageName, "AirflowNetwork_Distribution_LinkageName", "AirflowNetwork:Distribution:Linkage Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Duct_Loss_MakeupAirFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Duct_Loss_MakeupAirFields> OptionalDuct_Loss_MakeupAirFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_DUCT_LOSS_MAKEUPAIR_FIELDENUMS_HXX
