/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef ISOMODEL_FORWARDTRANSLATOR_HPP
#define ISOMODEL_FORWARDTRANSLATOR_HPP

#include "ISOModelAPI.hpp"

#include "../utilities/core/Optional.hpp"
#include "../utilities/core/Logger.hpp"
#include "../utilities/core/StringStreamLogSink.hpp"

namespace openstudio {

namespace model {
  class Model;
}

namespace isomodel {

  class UserModel;

  class ISOMODEL_API ForwardTranslator
  {
   public:
    ForwardTranslator();

    virtual ~ForwardTranslator() = default;

    /** Translate an OpenStudio Model to an ISO UserModel. */
    // DLM: should this return an optional UserModel?
    UserModel translateModel(const openstudio::model::Model& model);

    /** Get warning messages generated by the last translation. */
    std::vector<LogMessage> warnings() const;

    /** Get error messages generated by the last translation. */
    std::vector<LogMessage> errors() const;

   private:
    StringStreamLogSink m_logSink;

    REGISTER_LOGGER("openstudio.isomodel.ForwardTranslator");
  };

}  // namespace isomodel
}  // namespace openstudio

#endif  // ISOMODEL_FORWARDTRANSLATOR_HPP
