/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_COMPONENTCOST_LINEITEM_FIELDENUMS_HXX
#define UTILITIES_IDD_COMPONENTCOST_LINEITEM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ComponentCost_LineItemFields
 *  \brief Enumeration of ComponentCost:LineItem's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ComponentCost_LineItemFields, )
#else
class ComponentCost_LineItemFields: public ::EnumBase<ComponentCost_LineItemFields> {
 public: 
  enum domain 
  {
Name, Type, LineItemType, ItemName, ObjectEndUseKey, CostperEach, CostperArea, CostperUnitofOutputCapacity, CostperUnitofOutputCapacityperCOP, CostperVolume, CostperVolumeRate, CostperEnergyperTemperatureDifference, Quantity,   };
  ComponentCost_LineItemFields()
   : EnumBase<ComponentCost_LineItemFields>(Name) {} 
  ComponentCost_LineItemFields(const std::string &t_name) 
   : EnumBase<ComponentCost_LineItemFields>(t_name) {} 
  ComponentCost_LineItemFields(int t_value) 
   : EnumBase<ComponentCost_LineItemFields>(t_value) {} 
  static std::string enumName() 
  { return "ComponentCost_LineItemFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ComponentCost_LineItemFields>::integer_value()); }
   private:
    friend class EnumBase<ComponentCost_LineItemFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ComponentCost_LineItemFields::Name, "Name", "Name"},
{ ComponentCost_LineItemFields::Type, "Type", "Type"},
{ ComponentCost_LineItemFields::LineItemType, "LineItemType", "Line Item Type"},
{ ComponentCost_LineItemFields::ItemName, "ItemName", "Item Name"},
{ ComponentCost_LineItemFields::ObjectEndUseKey, "ObjectEndUseKey", "Object End-Use Key"},
{ ComponentCost_LineItemFields::CostperEach, "CostperEach", "Cost per Each"},
{ ComponentCost_LineItemFields::CostperArea, "CostperArea", "Cost per Area"},
{ ComponentCost_LineItemFields::CostperUnitofOutputCapacity, "CostperUnitofOutputCapacity", "Cost per Unit of Output Capacity"},
{ ComponentCost_LineItemFields::CostperUnitofOutputCapacityperCOP, "CostperUnitofOutputCapacityperCOP", "Cost per Unit of Output Capacity per COP"},
{ ComponentCost_LineItemFields::CostperVolume, "CostperVolume", "Cost per Volume"},
{ ComponentCost_LineItemFields::CostperVolumeRate, "CostperVolumeRate", "Cost per Volume Rate"},
{ ComponentCost_LineItemFields::CostperEnergyperTemperatureDifference, "CostperEnergyperTemperatureDifference", "Cost per Energy per Temperature Difference"},
{ ComponentCost_LineItemFields::Quantity, "Quantity", "Quantity"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ComponentCost_LineItemFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ComponentCost_LineItemFields> OptionalComponentCost_LineItemFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_COMPONENTCOST_LINEITEM_FIELDENUMS_HXX
