/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_PLANTCOMPONENT_TEMPERATURESOURCE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_PLANTCOMPONENT_TEMPERATURESOURCE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_PlantComponent_TemperatureSourceFields
 *  \brief Enumeration of OS:PlantComponent:TemperatureSource's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_PlantComponent_TemperatureSourceFields, )
#else
class OS_PlantComponent_TemperatureSourceFields: public ::EnumBase<OS_PlantComponent_TemperatureSourceFields> {
 public: 
  enum domain 
  {
Handle, Name, InletNode, OutletNode, DesignVolumeFlowRate, TemperatureSpecificationType, SourceTemperature, SourceTemperatureScheduleName,   };
  OS_PlantComponent_TemperatureSourceFields()
   : EnumBase<OS_PlantComponent_TemperatureSourceFields>(Handle) {} 
  OS_PlantComponent_TemperatureSourceFields(const std::string &t_name) 
   : EnumBase<OS_PlantComponent_TemperatureSourceFields>(t_name) {} 
  OS_PlantComponent_TemperatureSourceFields(int t_value) 
   : EnumBase<OS_PlantComponent_TemperatureSourceFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_PlantComponent_TemperatureSourceFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_PlantComponent_TemperatureSourceFields>::integer_value()); }
   private:
    friend class EnumBase<OS_PlantComponent_TemperatureSourceFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_PlantComponent_TemperatureSourceFields::Handle, "Handle", "Handle"},
{ OS_PlantComponent_TemperatureSourceFields::Name, "Name", "Name"},
{ OS_PlantComponent_TemperatureSourceFields::InletNode, "InletNode", "Inlet Node"},
{ OS_PlantComponent_TemperatureSourceFields::OutletNode, "OutletNode", "Outlet Node"},
{ OS_PlantComponent_TemperatureSourceFields::DesignVolumeFlowRate, "DesignVolumeFlowRate", "Design Volume Flow Rate"},
{ OS_PlantComponent_TemperatureSourceFields::TemperatureSpecificationType, "TemperatureSpecificationType", "Temperature Specification Type"},
{ OS_PlantComponent_TemperatureSourceFields::SourceTemperature, "SourceTemperature", "Source Temperature"},
{ OS_PlantComponent_TemperatureSourceFields::SourceTemperatureScheduleName, "SourceTemperatureScheduleName", "Source Temperature Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_PlantComponent_TemperatureSourceFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_PlantComponent_TemperatureSourceFields> OptionalOS_PlantComponent_TemperatureSourceFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_PLANTCOMPONENT_TEMPERATURESOURCE_FIELDENUMS_HXX
