/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AIRLOOPHVAC_OUTDOORAIRSYSTEM_FIELDENUMS_HXX
#define UTILITIES_IDD_AIRLOOPHVAC_OUTDOORAIRSYSTEM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AirLoopHVAC_OutdoorAirSystemFields
 *  \brief Enumeration of AirLoopHVAC:OutdoorAirSystem's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AirLoopHVAC_OutdoorAirSystemFields, )
#else
class AirLoopHVAC_OutdoorAirSystemFields: public ::EnumBase<AirLoopHVAC_OutdoorAirSystemFields> {
 public: 
  enum domain 
  {
Name, ControllerListName, OutdoorAirEquipmentListName,   };
  AirLoopHVAC_OutdoorAirSystemFields()
   : EnumBase<AirLoopHVAC_OutdoorAirSystemFields>(Name) {} 
  AirLoopHVAC_OutdoorAirSystemFields(const std::string &t_name) 
   : EnumBase<AirLoopHVAC_OutdoorAirSystemFields>(t_name) {} 
  AirLoopHVAC_OutdoorAirSystemFields(int t_value) 
   : EnumBase<AirLoopHVAC_OutdoorAirSystemFields>(t_value) {} 
  static std::string enumName() 
  { return "AirLoopHVAC_OutdoorAirSystemFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AirLoopHVAC_OutdoorAirSystemFields>::integer_value()); }
   private:
    friend class EnumBase<AirLoopHVAC_OutdoorAirSystemFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AirLoopHVAC_OutdoorAirSystemFields::Name, "Name", "Name"},
{ AirLoopHVAC_OutdoorAirSystemFields::ControllerListName, "ControllerListName", "Controller List Name"},
{ AirLoopHVAC_OutdoorAirSystemFields::OutdoorAirEquipmentListName, "OutdoorAirEquipmentListName", "Outdoor Air Equipment List Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AirLoopHVAC_OutdoorAirSystemFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AirLoopHVAC_OutdoorAirSystemFields> OptionalAirLoopHVAC_OutdoorAirSystemFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AIRLOOPHVAC_OUTDOORAIRSYSTEM_FIELDENUMS_HXX
